<?php
    $getSetting = App\Models\WebsiteSettings::first();
?>

<aside class="ps-3 pe-2 py-2 sidebar">
    <div class="flex-grow-1">
        <div class="d-flex align-items-center mb-2 logo-info">
            <div class="d-flex align-items-center   ">
                <a href="<?php echo e(url('account/dashboard')); ?>" title="logo" class="brand-icon ">
                    <img src="<?php echo e(url('upload/' . $getSetting->website_logo)); ?>" style="width: 150px; height: 30px;"/>
                </a>
            </div>
            <button class="btn btn-sm btn-close sidebar-toggle  border ms-auto d-lg-none" type="button"></button>
            <a class="ms-auto d-lg-inline-flex d-none menu-toggle shadow-sm align-items-center justify-content-center mini-btn"
                href="#" title="Sidebar Toggle">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                    <path d="M15 12h-12"></path>
                    <path d="M7 8l-4 4l4 4"></path>
                    <path d="M12 21a9 9 0 0 0 0 -18"></path>
                </svg>
            </a>
        </div>
        <h6 class="fl-title title-font ps-2 small text-uppercase text-muted"
            style="--dynamic-color: var(--theme-color1)">Main</h6>
        <ul class="list-unstyled mb-2 menu-list ps-3">
            <li>
                <a href="<?php echo e(url('account/dashboard')); ?>" aria-label="Dashboard" data-bs-placement="right"
                    data-bs-title="Dashboard" data-bs-toggle="tooltip">
                    <svg class="svg-stroke" xmlns="http://www.w3.org/2000/svg" width="24" viewBox="0 0 24 24"
                        stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path d="M5 12l-2 0l9 -9l9 9l-2 0"></path>
                        <path d="M5 12v7a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-7"></path>
                        <path d="M10 12h4v4h-4z"></path>
                    </svg>
                    <span class="mx-3">Dashboard</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(url('account/deposit')); ?>" aria-label="Balance" data-bs-toggle="tooltip"
                    data-bs-title="Balance" data-bs-placement="right">
                    <svg class="svg-stroke" xmlns="http://www.w3.org/2000/svg" width="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round"
                        stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path d="M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"></path>
                        <path d="M3 6m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z">
                        </path>
                        <path d="M18 12l.01 0"></path>
                        <path d="M6 12l.01 0"></path>
                    </svg>
                    <span class="mx-3">Deposit</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(url('account/loan')); ?>" aria-label="Card" data-bs-toggle="tooltip" data-bs-title="Card"
                    data-bs-placement="right">
                    <i class="fa-solid fa-landmark"></i>
                    <span class="mx-3">Loan</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(url('account/transfer')); ?>" aria-label="Card" data-bs-toggle="tooltip" data-bs-title="Card"
                    data-bs-placement="right">
                    <i class="fa-solid fa-money-bill-transfer"></i>
                    <span class="mx-3">Transfer</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(url('account/cards')); ?>" aria-label="Card" data-bs-toggle="tooltip" data-bs-title="Card"
                    data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" class="svg-stroke" width="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path d="M3 5m0 3a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v8a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3z">
                        </path>
                        <path d="M3 10l18 0"></path>
                        <path d="M7 15l.01 0"></path>
                        <path d="M11 15l2 0"></path>
                    </svg>
                    <span class="mx-3">Card</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(url('account/transactions')); ?>" aria-label="Card" data-bs-toggle="tooltip" data-bs-title="Card"
                    data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" class="svg-stroke" width="24"
                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-linecap="round"
                                stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M5 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                <path d="M19 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                <path d="M19 8v5a5 5 0 0 1 -5 5h-3l3 -3m0 6l-3 -3"></path>
                                <path d="M5 16v-5a5 5 0 0 1 5 -5h3l-3 -3m0 6l3 -3"></path>
                            </svg>
                    <span class="mx-3">Transactions</span>
                </a>
            </li>
        </ul>
        <h6 class="fl-title title-font ps-2 small text-uppercase text-muted"
            style="--dynamic-color: var(--theme-color1)">Others</h6>
        <ul class="list-unstyled mb-2 menu-list ps-3">
            <li>
                <a href="<?php echo e(url('account/profile')); ?>" aria-label="Integrations" data-bs-toggle="tooltip"
                    data-bs-title="Integrations" data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                        class="svg-stroke">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path d="M8 7a4 4 0 1 0 8 0a4 4 0 0 0 -8 0"></path>
                        <path d="M6 21v-2a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v2"></path>
                    </svg>
                    <span class="mx-3">Profile</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(url('account/security')); ?>" aria-label="Settings" data-bs-toggle="tooltip"
                    data-bs-title="Settings" data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" class="svg-stroke" width="24" viewBox="0 0 24 24"
                        stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M11.5 21h-4.5a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2" />
                        <path d="M11 16a1 1 0 1 0 2 0a1 1 0 0 0 -2 0" />
                        <path d="M8 11v-4a4 4 0 1 1 8 0v4" />
                        <path d="M20 21l2 -2l-2 -2" />
                        <path d="M17 17l-2 2l2 2" />
                    </svg>
                    <span class="mx-3">Security</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(url('account/pin')); ?>" aria-label="Settings" data-bs-toggle="tooltip"
                    data-bs-title="Settings" data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                        class="svg-stroke">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path d="M5 11m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v6a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z">
                        </path>
                        <path d="M12 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                        <path d="M8 11v-5a4 4 0 0 1 8 0"></path>
                    </svg>
                    <span class="mx-3">Pin Management</span>
                </a>
            </li>
            
            <li>
                <a href="<?php echo e(url('account/activity')); ?>" aria-label="Settings" data-bs-toggle="tooltip"
                    data-bs-title="Settings" data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" class="svg-stroke" width="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path
                            d="M15 21h-9a3 3 0 0 1 -3 -3v-1h10v2a2 2 0 0 0 4 0v-14a2 2 0 1 1 2 2h-2m2 -4h-11a3 3 0 0 0 -3 3v11">
                        </path>
                        <path d="M9 7l4 0"></path>
                        <path d="M9 11l4 0"></path>
                    </svg>
                    <span class="mx-3">Activity Log</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(url('account/chat')); ?>" aria-label="Settings" data-bs-toggle="tooltip"
                    data-bs-title="Settings" data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" class="svg-stroke" width="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path
                            d="M15 21h-9a3 3 0 0 1 -3 -3v-1h10v2a2 2 0 0 0 4 0v-14a2 2 0 1 1 2 2h-2m2 -4h-11a3 3 0 0 0 -3 3v11">
                        </path>
                        <path d="M9 7l4 0"></path>
                        <path d="M9 11l4 0"></path>
                    </svg>
                    <span class="mx-3">FAQ Chat</span>
                </a>
            </li>
        </ul>

    </div>
    <div>

        <div class="row g-0 align-items-center mb-2 mt-2">
            <div class="col text-truncate ">
                <div class="d-flex align-items-center profile">
                    <?php if(Auth::user()->photo): ?>
                        <img src="<?php echo e(url('upload/', Auth::user()->photo)); ?>" alt="Avatar"
                            class="rounded-circle avatar">
                    <?php endif; ?>
                    <div class="ms-3 profile-text">
                        <a href="#" title="" class="small"><?php echo e(Auth::user()->firstname); ?>

                            <?php echo e(Auth::user()->lastname); ?></a>
                        <p class="mb-0 small"><?php echo e(Auth::user()->email); ?></p>
                    </div>
                </div>
            </div>
            <!-- Dropdown -->
            <div class="col-auto">
                <div class="dropdown dropstart">
                    <a href="#" class="btn btn-link btn-sm dropdown-toggle" role="button"
                        data-bs-toggle="dropdown" aria-haspopup="true" data-expanded="false"
                        aria-expanded="false"></a>
                    <div class="dropdown-menu">
                        <a href="<?php echo e(url('account/profile')); ?>" class="dropdown-item">profile</a>

                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                            <?php echo csrf_field(); ?>
                            <a href="<?php echo e(route('logout')); ?>"
                                onclick="event.preventDefault(); this.closest('form').submit();"
                                class="dropdown-item">Sign out</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card promo">
            <div class="card-body">
                
            </div>
        </div>
    </div>
</aside>
<?php /**PATH C:\Users\allej\OneDrive\Desktop\AAAWORK\BANK\babank\resources\views\layouts\user\sidebar.blade.php ENDPATH**/ ?>