<!DOCTYPE html>
<html lang="en">

<head>
    <?php echo $__env->make('layouts.user.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body data-theme="theme-Greylight" class="svgstroke-a add-tooltip">
    <main class="container-fluid px-0">
        <!-- start: page menu link -->
        <?php echo $__env->make('layouts.user.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="content">
            <!-- start: page header -->
            <?php echo $__env->make('layouts.user.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- start: page header area -->
            <?php echo e($slot); ?>

        </div>
    </main>

    <!-- start: exchange rate -->
    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvas_exchange" aria-labelledby="offcanvas_exchange">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title">Exchange Rate</h5>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body px-0">
            <!-- EXCHANGERATES.ORG.UK US Dollar EXCHANGE RATE TABLE START -->
            <div style="width:178px;;margin:0;padding:0;border:1px solid #2D6AB4;background:#F0F0F0;">
                <div
                    style="width:100%;text-align:center;padding:2px 0px;background:#2D6AB4;font-family:arial;font-size:11px;color:#FFFFFF;font-weight:bold;vertical-align:middle;">
                    <img src="//www.exchangerates.org.uk/images/flags/us.gif" style="padding-right:5px;">
                    <a rel="nofollow" style="color:#FFFFFF;text-decoration:none;text-transform:uppercase;"
                        href="//www.exchangerates.org.uk/US-Dollar-USD-currency-table.html" target="_new"
                        title="US Dollar Exchange Rate">US Dollar Exchange Rate</a>
                </div>
                <div style="padding:10px;">
                    <script type="text/javascript">
                        var dcf = 'USD';
                        var mc = '2D6AB4';
                        var mbg = 'F0F0F0';
                        var tc = 'FFFFFF';
                        var f = 'arial';
                        var fc = '000000';
                        var tz = '-6';
                    </script>
                    <script type="text/javascript" src="https://www.currency.me.uk/remote/ER-TCS-1.php"></script>
                </div>
            </div>
            <!-- EXCHANGERATES.ORG.UK US Dollar EXCHANGE RATE TABLE END -->
        </div>
    </div>


    <!-- Floating Chat Bot Icon -->
    <div id="chatbot-toggle">
        <i class="bi bi-headset"></i> <!-- Robot icon -->
    </div>

    <!-- Floating Message after Chat Closes
 <div id="chatbot-floating-message">
     Need help? Click to chat! <i class="bi bi-chat-text"></i>
 </div> -->

    <!-- Chatbot Widget -->
    <div id="chatbot-widget">
        <div class="card-bs p-3 p-sm-4 animation-element">
            <div id="chatbot-header">
                Chat with Adrian <span id="close-chatbot">&times;</span>
            </div>
            <div id="chatbot-messages"></div>
            <div id="chatbot-keywords" class="p-2"></div>
            <div class="chatbot-input-container">
                <input type="text" id="chatbot-input" class="form-control" placeholder="Type your message..." />
                <button class="btn btn-sm btn-primary" type="button" id="send-message"
                    onclick="sendMessageFromInput()">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                        class="bi bi-send-fill" viewBox="0 0 16 16">
                        <path
                            d="M15.964.686a.5.5 0 0 0-.65-.65L.767 5.855H.766l-.452.18a.5.5 0 0 0-.082.887l.41.26.001.002 4.995 3.178 3.178 4.995.002.002.26.41a.5.5 0 0 0 .886-.083zm-1.833 1.89L6.637 10.07l-.215-.338a.5.5 0 0 0-.154-.154l-.338-.215 7.494-7.494 1.178-.471z" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <style>
        /* Floating Chat Bot Button */
        #chatbot-toggle {
            position: fixed;
            bottom: 20px;
            right: 20px;
            background: #0f0d06;
            color: white;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 28px;
            cursor: pointer;
            box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.3);
        }

        #chatbot-toggle {
            cursor: pointer;
            animation: bounce 1s ease infinite;
            /* Continuous bounce */
        }

        @keyframes bounce {
            0% {
                transform: translateY(0);
            }

            30% {
                transform: translateY(-10px);
                /* Move up */
            }

            50% {
                transform: translateY(0);
                /* Return to normal */
            }

            70% {
                transform: translateY(-5px);
                /* Slight move up */
            }

            100% {
                transform: translateY(0);
                /* Return to normal */
            }
        }

        #chatbot-toggle i {
            font-size: 30px;
            /* Icon size */
        }

        /* Floating Message */
        #chatbot-floating-message {
            position: fixed;
            bottom: 80px;
            right: 20px;
            background: #0f0d06;
            color: white;
            padding: 4px 10px;
            border-radius: 20px;
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
            box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.3);
            opacity: 1;
        }

        #chatbot-floating-message i {
            font-size: 18px;
        }

        /* Chatbot Widget */
        #chatbot-widget {
            position: fixed;
            bottom: 80px;
            right: 20px;
            width: 400px;
            background: #0f0d06;
            border: 1px solid #221e1e;
            box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.2);
            display: none;
            border-radius: 8px;
            overflow: hidden;
        }

        #chatbot-header {
            background: ;
            color: white;
            padding: 12px;
            font-size: 14px;
            font-weight: bold;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        #chatbot-messages {
            height: 450px;
            overflow-y: auto;
            padding: 10px;
            display: flex;
            flex-direction: column;
        }

        .chatbot-input-container {
            display: flex;
            padding: 10px;
            border-top: 1px solid #ddd;
        }

        #chatbot-input {
            flex: 1;
            padding: 8px;
            color: #ffffff;
            border: 1px solid #2b2424;
            border-radius: 4px;
            margin-right: 5px;
        }

        #send-message {
            padding: 8px 12px;
            border-radius: 4px;
            background: #383734;
        }

        /* Message Styles */
        .message {
            max-width: 80%;
            padding: 8px 12px;
            margin: 5px 0;
            border-radius: 10px;
            font-size: 14px;
            display: inline-block;
            word-wrap: break-word;
        }

        .user-message {
            background: #756f12;
            color: white;
            align-self: flex-start;
            border-bottom-left-radius: 2px;
        }

        .bot-message {
            background: #f1f1f1;
            color: black;
            align-self: flex-end;
            border-bottom-right-radius: 2px;
        }

        /* Typing Animation */
        .typing-animation {
            display: flex;
            align-items: center;
            font-size: 14px;
            color: gray;
            animation: fadeIn 0.3s ease-in-out;
        }

        .typing-animation span {
            animation: typingDots 1.5s infinite;
        }

        @keyframes typingDots {
            0% {
                opacity: 0.3;
            }

            50% {
                opacity: 1;
            }

            100% {
                opacity: 0.3;
            }
        }

        /* Fade-in and Fade-out Animation */
        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes fadeOut {
            from {
                opacity: 1;
            }

            to {
                opacity: 0;
            }
        }

        #chatbot-keywords {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            padding: 10px;
        }

        .keyword-button {
            background: #40440b;
            color: #ffcc00;
            border: none;
            padding: 6px 12px;
            border-radius: 16px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
        }

        .keyword-button:hover {
            background: #0056b3;
            color: white;
            /* 👈 Optional: change text color on hover */
        }
    </style>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let chatbotWidget = document.getElementById('chatbot-widget');
            let chatbotToggle = document.getElementById('chatbot-toggle');
            let closeChatbot = document.getElementById('close-chatbot');
            let chatMessages = document.getElementById('chatbot-messages');
            let floatingMessage = null;
            let keywordContainer = document.getElementById('chatbot-keywords');

            function addIntroMessage() {
                let existingMessages = chatMessages.querySelectorAll('.message').length;
                if (existingMessages === 0) {
                    let introMessage = document.createElement('div');
                    introMessage.classList.add('message', 'bot-message');
                    introMessage.innerText =
                        "Hello! <?php echo e(Auth::user()->firstname); ?>.  I'm Adrian, How can I assist you today?";
                    chatMessages.appendChild(introMessage);
                    chatMessages.scrollTop = chatMessages.scrollHeight;
                }
            }

            // Toggle chatbot visibility
            chatbotToggle.addEventListener('click', function() {
                chatbotWidget.style.display = chatbotWidget.style.display === 'block' ? 'none' : 'block';

                if (floatingMessage) {
                    floatingMessage.style.opacity = 0;
                    floatingMessage.remove();
                    floatingMessage = null;
                }

                if (chatbotWidget.style.display === 'block') {
                    setTimeout(addIntroMessage, 2000);
                }
            });

            closeChatbot.addEventListener('click', function() {
                chatbotWidget.style.display = 'none';
                showFloatingMessage("Chat closed! Click to reopen.");
            });

            function showFloatingMessage(text) {
                if (floatingMessage) return;

                floatingMessage = document.createElement('div');
                floatingMessage.innerText = text;
                floatingMessage.classList.add('chatbot-floating-message');

                document.body.appendChild(floatingMessage);

                setTimeout(() => {
                    floatingMessage.classList.add('fade-out');
                    setTimeout(() => {
                        floatingMessage.remove();
                        floatingMessage = null;
                    }, 1000);
                }, 1000);
            }

            // Load keyword buttons
            function fetchKeywords() {
                const maxKeywords = 6; // 👈 Set your limit here

                fetch("/chatbot/keywords")
                    .then(res => res.json())
                    .then(data => {
                        // Shuffle the keywords array randomly
                        const shuffled = data.keywords.sort(() => 0.5 - Math.random());

                        // Pick only the first `maxKeywords` from the shuffled array
                        const limitedKeywords = shuffled.slice(0, maxKeywords);

                        // Render the keyword buttons
                        keywordContainer.innerHTML = limitedKeywords.map(keyword => `
                        <button class="btn btn-outline-primary text-white m-1 keyword-button"
                            onclick="sendMessage('${keyword}')">
                            ${keyword}
                        </button>
                    `).join('');
                    })
                    .catch(console.error);
            }


            fetchKeywords();

            // Load previous messages from session
            fetch("/chatbot/messages")
                .then(res => res.json())
                .then(data => {
                    chatMessages.innerHTML = "";
                    data.messages.forEach(msg => {
                        let messageDiv = document.createElement('div');
                        messageDiv.classList.add('message', msg.type === 'user' ? 'user-message' :
                            'bot-message');
                        messageDiv.innerText = msg.text;
                        chatMessages.appendChild(messageDiv);
                    });
                    chatMessages.scrollTop = chatMessages.scrollHeight;
                });

            // Handle click on send button
            window.sendMessage = function(text) {
                if (!text) return;

                let userMessage = document.createElement('div');
                userMessage.classList.add('message', 'user-message');
                userMessage.innerText = text;
                chatMessages.appendChild(userMessage);
                chatMessages.scrollTop = chatMessages.scrollHeight;

                let typingDiv = document.createElement('div');
                typingDiv.classList.add('typing-animation');
                typingDiv.innerHTML = "<span>Adrian is typing...</span>";
                chatMessages.appendChild(typingDiv);
                chatMessages.scrollTop = chatMessages.scrollHeight;

                fetch("/chatbot", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json",
                            "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
                        },
                        body: JSON.stringify({
                            message: text
                        })
                    })
                    .then(res => res.json())
                    .then(data => {
                        setTimeout(() => {
                            typingDiv.remove();

                            let botMessage = document.createElement('div');
                            botMessage.classList.add('message', 'bot-message');
                            botMessage.innerText = data.response;
                            botMessage.style.opacity = 0;

                            chatMessages.appendChild(botMessage);
                            chatMessages.scrollTop = chatMessages.scrollHeight;

                            setTimeout(() => botMessage.style.opacity = 1, 200);

                            // Render keyword buttons if available
                            if (data.keywords && data.keywords.length > 0) {
                                // Don't clear existing keywords
                                data.keywords.forEach(keyword => {
                                    // Only add new keyword buttons if they don't already exist
                                    if (!Array.from(keywordContainer.children).some(btn =>
                                            btn.innerText === keyword)) {
                                        let btn = document.createElement('button');
                                        btn.classList.add('btn', 'btn-outline-primary',
                                            'text-white', 'm-1', 'keyword-button');
                                        btn.innerText = keyword;
                                        btn.onclick = () => sendMessage(keyword);
                                        keywordContainer.appendChild(btn);
                                    }
                                });
                            }
                        }, 1000);
                    });
            };

            // 👇 Add this below
            window.sendMessageFromInput = function() {
                const inputField = document.getElementById("chatbot-input");
                const message = inputField.value.trim();

                if (message !== "") {
                    sendMessage(message);
                    inputField.value = ""; // Clear the input field
                }
            };

            const inputField = document.getElementById("chatbot-input");
            inputField.addEventListener("keydown", function(e) {
                if (e.key === "Enter") {
                    e.preventDefault(); // prevent form submission if inside a form
                    window.sendMessageFromInput();
                }
            });

        });
    </script>

    <?php echo $__env->make('layouts.user.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>

</html>
<?php /**PATH C:\Users\allej\KEEP\AAAWORK\BANK\babank\resources\views/components/user.blade.php ENDPATH**/ ?>