<?php if (isset($component)) { $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.user','data' => ['notifications' => $notifications]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['notifications' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($notifications)]); ?>
    <!-- start: page body area -->
    <div class="px-xl-5 px-lg-4 px-3 py-3 page-body">
        <div class="row g-3 mb-3 row-deck">
            <div class="col-md-6 col-lg-6 col-xl-6">
                <div class="card">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success mb-1 alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>
                    <div class="card-body">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>Account Balance</div>
                                    <div class="row gx-0 d-inline-flex">
                                        <div class="col-auto align-self-center">
                                            <?php if(!empty(Auth::user()->photo)): ?>
                                                <img src="<?php echo e(url('upload/', Auth::user()->photo)); ?>" alt="User-Profile"
                                                    class="rounded-circle object-fit-cover"
                                                    style="width: 40px; height: 40px;">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="py-4 m-0 text-center h1 fw-bold">
                                    <?php echo e(Auth::user()->acct_currency); ?><?php echo e(number_format(Auth::user()->account_balance, 2)); ?>

                                </div>

                                <div class="d-flex">
                                    <div>
                                        <span
                                            class="badge bg-secondary text-white"><?php echo e(Auth::user()->account_type); ?></span>
                                    </div>

                                    <div class="ms-auto">
                                        <?php if(Auth::user()->acct_status === 'Active'): ?>
                                            <span class="badge bg-success text-white">Active Account</span>
                                        <?php elseif(Auth::user()->acct_status === 'Location'): ?>
                                            <span class="badge bg-secondary text-white">Inactive Account</span>
                                        <?php elseif(Auth::user()->acct_status === 'Suspended'): ?>
                                            <span class="badge bg-danger text-white">Suspended Account</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
            <div class="col-md-6 col-lg-12 col-xl-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title mb-0">Account Overview</h6>
                    </div>
                    <div class="card-body row bg-light g-0">
                        <div class="col-6">
                            <div class="d-flex align-items-center border-end">
                                <div class="avatar rounded-circle no-thumbnail"><i
                                        class="fa fa-long-arrow-down fa-lg"></i>
                                </div>
                                <div class="flex-fill ms-3 text-truncate">
                                    <div>Total Credit</div>
                                    <div><span
                                            class="fw-medium"><?php echo e(Auth::user()->acct_currency); ?><?php echo e(number_format($totalCredit, 2)); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex align-items-center ms-3">
                                <div class="avatar rounded-circle no-thumbnail"><i
                                        class="fa fa-long-arrow-up fa-lg"></i>
                                </div>
                                <div class="flex-fill ms-3 text-truncate">
                                    <div>Total Debit</div>
                                    <div><span class="fw-medium"><?php echo e(Auth::user()->acct_currency); ?><?php echo e(number_format($totalDebit, 2)); ?></span></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body row bg-light g-0" style="margin-top: 10px">
                        <div class="col-6">
                            <div class="d-flex align-items-center border-end">
                                <div class="avatar rounded-circle no-thumbnail"><i class="fa-solid fa-landmark"></i>
                                </div>
                                <div class="flex-fill ms-3 text-truncate">
                                    <div>Loan Balance</div>
                                    <div><span
                                            class="fw-medium"><?php echo e(Auth::user()->acct_currency); ?><?php echo e(number_format(Auth::user()->loan_balance, 2)); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex align-items-center ms-3">
                                <div class="avatar rounded-circle no-thumbnail"><i class="fa-solid fa-dollar-sign"></i>
                                </div>
                                <div class="flex-fill ms-3 text-truncate">
                                    <div>Pending Balance</div>
                                    <div><span class="fw-medium"><?php echo e(Auth::user()->acct_currency); ?><?php echo e(number_format($pendingamount, 2)); ?></span></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row g-3 mb-3 row-deck">

            <div class="col-md-6 col-lg-12 col-xl-12">
                <div class="card">
                    <div class="card-header ">
                        <h6 class="card-title mb-0 fw-bold">Recent Transaction</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="border p-4 rounded-2 rounded-4">
                                    <table id="transactionTable" class="display table table-bordered"
                                        style="width:100%">
                                        <thead>
                                            <tr class="text-center">
                                                <th>#</th>
                                                <th>Account Name</th>
                                                <th>Amount</th>
                                                <th>Description</th>
                                                <th>Transaction Type</th>
                                                <th>Date</th>
                                                <th>Status</th>
                                                <th>Receipt</th> <!-- Add Action Column -->
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transactions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr class="item_trans" data-id="<?php echo e($transactions->id); ?>"
                                                    data-reference="<?php echo e($transactions->reference); ?>"
                                                    data-bank-name="<?php echo e($transactions->bank_name); ?>"
                                                    data-account-name="<?php echo e($transactions->account_name); ?>"
                                                    data-amount="<?php echo e($transactions->amount); ?>"
                                                    data-description="<?php echo e($transactions->description); ?>"
                                                    data-toggle="modal" data-target="#mdllDetailsTrans">
                                                    <td></td>
                                                    <td><?php echo e($transactions->account_name); ?></td>
                                                    <td><?php echo e(Auth::user()->acct_currency); ?><?php echo e(number_format($transactions->amount, 2)); ?>

                                                    </td>
                                                    <td><?php echo e($transactions->description); ?></td>
                                                    <td><?php echo e($transactions->transaction_type); ?></td>
                                                    <td><?php echo e(\Carbon\Carbon::parse($transactions->created_at)->format('d F Y')); ?>

                                                    </td>
                                                    <td>
                                                        <span>
                                                            <?php if($transactions->status === 'Pending'): ?>
                                                                <span class="badge bg-warning">Pending</span>
                                                                <!-- Bootstrap primary color -->
                                                            <?php elseif($transactions->status === 'Processing'): ?>
                                                                <span class="badge bg-info">Processing</span>
                                                            <?php elseif($transactions->status === 'Completed'): ?>
                                                                <span class="badge bg-success">Completed</span>
                                                            <?php elseif($transactions->status === 'Failed'): ?>
                                                                <span class="badge bg-danger">Failed</span>
                                                            <?php endif; ?>
                                                        </span>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php if(in_array($transactions->transaction_type, ['Credit', 'Debit', 'Domestic Transfer'])): ?>
                                                            <a href="<?php echo e(url('account/domestic_success', ['id' => $transactions->reference])); ?>"
                                                                class="btn btn-secondary btn-sm">
                                                                <i class="bi bi-receipt"></i>
                                                            </a>
                                                        <?php elseif($transactions->transaction_type === 'Wire Transfer'): ?>
                                                            <a href="<?php echo e(url('account/transfer_success', ['id' => $transactions->reference])); ?>"
                                                                class="btn btn-secondary btn-sm">
                                                                <i class="bi bi-receipt"></i>
                                                            </a>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="100%"> No Record Found.</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <a href="<?php echo e(url('account/transactions')); ?>"
                            class="mt-3 btn btn-grey-outline w-100 fw-medium">Show
                            All</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $attributes = $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $component = $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php /**PATH C:\Users\allej\OneDrive\Desktop\AAAWORK\BANK\babank\resources\views/account/dashboard.blade.php ENDPATH**/ ?>