<?php
    $getSetting = App\Models\WebsiteSettings::first();
?>

<header class="adminuiux-header">
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container-fluid">
            <button class="btn btn-link btn-square sidebar-toggler" type="button" onclick="initSidebar()"><i class="sidebar-svg" data-feather="menu"></i></button>
            <a class="navbar-brand" href="investment-dashboard.html">
                <div class="">
                    <span class="h4"><img data-bs-img="light" src="<?php echo e(url('upload/'.$getSetting->website_logo)); ?>" width="150" alt="Logo" /></span>
                </div>
            </a>
            <div class="ms-auto">
                <button class="btn btn-link btn-square btnsunmoon btn-link-header" id="btn-layout-modes-dark-page"><i class="sun mx-auto" data-feather="sun"></i> <i class="moon mx-auto" data-feather="moon"></i></button>
                
                <div class="dropdown d-none d-sm-inline-block">
                    <div class="gtranslate_wrapper"></div>
                    <script>window.gtranslateSettings = {"default_language":"en","detect_browser_language":true,"languages":["en","ar","fr","de","zh-CN"],"wrapper_selector":".gtranslate_wrapper"}</script>
                    <script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
                </div>
                <div class="dropdown d-inline-block">
                    <a class="dropdown-toggle btn btn-link btn-square btn-link-header style-none no-caret px-0" id="userprofiledd" data-bs-toggle="dropdown" aria-expanded="false" role="button">
                        <div class="row gx-0 d-inline-flex">
                            <div class="col-auto align-self-center">
                                <figure class="avatar avatar-28 rounded-circle coverimg align-middle">
                                    <?php if(!empty(Auth::user()->photo)): ?>
                                        <img src="<?php echo e(url('upload/', Auth::user()->photo)); ?>" alt="User-Profile">
                                    <?php endif; ?>
                                </figure>
                            </div>
                        </div>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end width-300 pt-0 px-0 sm-mi-45px" aria-labelledby="userprofiledd">
                        <div class="bg-theme-1-space rounded py-3 mb-3 dropdown-dontclose">
                            <div class="row gx-0">
                                <div class="col-auto px-3">
                                    <figure class="avatar avatar-50 rounded-circle coverimg align-middle">
                                        <?php if(!empty(Auth::user()->photo)): ?>
                                            <img src="<?php echo e(url('upload/', Auth::user()->photo)); ?>" alt="User-Profile">
                                        <?php endif; ?>
                                    </figure>
                                </div>
                                <div class="col align-self-center">
                                    <p class="mb-1"><span><?php echo e(Auth::user()->firstname); ?> <?php echo e(Auth::user()->lastname); ?></span></p>
                                    <p><i class="bi bi-wallet2 me-2"></i><?php echo e(Auth::user()->acct_currency); ?> <?php echo e(number_format(Auth::user()->account_balance, 2)); ?><small class="opacity-50"></small></p>
                                </div>
                            </div>
                        </div>
                        <div class="px-2">
                            <div>
                                <a class="dropdown-item" href="<?php echo e(url('account/profile')); ?>"><i data-feather="user" class="avatar avatar-18 me-1"></i> My Profile</a>
                            </div>
                            <div>
                                <a class="dropdown-item" href="#">
                                    <div class="row">
                                        <div class="col"><i data-feather="gift" class="avatar avatar-18 me-1"></i> Account Status</div>
                                        <div class="col-auto"><p class="small text-success"><?php echo e(Auth::user()->acct_status); ?></p></div>
                                        <div class="col-auto"><span class="arrow bi bi-chevron-right"></span></div>
                                    </div>
                                </a>
                            </div>
                            <div>
                                <a class="dropdown-item" href="investment-settings.html"><i data-feather="settings" class="avatar avatar-18 me-1"></i> Account Setting</a>
                            </div>
                            <div>
                                <form method="POST" action="<?php echo e(route('logout')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); this.closest('form').submit();" class="dropdown-item theme-red"><i data-feather="power" class="avatar avatar-18 me-1"></i> Logout</a>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <button
                    class="navbar-toggler btn btn-link btn-link-header btn-square btn-icon collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#header-navbar"
                    aria-controls="header-navbar"
                    aria-expanded="false"
                    aria-label="Toggle navigation"
                >
                    <i data-feather="more-vertical" class="openbtn"></i> <i data-feather="x" class="closebtn"></i>
                </button>
            </div>
        </div>
    </nav>
</header><?php /**PATH C:\Users\allej\OneDrive\Desktop\AAAWORK\BANK\babank\resources\views\layouts\user\Anavbar.blade.php ENDPATH**/ ?>