<?php
    $getSetting = App\Models\WebsiteSettings::first();
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($emailData['subject']); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 100%;
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        .header {
            background: #0a1c30;
            color: #ffffff;
            padding: 20px;
        }
        .logo {
            max-width: 150px;
            margin-bottom: 10px;
        }
        .website-name {
            font-size: 22px;
            font-weight: bold;
            margin: 5px 0;
        }
        .content {
            padding: 20px;
            font-size: 16px;
            color: #333333;
            line-height: 1.6;
            text-align: center; /* Center aligns the content */
        }
        .footer {
            background: #f4f4f4;
            text-align: center;
            padding: 15px;
            font-size: 14px;
            color: #777777;
        }
        .btn {
            display: inline-block;
            background: #0a1c30;
            color: #ffffff;
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 5px;
            margin-top: 20px;
        }
        .btn:hover {
            background: #0a1c30;
        }
        .contact-info {
            margin-top: 10px;
            font-size: 14px;
            color: #555555;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Email Header -->
        <div class="header">
            <img src="<?php echo e(url('upload/'.$getSetting->website_logo)); ?>" alt="Website Logo" class="logo">  
            <div class="website-name"><?php echo e($getSetting->website_name); ?></div>
        </div>

        <!-- Email Content -->
        <div class="content">
            <p>Dear <?php echo e($emailData['email']); ?>,</p>
            <p style="text-align: center;"><?php echo e($emailData['message']); ?></p>

            <a href="#" class="btn">Visit Our Website</a>
        </div>

        <!-- Email Footer -->
        <div class="footer">
            <strong><?php echo e($getSetting->website_name); ?></strong> <br>
            <span class="contact-info"><?php echo e($getSetting->website_address); ?> | <?php echo e($getSetting->website_email); ?> | <?php echo e($getSetting->website_phone); ?></span>
            <br>
            <span>&copy; <span id="currentYear"></span> <?php echo e($getSetting->website_name); ?>. All Rights Reserved.</span>
        </div>
    </div>

    <script>
        document.getElementById("currentYear").textContent = new Date().getFullYear();
    </script>

</body>
</html>
<?php /**PATH C:\Users\allej\OneDrive\Desktop\AAAWORK\BANK\babank\resources\views\emails\template.blade.php ENDPATH**/ ?>