<?php
    $getSetting = App\Models\WebsiteSettings::first();
?>
<?php
    use Illuminate\Support\Carbon;

    $date = Carbon::parse($transfer->created_at);
    $day = $date->format('j');
    $suffix = match (true) {
        $day % 100 >= 11 && $day % 100 <= 13 => 'th',
        $day % 10 == 1 => 'st',
        $day % 10 == 2 => 'nd',
        $day % 10 == 3 => 'rd',
        default => 'th',
    };
?>
<?php if (isset($component)) { $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.user','data' => ['notifications' => $notifications]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['notifications' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($notifications)]); ?>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background-color: #f9f9f9;
        }

        .receipt-container {
            background: white;
            max-width: 400px;
            margin: 30px auto;
            padding: 30px 20px;
            border-radius: 10px;
            position: relative;
            overflow: hidden;
        }

        .receipt-container::before {
            content: "";
            background-image: url('<?php echo e(url('upload/' . $getSetting->website_logo)); ?>');
            background-repeat: repeat;
            background-size: 100px;
            opacity: 0.04;
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: 0;
        }

        .receipt-content {
            position: relative;
            z-index: 1;
        }

        .dashed-top,
        .dashed-bottom {
            height: 20px;
            background: radial-gradient(circle, #000 1px, transparent 1px);
            background-size: 20px 20px;
        }

        .amount {
            font-size: 32px;
            font-weight: 700;
            color: #02B169;
        }

        .title {
            font-size: 18px;
            font-weight: 500;
        }

        .text-muted {
            color: #777;
        }

        .label {
            font-weight: 500;
            color: #666;
        }

        .value {
            text-align: right;
        }

        .footer-note {
            font-size: 13px;
            text-align: center;
            color: #777;
            margin-top: 20px;
        }

        .section {
            margin-top: 25px;
        }

        .row-between {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }

        .card-footer {
            position: relative;
            z-index: 2;
            background-color: white;
        }
    </style>

    <div class="receipt-container">
        <div class="dashed-top"></div>

        <div class="receipt-content text-center">
            <img src="<?php echo e(url('upload/' . $getSetting->website_logo)); ?>" alt="Logo" height="40" class="mb-2">
            <h5 class="title">Transaction Receipt</h5>
            <div class="amount my-2"><?php echo e(Auth::user()->acct_currency); ?><?php echo e(number_format($transfer->amount, 2)); ?></div>
            <div class="text-muted"><?php echo e($transfer->status); ?></div>
            <div class="text-muted small"><?php echo e($date->format('M')); ?> <?php echo e($day . $suffix); ?>, <?php echo e($date->format('Y H:i:s')); ?>

            </div>

            <hr class="my-4">

            <div class="section text-start">
                <div class="row-between">
                    <span class="label">Recipient Details</span>
                    <span class="value text-muted"><?php echo e($transfer->account_name); ?></span>
                </div>
                <div class="row-between">
                    <span></span>
                    <span class="value text-muted"><?php echo e($transfer->bank_name); ?> | <?php echo e($transfer->account_number); ?></span>
                </div>

                <div class="mt-3 row-between">
                    <span class="label">Fee</span>
                    <span
                        class="value text-muted"><?php echo e(Auth::user()->acct_currency); ?><?php echo e(number_format($transfer->fee, 2)); ?></span>
                </div>

                <div class="mt-3 row-between">
                    <span class="label">Description</span>
                    <span class="value text-muted"><?php echo e($transfer->description); ?></span>
                </div>

                <div class="mt-3 row-between">
                    <span class="label">Transaction No.</span>
                    <span class="value text-muted"><?php echo e($transfer->reference); ?></span>
                </div>
            </div>

            <div class="footer-note">
                Enjoy better services with <?php echo e($getSetting->website_name); ?>. Get free transfers, withdrawals, bill
                payments, instant loans, and good
                annual interest on your savings. <?php echo e($getSetting->website_name); ?> is insured by the
                FDIC.
            </div>
        </div>

        <div class="dashed-bottom mt-3"></div>
        <div class="card-footer border-top">
            <div class="row g-3">
                <div class="col-sm-6">
                    <a href="<?php echo e(route('transaction.receipts', ['id' => $transfer->id])); ?>"
                        class="btn btn-outline-dark w-100 text-capitalize m-2">Download
                        Receipt</a>
                </div>
                <div class="col-sm-6">
                    <a href="<?php echo e(url('account/transactions')); ?>" class="btn btn-dark w-100 text-capitalize m-2">done</a>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $attributes = $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $component = $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php /**PATH C:\Users\allej\OneDrive\Desktop\AAAWORK\BANK\babank\resources\views\account\domestic_success.blade.php ENDPATH**/ ?>