<?php
    $getSetting = App\Models\WebsiteSettings::first();
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <title><?php echo e($getSetting->website_name); ?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="financial dashboard">
    <meta name="keyword" content="financial dashboard, financial reporting, admin panel, finance management">
    <!--[ Favicon]-->
    <link rel="icon" type="image/x-icon" href="<?php echo e(url('upload/', $getSetting->website_favicon)); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(url('upload/', $getSetting->website_favicon)); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(url('upload/', $getSetting->website_favicon)); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(url('upload/', $getSetting->website_favicon)); ?>">
    <!--[ Template main css file ]-->
    <link rel="stylesheet" href="/user/assets/css/style.min.css">
    <!--============== active class js =============-->
    <script src="/user/assets/js/active-class.js"></script>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
</head>

<body data-theme="theme-FrenchRose" class="svgstroke-a">
    <nav class="navbar navbar-expand-md position-fixed top-0 w-100 z-3 body-color ">
        <div class="container-fluid">
            <div class="d-flex d-sm-none">
                <button class="navbar-toggler ms-3 d-none" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </div>
            <div class="d-none d-sm-block">
                <ul class="list-unstyled d-none">
                    <li class="nav-item dropdown px-md-1">
                        <a class="dropdown-toggle gray-6" href="#offcanvas_setting" data-bs-toggle="offcanvas"
                            aria-expanded="false" title="template setting">
                            <svg class="svg-stroke" xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                viewBox="0 0 24 24" stroke="currentColor" fill="none" stroke-linecap="round"
                                stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path
                                    d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z">
                                </path>
                                <path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0"></path>
                            </svg>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <main class="container-fluid px-0">
        <!-- start: page menu link -->
        <div class="content">
            <!-- start: page body area -->

            <div class="px-xl-5 px-lg-4 px-3 py-3 page-body my-2 py-2">

                <div style="height: 90vh;" class="row g-0">
                    <div class="col-lg-6 col-md-7 col-sm-12 d-flex align-items-center justify-content-center bg-white">
                        <div class="col-xl-8 col-lg-10 col-md-11">
                            <div class="">
                                <div class="card-body">
                                    <?php if(session('success')): ?>
                                        <div class="alert alert-success text-center">
                                            <?php echo e(session('success')); ?>

                                        </div>
                                    <?php endif; ?>

                                    <?php if(session('error')): ?>
                                        <div class="alert alert-danger text-center">
                                            <?php echo e(session('error')); ?>

                                        </div>
                                    <?php endif; ?>

                                    <?php if(session('warning')): ?>
                                        <div class="alert alert-warning text-center">
                                            <?php echo e(session('warning')); ?>

                                        </div>
                                    <?php endif; ?>
                                    <div class="d-flex flex-column align-items-center ">
                                        <div class="mt-4 ">
                                            
                                            <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                                                <img src="<?php echo e(url('upload/' . $getSetting->website_logo)); ?>"
                                                    alt="Logo" height="60" class="mb-3 mx-auto d-block">
                                            </a>
                                            
                                            <div class="mb-2 text-center mt-3">
                                                <p class="mb-6">
                                                    Don't have an account?
                                                    <a href="<?php echo e(route('register')); ?>"
                                                        class="text-decoration-underline text-info fw-bold">
                                                        Open an account
                                                    </a>
                                                </p>
                                            </div>
                                            <h4 class="text-capitalize text-center fw-bold mb-6"
                                                style="margin-bottom: 30px">
                                            </h4>
                                        </div>
                                        <style>
                                            #chatbot-input {
                                                color: #212529;
                                            }

                                            @media (prefers-color-scheme: dark) {
                                                #chatbot-input {
                                                    color: #212529;
                                                }
                                            }
                                        </style>
                                        <div class="mt-3 w-100">
                                            <form method="POST" action="<?php echo e(route('login')); ?>" class="form-horizontal"
                                                id="validateForm">
                                                <?php echo csrf_field(); ?>
                                                <div class="tab-pane fade show active" id="pills-home" role="tabpanel"
                                                    aria-labelledby="pills-home-tab">
                                                    <div class="row g-3 px-3 py-2">
                                                        <div class="col-md-12">
                                                            <label for="exampleFormControlInput1"
                                                                class="form-label fw-semibold">Account ID</label>
                                                            <div class="input-group">
                                                                <span class="input-group-text bg-transparent">
                                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                                        width="20" class="bi bi-person"
                                                                        viewBox="0 0 24 24" fill="none"
                                                                        stroke="currentColor" stroke-linecap="round"
                                                                        stroke-linejoin="round" class=" svg-stroke">
                                                                        <path
                                                                            d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6m2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0m4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4m-1-.004c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10s-3.516.68-4.168 1.332c-.678.678-.83 1.418-.832 1.664z" />
                                                                    </svg>
                                                                </span>
                                                                <input type="number" class="form-control"
                                                                    id="chatbot-input"
                                                                    value="<?php echo e(old('account_no')); ?>" required autofocus
                                                                    name="account_no"
                                                                    placeholder="<?php echo e(__('Account ID')); ?>">
                                                            </div>
                                                            <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['messages' => $errors->get('account_no'),'class' => 'mt-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('account_no')),'class' => 'mt-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <label for="exampleFormControlInput1"
                                                                class="form-label fw-semibold">Password</label>
                                                            <div class="input-group">
                                                                <span class="input-group-text bg-transparent">
                                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                                        width="20" viewBox="0 0 24 24"
                                                                        fill="none" stroke="currentColor"
                                                                        stroke-linecap="round" stroke-linejoin="round"
                                                                        class=" svg-stroke">
                                                                        <path stroke="none" d="M0 0h24v24H0z"
                                                                            fill="none">
                                                                        </path>
                                                                        <path
                                                                            d="M5 13a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v6a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z">
                                                                        </path>
                                                                        <path d="M8 11v-4a4 4 0 1 1 8 0v4">
                                                                        </path>
                                                                        <path d="M15 16h.01"></path>
                                                                        <path d="M12.01 16h.01"></path>
                                                                        <path d="M9.02 16h.01"></path>
                                                                    </svg>
                                                                </span>
                                                                <input type="password" class="form-control"
                                                                    id="chatbot-input" required
                                                                    autocomplete="current-password" name="password"
                                                                    placeholder="<?php echo e(__('Password')); ?>">
                                                            </div>
                                                            <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['messages' => $errors->get('password'),'class' => 'mt-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('password')),'class' => 'mt-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                                                        </div>
                                                        <!-- check -->
                                                        <div class="d-flex justify-content-between my-3">
                                                            <div class="form-check ">
                                                                <input class="form-check-input form-check-input-dark"
                                                                    type="checkbox" value=""
                                                                    id="flexCheckDefault">
                                                                <label class="form-check-label"
                                                                    for="flexCheckDefault">Remember Me</label>
                                                            </div>
                                                            
                                                        </div>
                                                    </div>
                                                    <div class="dropdown-divider"></div>
                                                    <div class="card-footer border-top">
                                                        <div class="row g-3 my-2">
                                                            <div class="col-sm-12">
                                                                <button type="submit"
                                                                    class="btn fw-semibold btn-info text-white w-100">GRANT
                                                                    ACCESS</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Right: Background Image -->
                    <div class="col-lg-6 d-none d-lg-block"
                        style="
                                background-image: url('<?php echo e(url('upload/', $getSetting->login_bg)); ?>');
                                background-size: cover;
                                background-position: center;
                            ">
                    </div>
                </div>
            </div>
        </div>
    </main>
    <footer class="w-100 bg-body position-fixed bottom-0">
        <div class="container-fluid">
            <div class="d-flex align-items-center">
                <div class="p-0 m-0">
                    <a class="link-offset-2 link-offset-3-hover link-underline link-underline-opacity-0 link-underline-opacity-75-hover text-reverse"
                        href="#">@2024 Fintechweb</a>
                </div>
                <div class="  ms-auto p-2 pe-0">
                    <div class="dropdown position-relative">
                        <div class="gtranslate_wrapper"></div>
                        <script>
                            window.gtranslateSettings = {
                                "default_language": "en",
                                "wrapper_selector": ".gtranslate_wrapper"
                            }
                        </script>
                        <script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script>
        <?php if(Session::has('message')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "iconClass": 'toast-success', // Custom icon for success
                "timeOut": "5000", // Optional timeout
            }
            toastr.success("<i class='fa fa-check-circle'></i> <?php echo e(session('message')); ?>");
        <?php endif; ?>

        <?php if(Session::has('error')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "iconClass": 'toast-error', // Custom icon for error
                "timeOut": "5000",
            }
            toastr.error("<i class='fa fa-times-circle'></i> <?php echo e(session('error')); ?>");
        <?php endif; ?>

        <?php if(Session::has('info')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "iconClass": 'toast-info', // Custom icon for info
                "timeOut": "5000",
            }
            toastr.info("<i class='fa fa-info-circle'></i> <?php echo e(session('info')); ?>");
        <?php endif; ?>

        <?php if(Session::has('warning')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "iconClass": 'toast-warning', // Custom icon for warning
                "timeOut": "9000",
            }
            toastr.warning("<i class='fa fa-exclamation-circle'></i> <?php echo e(session('warning')); ?>");
        <?php endif; ?>
    </script>

    <!--[ FintechWeb template vender js ]-->
    <script src="/user/assets/bundles/libscripts.bundle.js"></script>
    <script src="/user/assets/bundles/dynamicselect.js"></script>
    <!-- Template page js -->
    <script src="/user/assets/js/main.js" defer></script>
</body>

</html>
<?php /**PATH C:\Users\allej\OneDrive\Desktop\AAAWORK\BANK\babank\resources\views\auth\login.blade.php ENDPATH**/ ?>