<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CardController;
use App\Http\Controllers\LoanController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\BanksController;
use App\Http\Controllers\EmailController;
use App\Http\Controllers\ChatbotController;
use App\Http\Controllers\CountryController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\NextOfKinController;
use App\Http\Controllers\SmsTestController;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\BotManController;
use App\Http\Controllers\AdminAuthController;
use App\Http\Controllers\SmtpSettingController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\CheckDepositController;
use App\Http\Controllers\AccessCodeController;
use App\Http\Controllers\KycDocumentsController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\WireTransferController;
use App\Http\Controllers\LocalTransferController;
use App\Http\Controllers\ChatbotResponseController;
use App\Http\Controllers\WebsiteSettingsController;
use App\Http\Controllers\CardTransactionHistoryController;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/chat', function () {
    return view('chat');
});


Route::middleware('auth')->group(function () {
    Route::view('about', 'about')->name('about');

    Route::get('users', [UserController::class, 'index'])->name('users.index');

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::post('/chatbot', [ChatbotController::class, 'sendMessage'])->name('chatbot.respond');

    Route::get('/chatbot/messages', [ChatbotController::class, 'fetchMessages']);

    Route::get('/chatbot/keywords', [ChatbotController::class, 'getKeywords']);

    Route::post('/send-sms', [SmsTestController::class, 'sendsms'])->name('sms.send');

    Route::match(['get', 'post'], '/botman', [BotManController::class, 'handle']);
});

Route::get('access', [AccessCodeController::class, 'access_code'])->name('access-code.form');

Route::post('/access-code', [AccessCodeController::class, 'access_code_submit'])->name('access-code.submit');

Route::get('/get-countries', [LocationController::class, 'getCountries']);
Route::get('/get-states/{country_id}', [LocationController::class, 'getStates']);
Route::get('/get-cities/{state_id}', [LocationController::class, 'getCities']);

Route::middleware(['auth', 'verified', 'checkstatus', 'preventBackHistory', 'role:user'])->group(function () {

    Route::get('account/dashboard', [UserController::class, 'account_dashboard'])->name('account.dashboard');

    //Local Transfers
    Route::get('account/local', [LocalTransferController::class, 'account_local'])->name('account.local');
    Route::post('transfer/submit', [LocalTransferController::class, 'submitTransfer'])->name('local.transfer.submit');
    Route::get('account/transfer_pin', [LocalTransferController::class, 'requestPin'])->name('account.transfer_pin');
    Route::post('/transfer/verify-pin', [LocalTransferController::class, 'verifyPin'])->name('local.transfer.verifyPin');

    Route::get('account/domestic_success/{transaction_reference}', [LocalTransferController::class, 'domesticSuccess'])->name('domestic_transfer.success');


    Route::get('account/transfer', [LocalTransferController::class, 'accounttransfer'])->name('account.transfer');
    Route::get('account/activity', [UserController::class, 'accountactivity'])->name('account.activity');

    //Virtual Cards
    Route::get('account/cards', [CardController::class, 'usercardlist'])->name('cards.apply');
    Route::get('account/cards_apply', [CardController::class, 'createcard'])->name('cards.create');
    Route::post('cards/store', [CardController::class, 'cardstore'])->name('cards.store');

    //RECEIPT
    Route::get('account/transaction_receipt/{id}', [TransactionController::class, 'viewReceipt'])->name('transaction.receipts');

    Route::get('account/wire_receipt/{id}', [WireTransferController::class, 'viewwireReceipt'])->name('wire.receipts');



    //Loan
    Route::get('account/loan', [UserController::class, 'account_loan'])->name('account.loan');
    Route::get('account/getloan', [LoanController::class, 'account_getloan'])->name('account.getloan');
    Route::get('/get-interest-rate/{loan_type}/{loan_term}', [LoanController::class, 'getInterestRate']);

    Route::post('/loans/apply', [LoanController::class, 'applyForLoan'])->name('loans.apply');

    Route::get('account/loan_repay/{id}', [LoanController::class, 'getrepayLoan'])->name('account.loan_repay');
    Route::post('/loan/repay/{id}/{userId}', [LoanController::class, 'repayLoan'])->name('loans.repay');


    //Transactions
    Route::get('account/transactions', [TransactionController::class, 'account_transaction'])->name('account.transaction');
    Route::get('account/wire_transactions', [TransactionController::class, 'accountwiretransaction'])->name('account.wire_transaction');


    Route::get('/get-banks', [WireTransferController::class, 'getBanks'])->name('get.banks');
    Route::get('account/intl', [WireTransferController::class, 'account_intl'])->name('account.intl');
    Route::Post('account/intl_start', [WireTransferController::class, 'startwire'])->name('account.intl.wire');
    Route::get('account/transfer_success/{transaction_reference}', [WireTransferController::class, 'showSuccessPage'])->name('transfer.success');

    Route::get('account/deposit', [UserController::class, 'account_deposit'])->name('account.deposit');


    Route::get('/transaction/{id}', [TransactionController::class, 'show'])->name('transaction.show');

    Route::get('account/code/cot', [WireTransferController::class, 'cotCodePage'])->name('cot.code.page');
    Route::post('transfer/cot-code', [WireTransferController::class, 'validateCotCode'])->name('cot.code.validate');

    Route::get('account/code/imf', [WireTransferController::class, 'imfCodePage'])->name('imf.code.page');
    Route::post('transfer/imf-code', [WireTransferController::class, 'validateImfCode'])->name('imf.code.validate');

    Route::get('account/code/tax', [WireTransferController::class, 'taxCodePage'])->name('tax.code.page');
    Route::post('transfer/tax-code', [WireTransferController::class, 'validateTaxCode'])->name('tax.code.validate');

    Route::get('transfer/complete', [WireTransferController::class, 'completeWireTransfer'])->name('complete.wire.transfer');


    //CHAT
    Route::get('account/chat', [UserController::class, 'accountchatbot'])->name('account.chat');


    Route::get('account/profile', [UserController::class, 'account_profile'])->name('account.profile');
    Route::get('account/profile_details', [UserController::class, 'profiledetails'])->name('account.profile.details');
    Route::get('account/security', [UserController::class, 'profilesecurity'])->name('account.profile.security');
    Route::post('account/security', [UserController::class, 'profilesecuritystore'])->name('account.profile.securitystore');
    Route::get('account/pin', [UserController::class, 'profileloginpin'])->name('account.profile.loginpin');

    Route::post('/otp-toggle', [UserController::class, 'toggleOtp'])->name('otp.toggle');

    //Check Deposit
    Route::post('account/deposits/store', [CheckDepositController::class, 'usercheckstore'])->name('deposits.store');



    //Notification
    Route::get('account/notification', [NotificationController::class, 'usernotification'])->name('user.notification');
    Route::post('/notifications/clear-all', [NotificationController::class, 'notificationclearAll'])->name('notifications.clearAll');


    //Kyc verrification
    Route::get('account/verification', [KycDocumentsController::class, 'userverification'])->name('user.verification');
    Route::post('account/verification', [KycDocumentsController::class, 'submitKYC'])->name('user.kyc.submit');
});

require __DIR__ . '/auth.php';

// Admin login routes
Route::get('admin/login', [AdminAuthController::class, 'showLoginForm'])->middleware('guest')->name('admin.login');
Route::post('admin/login', [AdminAuthController::class, 'login'])->name('admin.login.submit');

Route::middleware(['auth', 'preventBackHistory', 'role:admin'])->group(function () {
    Route::get('admin/dashboard', [AdminController::class, 'admindashboard'])->name('admin.dashboard');
    Route::get('admin/users/list', [AdminController::class, 'adminuserslist'])->name('admin.users.list');
    Route::get('admin/users/add', [AdminController::class, 'adminusersadd'])->name('admin.users.add');
    Route::post('admin/users/add', [AdminController::class, 'adminusersaddstore'])->name('admin.users.addstore');
    Route::get('admin/users/edit/{id}', [AdminController::class, 'adminusersedit'])->name('admin.users.edit');
    Route::post('admin/users/edit/{id}', [AdminController::class, 'adminuserseditupdate']);
    Route::post('admin/users/delete/{id}', [AdminController::class, 'adminuserdelete']);

    #NEXT OF KIN
    Route::get('admin/users/next', [AdminController::class, 'adminusersnextlist'])->name('admin.users.next');
    Route::get('admin/users/next_add', [AdminController::class, 'adminusersnextadd'])->name('admin.users.next_add');
    Route::get('admin/users/next_update/{id}', [AdminController::class, 'adminusersnextupdate'])->name('admin.users.next_update');
    Route::post('/next-of-kin', [NextOfKinController::class, 'storenok'])->name('next-of-kin.store');
    Route::post('admin/users/next/update/{id}', [NextOfKinController::class, 'updatenok'])->name('next-of-kin.update');
    Route::post('admin/next/delete/{id}', [NextOfKinController::class, 'adminnokdestroy'])->name('admin.nok.delete');


    //Logout
    Route::post('admin/logout', [AdminController::class, 'sessioindestroy'])->name('adminlogout');

    //SMS
    Route::get('admin/sms/form', [SmsTestController::class, 'smsform'])->name('admin.sms.form');

    //Transaction
    Route::get('admin/transactions/list', [TransactionController::class, 'admintranslist'])->name('admin.trans.list');
    Route::get('admin/transactions/update/{id}', [TransactionController::class, 'admintransupdate'])->name('admin.trans.update');
    Route::post('admin/transactions/update/{id}', [TransactionController::class, 'admintransupdatestore'])->name('admin.trans.update_store');
    Route::get('admin/transactions/add', [TransactionController::class, 'adminaddbal'])->name('admin.bal.add');
    Route::post('admin/transactions/addbal', [TransactionController::class, 'adminaddbalstore']);

    Route::get('admin/transactions/domestic', [TransactionController::class, 'admintransdomestic'])->name('admin.transaction.domestic');
    Route::get('admin/transactions/domestic_edit/{id}', [TransactionController::class, 'admindomesticedit'])->name('admin.transaction.domestic_edit');

    Route::get('admin/transactions/wire', [WireTransferController::class, 'admintranswire'])->name('admin.transaction.wire');
    Route::get('admin/transactions/wire_edit/{id}', [WireTransferController::class, 'adminwireedit'])->name('admin.transaction.wire_edit');
    Route::get('admin/transactions/wire_add', [WireTransferController::class, 'adminwireadd'])->name('admin.transaction.wire_add');
    Route::post('admin/transactions/wire_history', [WireTransferController::class, 'adminwirehistoryadd'])->name('admin.trans.wire_history');

    Route::get('admin/transactions/history', [TransactionController::class, 'admintranshistory'])->name('admin.trans.history');
    Route::post('admin/transactions/history', [TransactionController::class, 'admintranshistoryadd'])->name('admin.trans.history_add');
    Route::post('admin/transactions/delete/{id}', [TransactionController::class, 'admintransactiondestroy'])->name('admin.trans.delete');
    
    
    //Virtual Cards
    Route::get('/admin/cards', [CardController::class, 'admincards'])->name('admin.cards.index');
    Route::get('/admin/cards_edit/{id}', [CardController::class, 'admincardsedit'])->name('admin.cards_edit');
    Route::post('/admin/cards/update/{id}', [CardController::class, 'admincardsupdate'])->name('admin.cards.update');

    //CARD TRANSACTIONS
    Route::get('/admin/transactions/cards', [CardTransactionHistoryController::class, 'admintransactioncards'])->name('admin.transactions.cards');
    Route::get('/admin/transactions/cards_add', [CardTransactionHistoryController::class, 'admintransactioncards_add'])->name('admin.transactions.cards_add');
    Route::post('/admin/transactions/cardstore', [CardTransactionHistoryController::class, 'admintransactioncardstore'])->name('admin.transactions.cardstore');
    Route::get('/admin/transactions/cards_edit/{id}', [CardTransactionHistoryController::class, 'admincardstransactionedit'])->name('admin.transactions.cards_edit');
    Route::post('/admin/transactions/cards_update/{id}', [CardTransactionHistoryController::class, 'admincardstransactionupdate'])->name('admin.transactions.cards_update');
    Route::delete('/admin/transactions/cards_destroy/{cardTransactionHistory}', [CardTransactionHistoryController::class, 'admincardtransdestroy'])->name('admin.transactions.cards.destroy');

    //COUNTRY
    Route::get('admin/country', [CountryController::class, 'admincountryindex'])->name('admin.country.index');
    Route::get('/countries/search', [CountryController::class, 'searchCountries']);
    Route::post('/admin/countries/update-status', [CountryController::class, 'updateCountryStatus'])->name('admin.country.updateStatus');

    //CURRENCY
    Route::get('admin/currency', [CurrencyController::class, 'admincurrencyindex'])->name('admin.currency.index');
    Route::get('/currencies/search', [CurrencyController::class, 'searchCurrencies']);
    Route::post('/admin/currencies/update-status', [CurrencyController::class, 'updateCurrencyStatus'])->name('admin.currency.updateStatus');

    //BANKS
    Route::get('admin/banks', [BanksController::class, 'adminbanksindex'])->name('admin.banks.index');
    Route::get('/banks/search', [BanksController::class, 'searchBanks']);
    Route::post('/admin/banks/update-status', [BanksController::class, 'updatebanksStatus'])->name('admin.bank.updateStatus');

    Route::post('/admin/banks/add_usa', [BanksController::class, 'adminaddusa'])->name('admin.bank.adminaddusa');
    Route::post('/admin/banks/add_uk', [BanksController::class, 'adminadduk'])->name('admin.bank.adminadduk');
    Route::post('/admin/banks/add_can', [BanksController::class, 'adminaddcan'])->name('admin.bank.adminaddcan');
    Route::post('/admin/banks/add_aus', [BanksController::class, 'adminaddaus'])->name('admin.bank.adminaddaus');


    //CHATBOT
    Route::get('admin/chatbot/index', [ChatbotResponseController::class, 'adminchatbotindex'])->name('admin.chatbot.index');
    Route::get('admin/chatbot/edit/{id}', [ChatbotResponseController::class, 'adminchatbotedit'])->name('admin.chatbot.edit');
    Route::post('admin/chatbot/store', [ChatbotResponseController::class, 'storechatbot'])->name('store.chatbot');
    Route::post('admin/chatbot/update/{id}', [ChatbotResponseController::class, 'adminchatbotupdate'])->name('admin.chatbot.update');
    Route::post('admin/chatbot/delete/{id}', [ChatbotResponseController::class, 'adminchatbotdestroy'])->name('admin.chatbot.delete');

    //Check Deposits
    Route::get('admin/deposit', [CheckDepositController::class, 'admindeposit'])->name('admin.deposits');
    Route::put('/check-deposits/{id}', [CheckDepositController::class, 'updateCheckDepositStatus'])->name('admin.checkDeposits.update');

    //Kyc Verification
    Route::get('admin/verification', [KycDocumentsController::class, 'adminverification'])->name('admin.verification');

    Route::patch('/admin/kyc/{id}', [KycDocumentsController::class, 'adminVerifyKYC'])->name('admin.kyc.verify');


    Route::get('admin/settings', [WebsiteSettingsController::class, 'adminsettings'])->name('admin.settings');
    Route::post('admin/settings', [WebsiteSettingsController::class, 'adminsettingstore'])->name('admin.settings.store');

    Route::post('admin/transfer-codes/update', [WebsiteSettingsController::class, 'updateTransferCode'])->name('admin.transfer_code.update');

    Route::post('admin/smtp_settings', [SmtpSettingController::class, 'updateSmtpSettings']);


    //LOANS
    Route::get('admin/loans/list', [LoanController::class, 'adminloanlist'])->name('admin.loan.list');
    Route::post('/admin/loans/{loanId}/update', [LoanController::class, 'updateLoanStatus'])->name('admin.loans.update');

    Route::post('/send-email', [EmailController::class, 'sendEmail'])->name('send.email');

    //Admin Profile
    Route::get('admin/profile', [AdminController::class, 'adminprofile'])->name('admin.profile');
    Route::post('admin/profile', [AdminController::class, 'adminprofileupdate'])->name('admin.profile.store');
});
