@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<!DOCTYPE html>
<html lang="en">



<body>

    <!-- Start em_loading -->
    <section class="em_loading" id="loaderPage">
        <div class="spinner_flash"></div>
    </section>
    <!-- End. em_loading -->

    <div id="wrapper">
        <div id="content">

            <!-- Start em_introPage -->
            <section class="em_welcomeClassic __welcomeSwiper">
                <div class="cover_image">
                    <img src="{{ url('upload/'.$getSetting->login_bg) }}" alt="">

                    <!-- Swiper -->
                    <div class="swiper-container swiperWelcome">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <div class="content_text">
                                    <h2>Welcome</h2>
                                    <p>Welcome to our community! We're thrilled to have you with us. At {{$getSetting->website_name}}</p>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="content_text">
                                    <h2>Easy Financing</h2>
                                    <p>Experience the freedom of easy financing with {{$getSetting->website_name}}'s unbeatable loan offers tailored just for you! 💼</p>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="content_text">
                                    <h2>Good Loan Offers</h2>
                                    <p>Discover unbeatable loan offers at {{$getSetting->website_name}}, where we turn your financial dreams into reality! 💸</p>
                                </div>
                            </div>
                        </div>
                        <!-- Add Pagination -->
                        <div class="swiper-pagination"></div>
                    </div>

                    <div class="actionSign">
                        @if (Route::has('login'))
                                @auth
                                    @if (auth()->user()->role === 'admin')  <!-- Assuming the role column is named 'role' -->
                                        <a
                                            href="{{ url('admin/dashboard') }}"
                                            class="btn color-white min-w-150 h-52 justify-content-center"
                                        >
                                            Admin Dashboard
                                        </a>
                                    @else
                                        <a
                                            href="{{ url('account/dashboard') }}"
                                            class="btn color-white min-w-150 h-52 justify-content-center"
                                        >
                                            User Dashboard
                                        </a>
                                    @endif
                                @else
                                
                        <a href="{{url('login')}}" class="btn color-white min-w-150 h-52 justify-content-center">
                            Sign In
                        </a>
                        @if (Route::has('register'))
                        <a href="{{url('register')}}" class="btn btn__icon bg-white h-52 rounded-8">
                            Sign Up
                            <div class="icon">
                                <svg id="Iconly_Light_Arrow_-_Right_Square"
                                    data-name="Iconly/Light/Arrow - Right Square" xmlns="http://www.w3.org/2000/svg"
                                    width="24" height="24" viewBox="0 0 24 24">
                                    <g id="Arrow_-_Right_Square" data-name="Arrow - Right Square"
                                        transform="translate(2 22) rotate(-90)">
                                        <path id="Stroke_1" data-name="Stroke 1"
                                            d="M4.916,18.5h8.669c3.02,0,4.915-2.139,4.915-5.166V5.166C18.5,2.139,16.615,0,13.585,0H4.916C1.886,0,0,2.139,0,5.166v8.168C0,16.361,1.886,18.5,4.916,18.5Z"
                                            transform="translate(0.75 0.75)" fill="none" stroke="#200e32"
                                            stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10"
                                            stroke-width="1.5" opacity="0.4" />
                                        <path id="Stroke_3" data-name="Stroke 3" d="M.5,8.172V0"
                                            transform="translate(9.5 5.914)" fill="none" stroke="#200e32"
                                            stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10"
                                            stroke-width="1.5" />
                                        <path id="Stroke_5" data-name="Stroke 5" d="M7.5,0,3.748,3.764,0,0"
                                            transform="translate(6.252 10.322)" fill="none" stroke="#200e32"
                                            stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10"
                                            stroke-width="1.5" />
                                    </g>
                                </svg>
                            </div>
                        </a>
                        @endif
                        @endauth
                @endif
                    </div>
                </div>
            </section>
            <!-- End. em_introPage -->

        </div>
    </div>

    <!-- jquery -->
    <script src="/user/assets/js/jquery-3.6.0.js"></script>
    <!-- popper.min.js 1.16.1 -->
    <script src="/user/assets/js/popper.min.js"></script>
    <!-- bootstrap.js v4.6.0 -->
    <script src="/user/assets/js/bootstrap.min.js"></script>

    <!-- Owl Carousel v2.3.4 -->
    <script src="/user/assets/js/vendor/owl.carousel.min.js"></script>
    <!-- Swiper 6.4.11 -->
    <script src="/user/assets/js/vendor/swiper-bundle.min.js"></script>
    <!-- sharer 0.4.0 -->
    <script src="/user/assets/js/vendor/sharer.js"></script>
    <!-- short-and-sweet v1.0.2 - Accessible character counter for input elements -->
    <script src="/user/assets/js/vendor/short-and-sweet.min.js"></script>
    <!-- jquery knob -->
    <script src="/user/assets/js/vendor/jquery.knob.min.js"></script>
    <!-- main.js -->
    <script src="/user/assets/js/main.js" defer></script>
    <!-- PWA app service registration and works js -->
    <script src="/user/assets/js/pwa-services.js"></script>
</body>

</html>