@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaction Receipt</title>
    <style>
        body {
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f5f5;
            color: #333;
        }
        .receipt-container {
            max-width: 700px;
            margin: 40px auto;
            background: #fff;
            border: 1px solid #e5e5e5;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header img {
            max-width: 80px;
        }
        .header h1 {
            font-size: 20px;
            margin: 10px 0 0;
            font-weight: 600;
            color: #555;
        }
        .transaction-amount {
            text-align: center;
            font-size: 28px;
            font-weight: bold;
            color: #000;
            margin: 20px 0;
        }
        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .details-table th, .details-table td {
            padding: 10px 15px;
            font-size: 14px;
            vertical-align: top;
            border-bottom: 1px solid #eee;
        }
        .details-table th {
            font-weight: bold;
            color: #666;
            width: 35%;
            text-align: left;
        }
        .details-table td {
            color: #333;
            text-align: right; /* Align the details to the right */
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #999;
        }
        .footer p {
            margin: 5px 0;
        }
        .stamp {
            text-align: center;
            margin-top: 20px;
            font-size: 14px;
            color: #333;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <div class="header">
            <h1>Transaction Details</h1>
        </div>
        <div class="transaction-amount">
            {{Auth::user()->acct_currency}}{{ number_format($transactions->amount, 2)}}
        </div>
        <table class="details-table">
            <tr>
                <th>Beneficiary Details</th>
                <td>{{$transactions->account_name}}</td>
            </tr>
            <tr>
                <th>Paid On</th>
                <td>{{$transactions->created_at}}</td>
            </tr>
            <tr>
                <th>Status</th>
                <td>{{$transactions->status}}</td>
            </tr>
            <tr>
                <th>Description</th>
                <td>{{$transactions->description}}</td>
            </tr>
            <tr>
                <th>Transaction Reference</th>
                <td>{{$transactions->reference}}</td>
            </tr>
            <tr>
                <th>Payment Type</th>
                <td>{{$transactions->transaction_type}}</td>
            </tr>
        </table>
        <div class="stamp">
            {{$getSetting->website_name}}
        </div>
        <div class="footer">
            <p>© 2024 {{$getSetting->website_name}} (FDIC). All rights reserved.</p>
            <p>All deposits are insured by the Federal Deposit Insurance Corporation (FDIC).</p>
        </div>
    </div>
</body>
</html>
