@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<aside class="ps-3 pe-2 py-2 sidebar">
    <div class="flex-grow-1">
        <div class="d-flex align-items-center mb-2 logo-info">
            <div class="d-flex align-items-center   ">
                <a href="{{ url('account/dashboard') }}" title="logo" class="brand-icon ">
                    <img src="{{ url('upload/' . $getSetting->website_logo) }}" style="width: 150px; height: 30px;"/>
                </a>
            </div>
            <button class="btn btn-sm btn-close sidebar-toggle  border ms-auto d-lg-none" type="button"></button>
            <a class="ms-auto d-lg-inline-flex d-none menu-toggle shadow-sm align-items-center justify-content-center mini-btn"
                href="#" title="Sidebar Toggle">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                    <path d="M15 12h-12"></path>
                    <path d="M7 8l-4 4l4 4"></path>
                    <path d="M12 21a9 9 0 0 0 0 -18"></path>
                </svg>
            </a>
        </div>
        <h6 class="fl-title title-font ps-2 small text-uppercase text-muted"
            style="--dynamic-color: var(--theme-color1)">Main</h6>
        <ul class="list-unstyled mb-2 menu-list ps-3">
            <li>
                <a href="{{ url('account/dashboard') }}" aria-label="Dashboard" data-bs-placement="right"
                    data-bs-title="Dashboard" data-bs-toggle="tooltip">
                    <svg class="svg-stroke" xmlns="http://www.w3.org/2000/svg" width="24" viewBox="0 0 24 24"
                        stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path d="M5 12l-2 0l9 -9l9 9l-2 0"></path>
                        <path d="M5 12v7a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-7"></path>
                        <path d="M10 12h4v4h-4z"></path>
                    </svg>
                    <span class="mx-3">Dashboard</span>
                </a>
            </li>
            <li>
                <a href="{{ url('account/deposit') }}" aria-label="Balance" data-bs-toggle="tooltip"
                    data-bs-title="Balance" data-bs-placement="right">
                    <svg class="svg-stroke" xmlns="http://www.w3.org/2000/svg" width="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round"
                        stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path d="M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"></path>
                        <path d="M3 6m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z">
                        </path>
                        <path d="M18 12l.01 0"></path>
                        <path d="M6 12l.01 0"></path>
                    </svg>
                    <span class="mx-3">Deposit</span>
                </a>
            </li>
            <li>
                <a href="{{ url('account/loan') }}" aria-label="Card" data-bs-toggle="tooltip" data-bs-title="Card"
                    data-bs-placement="right">
                    <i class="fa-solid fa-landmark"></i>
                    <span class="mx-3">Loan</span>
                </a>
            </li>
            <li>
                <a href="{{ url('account/transfer') }}" aria-label="Card" data-bs-toggle="tooltip" data-bs-title="Card"
                    data-bs-placement="right">
                    <i class="fa-solid fa-money-bill-transfer"></i>
                    <span class="mx-3">Transfer</span>
                </a>
            </li>
            <li>
                <a href="{{ url('account/cards') }}" aria-label="Card" data-bs-toggle="tooltip" data-bs-title="Card"
                    data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" class="svg-stroke" width="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path d="M3 5m0 3a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v8a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3z">
                        </path>
                        <path d="M3 10l18 0"></path>
                        <path d="M7 15l.01 0"></path>
                        <path d="M11 15l2 0"></path>
                    </svg>
                    <span class="mx-3">Card</span>
                </a>
            </li>
            <li>
                <a href="{{ url('account/transactions') }}" aria-label="Card" data-bs-toggle="tooltip" data-bs-title="Card"
                    data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" class="svg-stroke" width="24"
                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-linecap="round"
                                stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M5 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                <path d="M19 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                <path d="M19 8v5a5 5 0 0 1 -5 5h-3l3 -3m0 6l-3 -3"></path>
                                <path d="M5 16v-5a5 5 0 0 1 5 -5h3l-3 -3m0 6l3 -3"></path>
                            </svg>
                    <span class="mx-3">Transactions</span>
                </a>
            </li>
        </ul>
        <h6 class="fl-title title-font ps-2 small text-uppercase text-muted"
            style="--dynamic-color: var(--theme-color1)">Others</h6>
        <ul class="list-unstyled mb-2 menu-list ps-3">
            <li>
                <a href="{{ url('account/profile') }}" aria-label="Integrations" data-bs-toggle="tooltip"
                    data-bs-title="Integrations" data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                        class="svg-stroke">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path d="M8 7a4 4 0 1 0 8 0a4 4 0 0 0 -8 0"></path>
                        <path d="M6 21v-2a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v2"></path>
                    </svg>
                    <span class="mx-3">Profile</span>
                </a>
            </li>
            <li>
                <a href="{{ url('account/security') }}" aria-label="Settings" data-bs-toggle="tooltip"
                    data-bs-title="Settings" data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" class="svg-stroke" width="24" viewBox="0 0 24 24"
                        stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M11.5 21h-4.5a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2" />
                        <path d="M11 16a1 1 0 1 0 2 0a1 1 0 0 0 -2 0" />
                        <path d="M8 11v-4a4 4 0 1 1 8 0v4" />
                        <path d="M20 21l2 -2l-2 -2" />
                        <path d="M17 17l-2 2l2 2" />
                    </svg>
                    <span class="mx-3">Security</span>
                </a>
            </li>
            <li>
                <a href="{{ url('account/pin') }}" aria-label="Settings" data-bs-toggle="tooltip"
                    data-bs-title="Settings" data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                        class="svg-stroke">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path d="M5 11m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v6a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z">
                        </path>
                        <path d="M12 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                        <path d="M8 11v-5a4 4 0 0 1 8 0"></path>
                    </svg>
                    <span class="mx-3">Pin Management</span>
                </a>
            </li>
            {{-- <li>
                <a href="{{ url('account/verification') }}" aria-label="Settings" data-bs-toggle="tooltip"
                    data-bs-title="Settings" data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                        class="svg-stroke">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path d="M8 7a4 4 0 1 0 8 0a4 4 0 0 0 -8 0"></path>
                        <path d="M6 21v-2a4 4 0 0 1 4 -4h4"></path>
                        <path d="M15 19l2 2l4 -4"></path>
                    </svg>
                    <span class="mx-3">Verification</span>
                </a>
            </li> --}}
            <li>
                <a href="{{ url('account/activity') }}" aria-label="Settings" data-bs-toggle="tooltip"
                    data-bs-title="Settings" data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" class="svg-stroke" width="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path
                            d="M15 21h-9a3 3 0 0 1 -3 -3v-1h10v2a2 2 0 0 0 4 0v-14a2 2 0 1 1 2 2h-2m2 -4h-11a3 3 0 0 0 -3 3v11">
                        </path>
                        <path d="M9 7l4 0"></path>
                        <path d="M9 11l4 0"></path>
                    </svg>
                    <span class="mx-3">Activity Log</span>
                </a>
            </li>
            <li>
                <a href="{{ url('account/chat') }}" aria-label="Settings" data-bs-toggle="tooltip"
                    data-bs-title="Settings" data-bs-placement="right">
                    <svg xmlns="http://www.w3.org/2000/svg" class="svg-stroke" width="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path
                            d="M15 21h-9a3 3 0 0 1 -3 -3v-1h10v2a2 2 0 0 0 4 0v-14a2 2 0 1 1 2 2h-2m2 -4h-11a3 3 0 0 0 -3 3v11">
                        </path>
                        <path d="M9 7l4 0"></path>
                        <path d="M9 11l4 0"></path>
                    </svg>
                    <span class="mx-3">FAQ Chat</span>
                </a>
            </li>
        </ul>

    </div>
    <div>

        <div class="row g-0 align-items-center mb-2 mt-2">
            <div class="col text-truncate ">
                <div class="d-flex align-items-center profile">
                    @if (Auth::user()->photo)
                        <img src="{{ url('upload/', Auth::user()->photo) }}" alt="Avatar"
                            class="rounded-circle avatar">
                    @endif
                    <div class="ms-3 profile-text">
                        <a href="#" title="" class="small">{{ Auth::user()->firstname }}
                            {{ Auth::user()->lastname }}</a>
                        <p class="mb-0 small">{{ Auth::user()->email }}</p>
                    </div>
                </div>
            </div>
            <!-- Dropdown -->
            <div class="col-auto">
                <div class="dropdown dropstart">
                    <a href="#" class="btn btn-link btn-sm dropdown-toggle" role="button"
                        data-bs-toggle="dropdown" aria-haspopup="true" data-expanded="false"
                        aria-expanded="false"></a>
                    <div class="dropdown-menu">
                        <a href="{{ url('account/profile') }}" class="dropdown-item">profile</a>

                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <a href="{{ route('logout') }}"
                                onclick="event.preventDefault(); this.closest('form').submit();"
                                class="dropdown-item">Sign out</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card promo">
            <div class="card-body">
                {{-- <div class="d-flex align-items-center justify-content-between mb-3">
                    <h5 class="mb-0">Need Support</h5>
                    <div class="card-action">
                        <div class="dropdown">
                            <a href="#" class="card-options-remove text-danger" data-toggle="card-remove">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-opacity="0.4"
                                        d="M14 1C14.2652 1 14.5196 1.10536 14.7071 1.29289C14.8946 1.48043 15 1.73478 15 2V14C15 14.2652 14.8946 14.5196 14.7071 14.7071C14.5196 14.8946 14.2652 15 14 15H2C1.73478 15 1.48043 14.8946 1.29289 14.7071C1.10536 14.5196 1 14.2652 1 14V2C1 1.73478 1.10536 1.48043 1.29289 1.29289C1.48043 1.10536 1.73478 1 2 1H14ZM2 0C1.46957 0 0.960859 0.210714 0.585786 0.585786C0.210714 0.960859 0 1.46957 0 2L0 14C0 14.5304 0.210714 15.0391 0.585786 15.4142C0.960859 15.7893 1.46957 16 2 16H14C14.5304 16 15.0391 15.7893 15.4142 15.4142C15.7893 15.0391 16 14.5304 16 14V2C16 1.46957 15.7893 0.960859 15.4142 0.585786C15.0391 0.210714 14.5304 0 14 0L2 0Z">
                                    </path>
                                    <path fill-opacity="1"
                                        d="M5 4C4.73478 4 4.48043 4.10536 4.29289 4.29289C4.10536 4.48043 4 4.73478 4 5V11C4 11.2652 4.10536 11.5196 4.29289 11.7071C4.48043 11.8946 4.73478 12 5 12H11C11.2652 12 11.5196 11.8946 11.7071 11.7071C11.8946 11.5196 12 11.2652 12 11V5C12 4.73478 11.8946 4.48043 11.7071 4.29289C11.5196 4.10536 11.2652 4 11 4H5ZM6.677 6.323L8 7.6465L9.323 6.323C9.34624 6.29976 9.37384 6.28132 9.40421 6.26874C9.43458 6.25616 9.46713 6.24968 9.5 6.24968C9.53287 6.24968 9.56542 6.25616 9.59579 6.26874C9.62616 6.28132 9.65376 6.29976 9.677 6.323C9.70024 6.34624 9.71868 6.37384 9.73126 6.40421C9.74384 6.43458 9.75032 6.46713 9.75032 6.5C9.75032 6.53287 9.74384 6.56542 9.73126 6.59579C9.71868 6.62616 9.70024 6.65376 9.677 6.677L8.3535 8L9.677 9.323C9.70024 9.34624 9.71868 9.37384 9.73126 9.40421C9.74384 9.43458 9.75032 9.46713 9.75032 9.5C9.75032 9.53287 9.74384 9.56542 9.73126 9.59579C9.71868 9.62616 9.70024 9.65376 9.677 9.677C9.65376 9.70024 9.62616 9.71868 9.59579 9.73126C9.56542 9.74384 9.53287 9.75032 9.5 9.75032C9.46713 9.75032 9.43458 9.74384 9.40421 9.73126C9.37384 9.71868 9.34624 9.70024 9.323 9.677L8 8.3535L6.677 9.677C6.65376 9.70024 6.62616 9.71868 6.59579 9.73126C6.56542 9.74384 6.53287 9.75032 6.5 9.75032C6.46713 9.75032 6.43458 9.74384 6.40421 9.73126C6.37384 9.71868 6.34624 9.70024 6.323 9.677C6.29976 9.65376 6.28132 9.62616 6.26874 9.59579C6.25616 9.56542 6.24968 9.53287 6.24968 9.5C6.24968 9.46713 6.25616 9.43458 6.26874 9.40421C6.28132 9.37384 6.29976 9.34624 6.323 9.323L7.6465 8L6.323 6.677C6.27606 6.63006 6.24968 6.56639 6.24968 6.5C6.24968 6.43361 6.27606 6.36994 6.323 6.323C6.36994 6.27606 6.43361 6.24968 6.5 6.24968C6.56639 6.24968 6.63006 6.27606 6.677 6.323V6.323Z">
                                    </path>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
                <p class="lh-sm small text-muted">contact with one of our experts to get supports</p>
                <button class="btn btn-grey-outline w-100" type="button">Contact Us</button> --}}
            </div>
        </div>
    </div>
</aside>
