@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp


<!DOCTYPE html>
<html>
<head>
    <title>Wire Transfer Notification</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            background-color: #f4f4f9;
            margin: 0;
            padding: 20px;
        }
        .container {
            background-color: #ffffff;
            padding: 20px;
            margin: 20px auto;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
        }
        .header {
            text-align: center;
            padding-bottom: 20px;
        }
        .header img {
            max-width: 150px;
            margin-bottom: 20px;
        }
        .content p {
            margin: 0;
        }
        .details {
            background-color: #f4f4f9;
            padding: 10px;
            border-radius: 5px;
            margin-top: 20px;
        }
        .details ul {
            list-style-type: none;
            padding: 0;
        }
        .details ul li {
            margin-bottom: 10px;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #777;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="{{ url('upload/'.$getSetting->website_logo) }}" alt="Bank Logo">
            <h2>Wire Transfer Notification</h2>
        </div>
        <div class="content">
            <p>Hello {{ Auth::user()->firstname }} {{ Auth::user()->lastname }},</p>
            <p>You have successfully initiated a wire transfer.</p>
            <div class="details">
                <p><strong>Details:</strong></p>
                <ul>
                    <li>Amount: ${{ $amount }}</li>
                    <li>Beneficiary: {{ $beneficiary_name }}</li>
                    <li>Bank Name: {{ $bank_name }}</li>
                    <li>Status: {{ $status }}</li>
                    <li>Reference: {{ $reference }}</li>
                </ul>
            </div>
        </div>
        <div class="footer">
            <p>Thank you for using our service!</p>
        </div>
    </div>
</body>
</html>
