@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<!DOCTYPE html>
<html>
<head>
    <title>Account Opening Confirmation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 20px;
        }
        .container {
            background-color: #ffffff;
            padding: 20px;
            margin: 20px auto;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
        }
        .header {
            text-align: center;
            padding-bottom: 20px;
        }
        .header img {
            max-width: 200px;
            height: auto;
        }
        .content {
            text-align: center;
        }
        .content h6 {
            color: #333;
            margin-top: 0;
        }
        .content p {
            color: #555;
        }
        .details {
            background-color: #f4f4f9;
            padding: 15px;
            border-radius: 5px;
            margin-top: 20px;
        }
        .details ul {
            list-style-type: none;
            padding: 0;
            color: #555;
        }
        .details ul li {
            margin-bottom: 10px;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #777;
        }
        a {
            color: #1a73e8;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="{{ url('upload/'.$getSetting->website_logo) }}" alt="{{ $getSetting->website_name }} Logo">
        </div>
        <div class="content">
            <h6>Welcome to {{ $getSetting->website_name }}, {{ $first_name }}!</h6>
            <p>Dear {{ $first_name }} {{ $last_name }},</p>
            <p>Thank you for opening an account with us. Below are your account details:</p>
            <div class="details">
                <ul>
                    <li><strong>Account Number:</strong> {{ $account_number }}</li>
                    <li><strong>Login PIN:</strong> {{ $acct_pin }}</li>
                    <li><strong>Domestic Transfer PIN (OTP):</strong> {{ $acct_otp }}</li>
                    <li><strong>Account Level:</strong> {{ $account_level }}</li>
                    <li><strong>Opening Balance:</strong> {{ $account_balance }}</li>
                    <li><strong>Account Type:</strong> {{ $account_type }}</li>
                </ul>
            </div>
            <p>We are excited to have you with us. If you have any questions or need assistance, feel free to reach out to our support team.</p>
        </div>
        <div class="footer">
            <p>Visit us at: <a href="{{ $getSetting->website_link }}">{{ $getSetting->website_name }}</a></p>
            <p>Best regards,</p>
            <p>{{ $getSetting->website_address }}</p>
        </div>
    </div>
</body>
</html>
