@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<!DOCTYPE html>
<html>
<head>
    <title>Domestic Transfer Notification</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 20px;
        }
        .container {
            background-color: #ffffff;
            padding: 20px;
            margin: 20px auto;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
        }
        .header {
            text-align: center;
            padding-bottom: 20px;
        }
        .header img {
            max-width: 150px;
            margin-bottom: 20px;
        }
        .content h1 {
            color: #333;
        }
        .content p {
            margin: 0;
            color: #555;
        }
        .details {
            background-color: #f4f4f9;
            padding: 10px;
            border-radius: 5px;
            margin-top: 20px;
        }
        .details ul {
            list-style-type: none;
            padding: 0;
        }
        .details ul li {
            margin-bottom: 10px;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #777;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="{{ url('upload/'.$getSetting->website_logo) }}" alt="Bank Logo">
            <h2>Domestic Transfer Notification</h2>
        </div>
        <div class="content">
            <p>Dear {{ Auth::user()->firstname }} {{ Auth::user()->lastname }},</p>
            <p>Your domestic transfer has been successfully initiated. Below are the details:</p>
            <div class="details">
                <ul>
                    <li><strong>Beneficiary Name:</strong> {{ $localTransfer->beneficiary_name }}</li>
                    <li><strong>Beneficiary Bank Name:</strong> {{ $localTransfer->beneficiary_bank_name }}</li>
                    <li><strong>Account Number:</strong> {{ $localTransfer->beneficiary_account_number }}</li>
                    <li><strong>Amount:</strong> ${{ number_format($localTransfer->amount, 2) }}</li>
                    <li><strong>Description:</strong> {{ $localTransfer->description }}</li>
                    <li><strong>Status:</strong> {{ $localTransfer->status }}</li>
                </ul>
            </div>
        </div>
        <div class="footer">
            <p>Thank you for banking with us.</p>
        </div>
    </div>
</body>
</html>
