@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<!DOCTYPE html>
<html>
<head>
    <title>Card Application Submitted</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 20px;
        }
        .container {
            background-color: #ffffff;
            padding: 20px;
            margin: 20px auto;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
        }
        .header {
            text-align: center;
            padding-bottom: 20px;
        }
        .header img {
            max-width: 150px;
            margin-bottom: 20px;
        }
        .content h1 {
            color: #333;
        }
        .content p {
            color: #555;
            margin: 0 0 15px;
        }
        .details {
            background-color: #f4f4f9;
            padding: 15px;
            border-radius: 5px;
            margin-top: 20px;
        }
        .details ul {
            list-style-type: none;
            padding: 0;
            color: #555;
        }
        .details ul li {
            margin-bottom: 10px;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #777;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="{{ url('upload/'.$getSetting->website_logo) }}" alt="Bank Logo">
            <h2>Card Application Submitted</h2>
        </div>
        <div class="content">
            <p>Dear {{ Auth::user()->firstname }} {{ Auth::user()->lastname }},</p>
            <p>We have received your card application. Below are the details:</p>
            <div class="details">
                <ul>
                    <li><strong>Card Type:</strong> {{ $card->card_type }}</li>
                    <li><strong>Card Brand:</strong> {{ $card->card_brand }}</li>
                    <li><strong>Expiry Date:</strong> {{ $card->expiry_date->format('F d, Y') }}</li>
                    <li><strong>Card Status:</strong> {{ $card->card_status }}</li>
                </ul>
            </div>
        </div>
        <div class="footer">
            <p>Thank you for banking with us. You will be notified once your card is approved.</p>
        </div>
    </div>
</body>
</html>
