<x-guest-layout>
    <div class="w-full lg:w-6/12 px-4">
        <div class="relative flex flex-col min-w-0 break-words w-full mb-6 shadow-lg rounded-lg bg-slate-200 border-0">

            <div class="rounded-t mb-0 px-6 py-6">
                <div class="text-center mb-3">
                    <h6 class="text-slate-500 text-sm font-bold">
                        {{__('Sign up')}}
                    </h6>
                </div>
                <hr class="mt-6 border-b-1 border-slate-300"/>
            </div>
            <div class="flex-auto px-4 lg:px-10 py-10 pt-0">
                <form method="POST" action="{{ route('register') }}">
                    @csrf

                    <div class="relative w-full mb-3">
                        <x-input-label for="firstname" :value="__('First Name')"/>
                        <x-text-input type="text" placeholder="{{ __('First Name') }}" name="firstname"
                            id="firstname"
                            value="{{ old('firstname') }}"
                            required
                            autofocus
                        />
                        <x-input-error :messages="$errors->get('firstname')" class="mt-2" />
                    </div>

                    <div class="relative w-full mb-3">
                        <x-input-label for="lastname" :value="__('Last Name')"/>
                        <x-text-input
                            type="text"
                            placeholder="{{ __('Last Name') }}"
                            name="lastname"
                            id="lastname"
                            value="{{ old('lastname') }}"
                            required
                            autofocus
                        />
                        <x-input-error :messages="$errors->get('lastname')" class="mt-2" />
                    </div>

                    <div class="relative w-full mb-3">
                        <x-input-label for="email" :value="__('Email')" />
                        <x-text-input
                            type="email"
                            name="email"
                            id="email"
                            value="{{ old('email') }}"
                            placeholder="{{ __('Email') }}"
                            required
                        />
                        <x-input-error :messages="$errors->get('email')" class="mt-2" />
                    </div>

                    <select id="country" class="form-select" name="country_id">
                        <option value="">Select Country</option>
                        @foreach($countries as $country)
                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                        @endforeach
                    </select>
                    
                    <select id="state" class=" form-control relative w-full" name="state_id">
                        <option value="">Select State</option>
                    </select>
                    
                    <select id="city" class="relative w-full" name="city_id">
                        <option value="">Select City</option>
                    </select>

                    <div class="relative w-full mb-3">
                        <x-input-label for="password" :value="__('Password')" />
                        <x-text-input
                            type="password"
                            name="password"
                            id="password"
                            placeholder="{{ __('Password') }}"
                            required
                        />
                        <x-input-error :messages="$errors->get('password')" class="mt-2" />
                    </div>

                    <div class="relative w-full mb-3">
                        <x-input-label for="password_confirmation" :value="__('Confirm Password')" />
                        <x-text-input
                            type="password"
                            name="password_confirmation"
                            id="password_confirmation"
                            placeholder="{{ __('Confirm Password') }}"
                            required
                        />
                        <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
                    </div>

                    <div class="text-center mt-6">
                        <x-primary-button class="w-full">
                            {{ __('Register') }}
                        </x-primary-button>

                        <a class="underline text-sm text-gray-600 hover:text-gray-900" href="{{ route('login') }}">
                            {{ __('Already registered?') }}
                        </a>
                    </div>
                </form>
            </div>

        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        // Fetch countries on page load
        $(document).ready(function () {
            $.ajax({
                url: '/get-countries',
                type: 'GET',
                dataType: 'json',
                success: function (data) {
                    $('#country').empty().append('<option value="">Select Country</option>');
                    $.each(data, function (key, value) {
                        $('#country').append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                }
            });
        });
    </script>
<script>
    // Fetch states when country is selected
    $('#country').change(function () {
        var countryId = $(this).val();
        if (countryId) {
            $.ajax({
                url: '/get-states/' + countryId,
                type: 'GET',
                dataType: 'json',
                success: function (data) {
                    $('#state').empty().append('<option value="">Select State</option>');
                    $.each(data, function (key, value) {
                        $('#state').append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                }
            });
        } else {
            $('#state').empty().append('<option value="">Select State</option>');
        }
    });

    // Fetch cities when state is selected
    $('#state').change(function () {
        var stateId = $(this).val();
        if (stateId) {
            $.ajax({
                url: '/get-cities/' + stateId,
                type: 'GET',
                dataType: 'json',
                success: function (data) {
                    $('#city').empty().append('<option value="">Select City</option>');
                    $.each(data, function (key, value) {
                        $('#city').append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                }
            });
        } else {
            $('#city').empty().append('<option value="">Select City</option>');
        }
    });
</script>

</x-guest-layout>
