@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
     <title>{{$getSetting->website_name}}</title>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=Edge">
     <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
     <meta name="description" content="financial dashboard">
     <meta name="keyword" content="financial dashboard, financial reporting, admin panel, finance management">
     <meta name="csrf-token" content="{{ csrf_token() }}">
     {!!htmlScriptTagJsApi()!!}
     <!--[ Favicon]-->
     <link rel="icon" type="image/x-icon" href="{{ url('upload/', $getSetting->website_favicon) }}">
     <link rel="icon" type="image/png" sizes="16x16" href="{{ url('upload/', $getSetting->website_favicon) }}">
     <link rel="icon" type="image/png" sizes="32x32" href="{{ url('upload/', $getSetting->website_favicon) }}">
     <link rel="apple-touch-icon" sizes="180x180" href="{{ url('upload/', $getSetting->website_favicon) }}">
     <!--[ Template main css file ]-->
     <link rel="stylesheet" href="/user/assets/css/style.min.css">

</head>

<body data-theme="theme-Greylight" class="svgstroke-a ">
     <nav class="navbar navbar-expand-md position-fixed top-0 w-100 z-3 body-color ">
          <div class="container-fluid">
               <a class="navbar-brand" href="{{ url('/')}}">
                    <img src="{{ url('upload/'.$getSetting->website_logo) }}" width="144" height="44" alt="">
               </a>
               <div class="d-none d-sm-block">
                    <p class="text-muted justify-content-center">
                         Already Have an account <a class="text-reverse text-decoration-underline"
                              href="{{ url('login')}}">login</a>
                    </p>
               </div>
          </div>
     </nav>
     <main class="container-fluid">
          <div class="content mt-5">
               <!-- start: page body area -->
               <div class="mt-5">
                <div class="card-body">
                          <div class="mt-3 text-center">
                               <h6 class="text-capitalize text-center fw-bold">Open a new account</h6>
                               <span class="text-muted text-capitalize">enter your details to open an Account</span>
                          </div>
                        <div class="row justify-content-center align-items-center">
                            <div class="col-md-7 col-lg-6 col-xl-5 mt-3 p-0">
                                <div class="card p-4 shadow-sm">
                                    <form method="POST" action="{{ route('register') }}" class="mb-5">
                                        @csrf
                                        <!-- Full Name -->
                                        <div class="row g-2 mb-3">
                                            <div class="col-12 col-md-6">
                                                <label for="address" class="form-label">First Name</label>
                                                <input type="text" id="firstname" name="firstname" class="form-control"
                                                    placeholder="First Name">
                                                <x-input-error :messages="$errors->get('firstname')" class="mt-2" />
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <label for="address" class="form-label">Last Name</label>
                                                <input type="text" id="lastname" name="lastname" class="form-control"
                                                    placeholder="Last Name">
                                                <x-input-error :messages="$errors->get('lastname')" class="mt-2" />
                                            </div>

                                        </div>

                                        <div class="row g-2 mb-3">
                                            <div class="col-12 col-md-6">
                                                <label for="address" class="form-label">Userame</label>
                                                <input type="text" id="firstname" name="username" class="form-control"
                                                    placeholder="Username">
                                                <x-input-error :messages="$errors->get('username')" class="mt-2" />
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <label for="address" class="form-label">Last Name</label>
                                                <input type="email" id="email" name="email" class="form-control"
                                                    placeholder="Enter Email">
                                                <x-input-error :messages="$errors->get('email')" class="mt-2" />
                                            </div>
                                        </div>

                                        <!-- Date of Birth -->
                                        <div class="row g-2 mb-3">
                                            <div class="col-12 col-md-6">
                                                <label for="address" class="form-label">Date Of Birth</label>
                                                <input type="date" id="dob" name="dob" class="form-control"
                                                    placeholder="">
                                                <x-input-error :messages="$errors->get('dob')" class="mt-2" />
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <label for="phoneNumber" class="form-label">Gender</label>
                                                    <div class="input-group-text p-0">
                                                        <select class="form-select form-select-sm bg-transparent z1"
                                                            aria-label="Country code" name="gender">
                                                            <option selected value="Male">Male</option>
                                                            <option value="Female">Female</option>
                                                            <option value="Other">Other</option>
                                                        </select>
                                                    </div>
                                                    <x-input-error :messages="$errors->get('gender')" class="mt-2" />
                                            </div>
                                        </div>
                                        
                                        <div class="row g-2 mb-3">
                                            <div class="col-12 col-md-6">
                                                <label for="phoneNumber" class="form-label">Select Account Type</label>
                                                    <div class="input-group-text p-0">
                                                        <select class="form-select form-select-sm bg-transparent z1"
                                                            aria-label="Country code" name="account_type">
                                                            <option selected value="Savings Account">Savings Account</option>
                                                            <option value="Current Account">Current Account</option>
                                                            <option value="Retirement Account">Retirement Account</option>
                                                            <option value="Money Market Account (MMAs)">Money Market Account (MMAs)</option>
                                                            <option value="Checking Account">Checking Account</option>
                                                            <option value="Domiciliary Account">Domiciliary Account</option>
                                                            <option value="Online Banking">Online Banking</option>
                                                        </select>
                                                    </div>
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <label for="phoneNumber" class="form-label">Account Currency</label>
                                                    <div class="input-group-text p-0">
                                                        <select class="form-select form-select-sm bg-transparent z1"
                                                            aria-label="Country code" name="acct_currency">
                                                            @foreach ($currency as $currencys)
                                                                <option value="{{$currencys->symbol}}">{{$currencys->currency}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                            </div>
                                        </div>

                                        <!-- Phone Number -->
                                        <div class="mb-3">
                                                <label for="phoneNumber" class="form-label">Phone Number</label>
                                                <div class="input-group input-group-sm">
                                                    <div class="input-group-text p-0">
                                                        <select class="form-select form-select-sm bg-transparent z1"
                                                            aria-label="Country code" id="country_code" required>
                                                            @foreach($countries as $phone)
                                                                <option value="{{$phone->phonecode}}">{{$phone->emoji}} {{$phone->phonecode}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <input type="tel" name="phone" id="phone" placeholder="Phone" required
                                                        class="form-control form-control-sm">
                                                <x-input-error :messages="$errors->get('phone')" class="mt-2" />
                                                </div>
                                        </div>


                                        <!-- Country and Address -->
                                        <div class="row g-2 mb-3">
                                                <div class="col-12 col-md-6">
                                                    <label for="country" class="form-label">Country</label>
                                                    <select id="country" class="form-control custom-select" name="country_id">
                                                        <option value="">Select Country</option>
                                                        @foreach($countries as $country)
                                                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                                                        @endforeach
                                                    </select>
                                                    <input type="hidden" name="country" id="selected_country_name">
                                                </div>
                                                <div class="col-12 col-md-6">
                                                    <label for="address" class="form-label">State</label>
                                                    <select id="state" class="form-control" name="state_id">
                                                        <option value="">Select State</option>
                                                    </select>
                                                    <input type="hidden" name="state" id="selected_state_name">
                                                </div>
                                        </div>

                                        <!-- City and State -->
                                        <div class="row g-2 mb-3">
                                                <div class="col-12 col-md-6">
                                                    <label for="city" class="form-label">City</label>
                                                    <select id="city" class="form-control" name="city_id">
                                                        <option value="">Select City</option>
                                                    </select>
                                                    <input type="hidden" name="city" id="selected_city_name">
                                                </div>
                                                <div class="col-12 col-md-6">
                                                    <label for="state" class="form-label">Address</label>
                                                    <input type="text" id="address" name="address"  class="form-control"
                                                    placeholder="Address">
                                                    <x-input-error :messages="$errors->get('address')" class="mt-2" />
                                                </div>
                                        </div>

                                        <!-- ZIP Code -->
                                        <div class="mb-3">
                                                <label for="zipCode" class="form-label">SSN</label>
                                                <input type="text" id="zipCode" name="acct_ssn" class="form-control"
                                                    placeholder="SSN">
                                                <x-input-error :messages="$errors->get('acct_ssn')" class="mt-2" />
                                        </div>

                                        <div class="row g-2 mb-3">
                                            <div class="col-12 col-md-6">
                                                <label for="password" class="form-label">Password</label>
                                                <input type="password" id="password" name="password" class="form-control" placeholder="Enter Password">
                                                <x-input-error :messages="$errors->get('password')" class="mt-2" />
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <label for="password" class="form-label">Confirm Password</label>
                                                <input type="password" id="password" name="password_confirmation"  class="form-control" placeholder="Address">
                                                <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
                                            </div>
                                        </div>

                                        <div class="col-sm-12 mb-3">
                                            <div class="form-checkbox">
                                                {!! htmlFormSnippet([
                                                    "theme" => "light",
                                                    "size" => "normal",
                                                    "tabindex" => "3",
                                                    "callback" => "callbackFunction",
                                                    "expired-callback" => "expiredCallbackFunction",
                                                    "error-callback" => "errorCallbackFunction",
                                                ]) !!}
                                            </div>
                                            @if ($errors->has('g-recaptcha-response'))
                                                <span class="text-danger">{{ $errors->first('g-recaptcha-response') }}</span>
                                            @endif
                                        </div>

                                        <!-- Continue Button -->
                                        <div class="d-grid mb-3">
                                                <button type="submit"
                                                    class="btn btn-dark">Open Account</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
          </div>
     </main>
     <footer class="w-100 bg-body position-fixed bottom-0">
          <div class="container-fluid">
               <div class="d-flex align-items-center">
                    <div class="p-0 m-0">
                         <a class="link-offset-2 link-offset-3-hover link-underline link-underline-opacity-0 link-underline-opacity-75-hover text-reverse"
                              href="#">
                              @2024 Fintechweb
                         </a>
                    </div>
                    <div class="  ms-auto p-2 pe-0">
                         <div class="dropdown position-relative">
                              <button class="btn border dropdown-toggle w-100" type="button" data-bs-toggle="dropdown"
                                   aria-expanded="false">eng</button>
                              <ul class="dropdown-menu dropdown-menu-end" style="">
                                   <li><a class="dropdown-item" href="#" onclick="selectLanguage('hi')">Hindi</a></li>
                                   <li><a class="dropdown-item" href="#" onclick="selectLanguage('bn')">Bengali</a></li>
                                   <li><a class="dropdown-item" href="#" onclick="selectLanguage('te')">Telugu</a></li>
                                   <li><a class="dropdown-item" href="#" onclick="selectLanguage('ta')">Tamil</a></li>
                                   <li><a class="dropdown-item" href="#" onclick="selectLanguage('mr')">Marathi</a></li>
                                   <li><a class="dropdown-item" href="#" onclick="selectLanguage('gu')">Gujarati</a>
                                   </li>
                                   <li><a class="dropdown-item" href="#" onclick="selectLanguage('kn')">Kannada</a></li>
                                   <li><a class="dropdown-item" href="#" onclick="selectLanguage('ml')">Malayalam</a>
                                   </li>
                              </ul>
                         </div>
                    </div>
               </div>
          </div>
     </footer>

     <script>
        document.addEventListener("DOMContentLoaded", function () {
            let countryCodeSelect = document.getElementById("country_code");
            let phoneInput = document.getElementById("phone");

            // Auto-fill the default selected country code
            phoneInput.value = countryCodeSelect.value;

            // Update phone input when the country code changes
            countryCodeSelect.addEventListener("change", function () {
                phoneInput.value = this.value;
            });

            // Prevent duplicate country code when typing
            phoneInput.addEventListener("input", function () {
                let selectedCode = countryCodeSelect.value;
                if (!this.value.startsWith(selectedCode)) {
                    this.value = selectedCode + this.value.replace(/^\+\d+\s*/, ""); // Remove old country code if present
                }
            });
        });
    </script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
$.ajax({
    url: '/get-countries',
    type: 'GET',
    dataType: 'json',
    success: function (data) {
        $('#country').empty().append('<option value="">Select Country</option>');
        $.each(data, function (key, value) {
            // Set country.name as the value and keep country.id for fetching states
            $('#country').append('<option value="' + value.id + '" data-name="' + value.name + '">' + value.name + '</option>');
        });
    }
});
});

</script>

<script>
$('#country').change(function () {
var countryId = $(this).val();
var countryName = $(this).find(':selected').data('name');  // Get country name
$('#selected_country_name').val(countryName);  // Save the name in a hidden field

if (countryId) {
    $.ajax({
        url: '/get-states/' + countryId,
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            $('#state').empty().append('<option value="">Select State</option>');
            $.each(data, function (key, value) {
                // Set state.name as the value
                $('#state').append('<option value="' + value.id + '" data-name="' + value.name + '">' + value.name + '</option>');
            });
        }
    });
} else {
    $('#state').empty().append('<option value="">Select State</option>');
}
});

</script>
<script>
$('#state').change(function () {
var stateId = $(this).val();
var stateName = $(this).find(':selected').data('name');  // Get state name
$('#selected_state_name').val(stateName);  // Save the name in a hidden field

if (stateId) {
    $.ajax({
        url: '/get-cities/' + stateId,
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            $('#city').empty().append('<option value="">Select City</option>');
            $.each(data, function (key, value) {
                // Set city.name as the value
                $('#city').append('<option value="' + value.id + '" data-name="' + value.name + '">' + value.name + '</option>');
            });
        }
    });
} else {
    $('#city').empty().append('<option value="">Select City</option>');
}
});

$('#city').change(function () {
var cityName = $(this).find(':selected').data('name');  // Get city name
$('#selected_city_name').val(cityName);  // Save the name in a hidden field
});

</script>

     <!--[ FintechWeb template vender js ]-->
     <script src="/user/assets/bundles/libscripts.bundle.js"></script>
     <script src="/user/assets/bundles/dynamicselect.js"></script>
     <script src="/user/assets/js/main.js" defer></script> 
     <!--============== active class js =============-->
     <script src="/user/assets/js/active-class.js"></script>
     <!-- Template page js -->

     <script>
          $(document).ready(function () {
               $('#password').on('input', function () {
                    var password = $(this).val();
                    var strength = 0;
                    var indicators = $('#strength-indicators li');

                    // Check for lowercase and uppercase
                    if (/[a-z]/.test(password) && /[A-Z]/.test(password)) {
                         strength++;
                         indicators.eq(0).find('span').addClass('valid');
                    } else {
                         indicators.eq(0).find('span').removeClass('valid');
                    }

                    // Check for numbers
                    if (/\d/.test(password)) {
                         strength++;
                         indicators.eq(1).find('span').addClass('valid');
                    } else {
                         indicators.eq(1).find('span').removeClass('valid');
                    }

                    // Check for special characters
                    if (/[!@#$%^&*]/.test(password)) {
                         strength++;
                         indicators.eq(2).find('span').addClass('valid');
                    } else {
                         indicators.eq(2).find('span').removeClass('valid');
                    }

                    // Check for length
                    if (password.length >= 8) {
                         strength++;
                         indicators.eq(3).find('span').addClass('valid');
                    } else {
                         indicators.eq(3).find('span').removeClass('valid');
                    }

                    // Update progress bar
                    var strengthPercent = (strength / 4) * 100;
                    $('#password-strength').css('width', strengthPercent + '%');

                    // Change progress bar color based on strength
                    if (strengthPercent === 100) {
                         $('#password-strength').addClass('bg-success').removeClass('bg-danger');
                    } else if (strengthPercent >= 50) {
                         $('#password-strength').addClass('bg-warning').removeClass('bg-danger').removeClass('bg-success');
                    } else {
                         $('#password-strength').addClass('bg-danger').removeClass('bg-warning').removeClass('bg-success');
                    }
               });
          });


     </script>
</body>

</html>