<x-adm>

    <div class="content container-fluid">
        <!-- row -->
        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @elseif (session('warning'))
            <div class="alert alert-warning">{{ session('warning') }}</div>
        @endif
        <div class="row">
            <div class="col-xl-12 col-lg-8">
                <div class="card profile-card card-bx mb-3">
                    <div class="card-header">
                        <h6 class="title">Add Next of Kin</h6>
                    </div>
                    <form action="{{ route('next-of-kin.store') }}" method="POST">
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-4 mb-3">
                                    <label class="form-label">Account Holder</label>
                                    <select class="select2 form-control" name="user_id" id="validationCustom05">
                                        @foreach ($user as $users)
                                            <option value="{{ $users->id }}">{{ $users->firstname }}
                                                {{ $users->lastname }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-sm-4 mb-3">
                                    <label class="form-label">Next of Kin First Name</label>
                                    <input type="text" name="first_name" class="form-control"
                                        placeholder="First Name">
                                </div>
                                <div class="col-sm-4 mb-3">
                                    <label class="form-label">Next of Kin Last Name</label>
                                    <input type="text" name="last_name" class="form-control" placeholder="Last Name">
                                </div>
                                <div class="col-sm-4 mb-3">
                                    <label class="form-label">Relationship</label>
                                    <select name="relationship" class="select2 form-control" required>
                                        <option value="" disabled selected>Select relationship</option>
                                        @php
                                            $relationships = [
                                                'Spouse',
                                                'Father',
                                                'Mother',
                                                'Son',
                                                'Daughter',
                                                'Brother',
                                                'Sister',
                                                'Uncle',
                                                'Aunt',
                                                'Nephew',
                                                'Niece',
                                                'Grandfather',
                                                'Grandmother',
                                                'Grandson',
                                                'Granddaughter',
                                                'Cousin',
                                            ];
                                        @endphp

                                        @foreach ($relationships as $relation)
                                            <option value="{{ $relation }}"
                                                {{ old('relationship', $nok->relationship ?? '') === $relation ? 'selected' : '' }}>
                                                {{ $relation }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-sm-4 mb-3">
                                    <label class="form-label">Phone</label>
                                    <input type="tel" name="phone" class="form-control" placeholder="Phone">
                                </div>
                                <div class="col-sm-4 mb-3">
                                    <label class="form-label">Email</label>
                                    <input type="email" name="email" class="form-control" placeholder="Enter Email">
                                </div>
                                <div class="col-sm-4 mb-3">
                                    <label class="form-label">Address</label>
                                    <input type="text" name="address" class="form-control"
                                        placeholder="Enter Address">
                                </div>
                                <div class="col-sm-4 mb-3">
                                    <label class="form-label">Date of Birth</label>
                                    <input type="date" name="dob" class="form-control"
                                        placeholder="Date of Birth">
                                </div>
                                <div class="col-sm-4 mb-3">
                                    <label class="form-label">SSN</label>
                                    <input type="number" name="ssn" class="form-control" placeholder="Enter SSN">
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Occupation</label>
                                    <input type="text" name="occupation" class="form-control"
                                        placeholder="Occupation">
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Emergency Contact</label>
                                    <input type="tel" name="emergency_contact" class="form-control"
                                        placeholder="Enter Emergency Contact">
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


</x-adm>
