<x-adm>
    <!-- container starts -->
    <div class="content container-fluid">
        @if (session('message'))
            <div class="alert alert-success">
                {{ session('message') }}
            </div>
        @endif
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-lg-8">
                <!-- Column starts -->
                <div class="card dz-card" id="bootstrap-table2">
                    <div class="card-header flex-wrap d-flex justify-content-between  border-0">
                        <div>
                            <h4 class="card-title">Next Of Kins</h4>
                        </div>
                        <ul class="nav nav-tabs dzm-tabs" id="myTab-1" role="tablist">
                            <div class="d-flex align-items-center">
                                <a href="{{ url('admin/users/next_add') }}" class="btn btn-primary btn-sm ms-2"
                                    aria-controls="offcanvasExample">+ Add Next Of Kin</a>
                            </div>
                        </ul>
                    </div>

                    <!-- tab-content -->
                    <div class="tab-content" id="myTabContent-1">
                        <div class="tab-pane fade show active" id="bordered" role="tabpanel"
                            aria-labelledby="home-tab-1">
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-responsive-md">
                                        <thead>
                                            <tr>
                                                <th style="width:50px;">
                                                    <div
                                                        class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                        <input type="checkbox" class="form-check-input" id="checkAll"
                                                            required="">
                                                        <label class="form-check-label" for="checkAll"></label>
                                                    </div>
                                                </th>
                                                <th><strong>Account Holder</strong></th>
                                                <th><strong>Next of Kin</strong></th>
                                                <th><strong>Action</strong></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse ($next as $users)
                                                <tr>
                                                    <td>
                                                        <div
                                                            class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                            <input type="checkbox" class="form-check-input"
                                                                id="customCheckBox2" required="">
                                                            <label class="form-check-label"
                                                                for="customCheckBox2"></label>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar avatar-sm me-2 avatar-rounded">
                                                                <img src="{{ url('upload/', $users->user->photo) }}"
                                                                    alt="img">
                                                            </div>
                                                            <div>
                                                                <div class="lh-1">
                                                                    <span>{{ $users->user->firstname }}
                                                                        {{ $users->user->lastname }}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>{{ $users->first_name }} {{ $users->last_name }}</td>
                                                    <td>
                                                        <div class="d-flex">
                                                            <a href="{{ url('admin/users/next_update/' . $users->id) }}"
                                                                class="btn btn-primary shadow btn-xs sharp me-1"><i
                                                                    class="fa fa-pencil"></i></a>
                                                            <form action="{{ url('admin/next/delete/' . $users->id) }}"
                                                                method="post">
                                                                @csrf
                                                                <button
                                                                    onclick="return confirm(' are you sure you want to delete?');"
                                                                    type="submit"
                                                                    class="btn btn-danger shadow btn-xs sharp"><i
                                                                        class="fa fa-trash"></i></button>
                                                            </form>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr class="text-center">
                                                    <td colspan="100%" class="fw-bold"> No Next Of Kin Details
                                                        Available.</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                    <!-- Pagination Links -->
                                    <div class="pagination-style-1" style="padding: 10px; float:left;">
                                        {!! $next->appends(Illuminate\Support\Facades\Request::except('page'))->links() !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /tab-content -->
                </div>
            </div>
            <!-- Column ends -->
        </div>
</x-adm>
