<x-adm>

	<div class="content container-fluid">
        @if(session('message'))
            <div class="alert alert-success">
                {{ session('message') }}
            </div>
        @endif
		<!-- /Page Header -->

		<div class="row">
			<div class="col-xl-12">
				<div class="card">
					<div class="card-header justify-content-between">
						<div class="card-title">
							All Users
						</div>

					</div>
					<div class="card-body">
						<div class="table-responsive">
							<table class="table text-nowrap table-striped table-hover">
								<thead>
									<tr>
										<th scope="col">Name</th>
										<th scope="col">Account No</th>
										<th scope="col">Email</th>
										<th scope="col">Currency</th>
										<th scope="col">Account Balance</th>
										<th scope="col">AccountStatus</th>
										<th scope="col">Date Created</th>
										<th scope="col">Action</th>
									</tr>
								</thead>
								<tbody>
									@foreach ($getRecord as $users)
										<tr>
											<td>
												<div class="d-flex align-items-center">
													<div class="avatar avatar-sm me-2 avatar-rounded">
														<img src="{{ url('upload/', $users->photo) }}" alt="img">
													</div>
													<div>
														<div class="lh-1">
															<span>{{$users->firstname}} {{$users->lastname}}</span>
														</div>
														<div class="lh-1">
															<span class="fs-11 text-muted">{{$users->email}}</span>
														</div>
													</div>
												</div>
											</td>
											<th scope="row">{{$users->account_no}}</th>
											<td>{{$users->email}}</td>
											<td>{{$users->acct_currency}}</td>
											<td>{{$users->account_balance}}</td>
											<td>
												<span>
													@if($users->acct_status === 'Active')
														<span class="btn btn-sm bg-success text-white">Active Account</span> 
													@elseif($users->acct_status === 'Location')
														<span class="btn btn-sm bg-secondary text-white">Location Restriction</span>
													@elseif($users->acct_status === 'Suspended')
														<span class="btn btn-sm bg-danger text-white">Suspended Account</span>
													@endif
												</span>
											</td>
											<td>{{$users->created_at}}</td>
											<td>
												<div class="hstack gap-2 fs-15">
													<a href="{{ url('admin/users/edit/'. $users->id)}}" class="btn btn-sm btn-success">View</a>
													<form action="{{ url('admin/users/delete/'.$users->id) }}" method="POST" style="display:inline-block;">
														@csrf
														<button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this Account?');">Delete</button>
													</form>
												</div>
											</td>
										</tr>
									@endforeach
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</x-adm>