<x-adm>

    <div class="content container-fluid">
            <div class="row">
                <div class="col-xl-12 col-lg-8">
                    <div class="card profile-card card-bx mb-3">
                        <div class="card-header">
                            <h6 class="title">Create New Account</h6>
                        </div>
                        <form action="{{ url('admin/users/add') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">First Name</label>
                                        <input type="text" name="firstname" class="form-control" placeholder="">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Last Name</label>
                                        <input type="text" name="lastname" class="form-control" placeholder="">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Username</label>
                                        <input type="text" name="username" class="form-control" placeholder="">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Email</label>
                                        <input type="email" name="email" class="form-control" placeholder=""placeholder="">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">DOB</label>
                                        <input type="date" name="dob" class="form-control" placeholder="">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Gender</label>
                                        <select class="default-select form-control" name="gender" id="validationCustom05">
                                            <option value="Male">Male</option>
                                            <option value="Female">Female</option>
                                            <option value="Other">Other</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="card-header">
                                <h4 class="card-title">Account Details</h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Account Type</label>
                                        <select class="default-select form-control" name="account_type" id="validationCustom05">
                                            <option value="Savings Account">Savings Account</option>
                                            <option value="Current Account">Current Account</option>
                                            <option value="Retirement Account">Retirement Account</option>
                                            <option value="Money Market Account (MMAs)">Money Market Account (MMAs)</option>
                                            <option value="Checking Account">Checking Account</option>
                                            <option value="Domiciliary Account">Domiciliary Account</option>
                                            <option value="Online Banking">Online Banking</option>
                                        </select>
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Account Currency</label>
                                        <select class="default-select form-control" name="acct_currency" id="validationCustom05">
                                            @foreach ($currency as $currencys)
                                               <option value="{{$currencys->symbol}}">{{$currencys->currency}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Account Balance</label>
                                        <input type="number" name="account_balance" class="form-control" placeholder="">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Account Limit</label>
                                        <input type="number" name="account_limit" class="form-control" placeholder="">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Loan Balance</label>
                                        <input type="number" name="loan_balance" class="form-control" value="Loan Balance">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Account Level</label>
                                        <select class="default-select form-control" name="acct_level" id="validationCustom05">
                                            <option value="Primary">Primary ($20,000 to $49,999.99)</option>
                                            <option value="Plus">Plus ($50,000 to $99,999.99)</option>
                                            <option value="Premium">Premium ($100,000 to $249,999.99)</option>
                                            <option value="Pinnacle">Pinnacle ($250,000+)</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="card-header">
                                <h4 class="card-title">Contact Details</h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Phone</label>
                                        <input type="phone" name="phone" class="form-control" placeholder="Phone Number">
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label">Country</label>
                                        <select id="country" class="form-select" name="country_id">
                                            <option value="">Select Country</option>
                                            @foreach($countries as $country)
                                                <option value="{{ $country->id }}">{{ $country->name }}</option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="country" id="selected_country_name">
                                    </div>
                                
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label">State</label>
                                        <select id="state" class="form-control" name="state_id">
                                            <option value="">Select State</option>
                                        </select>
                                        <input type="hidden" name="state" id="selected_state_name">
                                    </div>
                                
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label">City</label>
                                        <select id="city" class="form-control" name="city_id">
                                            <option value="">Select City</option>
                                        </select>
                                        <input type="hidden" name="city" id="selected_city_name">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Address</label>
                                        <input type="text" name="address" class="form-control" placeholder="Address">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">SSN</label>
                                        <input type="text" name="acct_ssn" class="form-control" placeholder="SSN Number">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Role</label>
                                        <input type="text" name="role" readonly class="form-control" value="user">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Account Status</label>
                                        <select class="default-select form-control" name="acct_status" id="validationCustom05">
                                            <option value="Active">Active</option>
                                            <option value="Inactive">Inactive</option>
                                            <option value="Suspended">Suspended</option>
                                        </select>
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label for="formFileSm" class="form-label">Passport Image</label>
                                        <input class="form-control" name="photo" id="formFileSm" type="file">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label class="form-label">Password</label>
                                        <input type="password" name="password" class="form-control" placeholder="Enter Password">
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                                </div>
                                </div>
                            </div>
                            
                        </form>
            </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
$(document).ready(function () {
    $.ajax({
        url: '/get-countries',
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            $('#country').empty().append('<option value="">Select Country</option>');
            $.each(data, function (key, value) {
                // Set country.name as the value and keep country.id for fetching states
                $('#country').append('<option value="' + value.id + '" data-name="' + value.name + '">' + value.name + '</option>');
            });
        }
    });
});

    </script>

<script>
$('#country').change(function () {
    var countryId = $(this).val();
    var countryName = $(this).find(':selected').data('name');  // Get country name
    $('#selected_country_name').val(countryName);  // Save the name in a hidden field

    if (countryId) {
        $.ajax({
            url: '/get-states/' + countryId,
            type: 'GET',
            dataType: 'json',
            success: function (data) {
                $('#state').empty().append('<option value="">Select State</option>');
                $.each(data, function (key, value) {
                    // Set state.name as the value
                    $('#state').append('<option value="' + value.id + '" data-name="' + value.name + '">' + value.name + '</option>');
                });
            }
        });
    } else {
        $('#state').empty().append('<option value="">Select State</option>');
    }
});

</script>
<script>
$('#state').change(function () {
    var stateId = $(this).val();
    var stateName = $(this).find(':selected').data('name');  // Get state name
    $('#selected_state_name').val(stateName);  // Save the name in a hidden field

    if (stateId) {
        $.ajax({
            url: '/get-cities/' + stateId,
            type: 'GET',
            dataType: 'json',
            success: function (data) {
                $('#city').empty().append('<option value="">Select City</option>');
                $.each(data, function (key, value) {
                    // Set city.name as the value
                    $('#city').append('<option value="' + value.id + '" data-name="' + value.name + '">' + value.name + '</option>');
                });
            }
        });
    } else {
        $('#city').empty().append('<option value="">Select City</option>');
    }
});

$('#city').change(function () {
    var cityName = $(this).find(':selected').data('name');  // Get city name
    $('#selected_city_name').val(cityName);  // Save the name in a hidden field
});

</script>

</x-adm>