<x-adm>

    <div class="content container-fluid">
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-lg-8">
                <div class="card profile-card card-bx mb-3">
                    <div class="card-header">
                        <h6 class="title">Update Transaction History</h6>
                    </div>
                    <form action="{{ url('admin/transactions/update/' .$transaction->id)}}" method="post">
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Amount</label>
                                    <input type="text" name="amount" class="form-control" value="{{$transaction->amount}}">
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Transaction Type</label>
                                    <select class="default-select form-control" name="transaction_type" id="validationCustom05">
                                           <option value="{{$transaction->transaction_type}}">{{$transaction->transaction_type}}</option>
                                           <option value="Debit">Debit</option>
                                           <option value="Credit">Credit</option>
                                           <option value="Wire Transfer">Wire Transfer</option>
                                           <option value="Domestic Transfer">Domestic Transfer</option>
                                           <option value="Check Deposit">Check Deposit</option>
                                    </select>
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Currency</label>
                                    <select id="country" class="default-select form-control" name="currency">
                                        <option value="{{$transaction->currency}}">{{$transaction->currency}}</option>
                                        @foreach($currency as $country)
                                            <option value="{{ $country->symbol }}">{{ $country->currency }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Status</label>
                                    <select class="default-select form-control" name="status" id="validationCustom05">
                                           <option value="{{$transaction->status}}">{{$transaction->status}}</option>
                                           <option value="Pending">Pending</option>
                                           <option value="Processing">Processing</option>
                                           <option value="Completed">Completed</option>
                                           <option value="Failed">Failed</option>
                                    </select>
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Transaction Date</label>
                                    <input type="datetime-local" name="transaction_date" class="form-control" value="{{$transaction->transaction_date}}">
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Description</label>
                                    <input type="text" name="description" class="form-control" value="{{$transaction->description}}">
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>



</x-adm>