<x-adm>

    <div class="content container-fluid">
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-lg-8">
                <div class="card profile-card card-bx mb-3">
                    <div class="card-header">
                        <h6 class="title">Add Transaction History</h6>
                    </div>
                    <form action="{{ url('admin/transactions/history')}}" method="post">
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Account Holder</label>
                                    <select class="select2 form-control" name="user_id" id="validationCustom05">
                                        @foreach ($user as $users)
                                           <option value="{{$users->id}}">{{$users->firstname}} {{$users->lastname}}</option> 
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Beneficiary Bank</label> 
                                    <select class="select2 form-control" name="bank_name" value="">
                                        @foreach ($banks as $bank)
                                        <option value="{{$bank->name}}">{{$bank->name}}</option> 
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Currency</label>
                                    <select id="country" class="select2 form-control" name="currency">
                                        <option value="">Select Currency</option>
                                        @foreach($currency as $country)
                                            <option value="{{ $country->symbol }}">{{ $country->currency }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Account Name</label>
                                    <input type="text" name="account_name" class="form-control" placeholder="Account Name">
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Account Number</label>
                                    <input type="number" name="account_number" class="form-control" placeholder="Account Number">
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Amount</label>
                                    <input type="number" name="amount" class="form-control" placeholder="amount">
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Transaction Type</label>
                                    <select class="select2 form-control" name="transaction_type" id="validationCustom05">
                                           <option value="Debit">Debit</option>
                                           <option value="Credit">Credit</option>
                                           <option value="Domestic Transfer">Domestic Transfer</option>
                                           <option value="Wire Transfer">Wire Transfer</option>
                                           <option value="Check Deposit">Check Deposit</option>
                                    </select>
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Status</label>
                                    <select class="select2 form-control" name="status" id="validationCustom05">
                                        <option value="Pending">Pending</option>
                                        <option value="Processing">Processing</option>
                                        <option value="Completed">Completed</option>
                                        <option value="Failed">Failed</option>
                                    </select>
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Transaction Date</label>
                                    <input type="datetime-local" name="transaction_date" class="form-control" placeholder="Date">
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label class="form-label">Description</label>
                                    <input type="text" name="description" class="form-control" placeholder="Description">
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

  
</x-adm>