<x-adm>
    <!-- container starts -->
    <div class="content container-fluid">
        @if(session('message'))
            <div class="alert alert-success">
                {{ session('message') }}
            </div>
        @endif
                <!-- row -->
                <div class="row">
                    <div class="col-xl-12 col-lg-8">
                        <!-- Column starts -->
                            <div class="card dz-card" id="bootstrap-table2">
                                <div class="card-header flex-wrap d-flex justify-content-between  border-0">
                                    <div>
                                        <h4 class="card-title">Domestic Transfers</h4>
                                    </div>
                                </div>
                                
                                    <!-- tab-content -->
                                <div class="tab-content" id="myTabContent-1">
                                    <div class="tab-pane fade show active" id="bordered" role="tabpanel" aria-labelledby="home-tab-1">
                                        <div class="card-body">
                                            <div class="table-responsive">
                                                <table class="table table-responsive-md">
                                                    <thead>
                                                        <tr>
                                                            <th style="width:50px;">
                                                                <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                    <input type="checkbox" class="form-check-input" id="checkAll" required="">
                                                                    <label class="form-check-label" for="checkAll"></label>
                                                                </div>
                                                            </th>
                                                            <th><strong>User</strong></th>
                                                            <th><strong>Beneficiary</strong></th>
                                                            <th><strong>Amount</strong></th>
                                                            <th><strong>Transaction Type</strong></th>
                                                            <th><strong>Status</strong></th>
                                                            <th><strong></strong></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @forelse ($local as $transaction)
                                                        <tr>
                                                            <td>
                                                                <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                    <input type="checkbox" class="form-check-input" id="customCheckBox2" required="">
                                                                    <label class="form-check-label" for="customCheckBox2"></label>
                                                                </div>
                                                            </td>
                                                            <td><strong>{{$transaction->User->firstname}} {{$transaction->User->lastname}}</strong></td>
                                                            <td><strong>{{$transaction->beneficiary_name}}</strong></td>
                                                            <td>
                                                                {{$transaction->amount}}
                                                            </td>
                                                            <td>{{$transaction->transaction_type}}</td>
                                                            <td>
                                                                <span>
                                                                    @if($transaction->status === 'Completed')
                                                                        <span class="btn btn-sm bg-success text-white">Completed</span> 
                                                                    @elseif($transaction->status === 'Pending')
                                                                        <span class="btn btn-sm bg-info text-white">Pending</span> 
                                                                    @elseif($transaction->status === 'Processing')
                                                                        <span class="btn btn-sm bg-primary text-white">Processing</span>
                                                                    @elseif($transaction->status === 'Failed')
                                                                        <span class="btn btn-sm bg-danger text-white">Failed</span>
                                                                    @endif
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <div class="d-flex">
                                                                    <a href="{{ url('admin/transactions/domestic_edit/' .$transaction->id )}}" class="btn btn-primary shadow btn-xs sharp me-1"><i class="fa fa-pencil"></i></a>
                                                                    <a href="#" class="btn btn-danger shadow btn-xs sharp"><i class="fa fa-trash"></i></a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        @empty
                                                        <tr>
                                                            <td colspan="100%"> No Record Found.</td>
                                                        </tr>
                                                        @endforelse
                                                    </tbody>
                                                </table>
                                                <!-- Pagination Links -->
                                                <div class="pagination-style-1" style="padding: 10px; float:left;">
                                                    {!! $local->appends(Illuminate\Support\Facades\Request::except('page'))->links() !!}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade " id="bordered-html" role="tabpanel" aria-labelledby="home-tab-1">
                                        <div class="card-body pt-0 p-0 code-area">		
    
                                    </div>		
                                    </div>
                                </div>
                                <!-- /tab-content -->	
                                
                            </div>
                        </div>
                        <!-- Column ends -->
                </div>
                    </div>
                    </div>
                </div>			
            </div>
        
    
    </x-adm>