<x-adm>
    <!-- container starts -->
    <div class="content container-fluid">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
                <!-- row -->
                <div class="row">
                    <div class="col-xl-12 col-lg-8">
                        <!-- Column starts -->
                            <div class="card dz-card" id="bootstrap-table2">
                                <div class="card-header flex-wrap d-flex justify-content-between  border-0">
                                    <div>
                                        <h4 class="card-title">Card Transaction Histories</h4>
                                    </div>
                                    <ul class="nav nav-tabs dzm-tabs" id="myTab-1" role="tablist">
                                        <div class="d-flex align-items-center">
                                            <a href="{{ url('admin/transactions/cards_add')}}" class="btn btn-primary btn-sm ms-2" aria-controls="offcanvasExample">+ Add Card Transaction</a>
                                        </div>
                                    </ul>
                                </div>
                                
                                    <!-- tab-content -->
                                <div class="tab-content" id="myTabContent-1">
                                    <div class="tab-pane fade show active" id="bordered" role="tabpanel" aria-labelledby="home-tab-1">
                                        <div class="card-body">
                                            <div class="table-responsive">
                                                <table class="table table-responsive-md">
                                                    <thead>
                                                        <tr>
                                                            <th style="width:50px;">
                                                                <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                    <input type="checkbox" class="form-check-input" id="checkAll" required="">
                                                                    <label class="form-check-label" for="checkAll"></label>
                                                                </div>
                                                            </th>
                                                            <th><strong>User</strong></th>
                                                            <th><strong>Card</strong></th>
                                                            <th><strong>Amount</strong></th>
                                                            <th><strong>Transaction Type</strong></th>
                                                            <th><strong>Description</strong></th>
                                                            <th><strong>Status</strong></th>
                                                            <th><strong></strong></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @forelse ($cards as $card)
                                                        <tr>
                                                            <td>
                                                                <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                    <input type="checkbox" class="form-check-input" id="customCheckBox2" required="">
                                                                    <label class="form-check-label" for="customCheckBox2"></label>
                                                                </div>
                                                            </td>
                                                            <td><strong>{{$card->Card->User->firstname}} {{$card->Card->User->lastname}}</strong></td>
                                                            <td><strong>{{$card->Card->card_brand}} | {{$card->Card->card_number}}</strong></td>
                                                            <td>{{$card->amount}}</td>
                                                            <td>{{$card->transaction_type}}</td>
                                                            <td>{{$card->description}}</td>
                                                            <td>
                                                                <span>
                                                                    @if($card->status === 'success')
                                                                        <span class="btn btn-sm bg-success text-white">Success</span> 
                                                                    @elseif($card->status === 'pending')
                                                                        <span class="btn btn-sm bg-info text-white">Pending</span> 
                                                                    @elseif($card->status === 'failed')
                                                                        <span class="btn btn-sm bg-danger text-white">Failed</span>
                                                                    @endif
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <div class="d-flex">
                                                                    <a href="{{ url('admin/transactions/cards_edit/' .$card->id )}}" class="btn btn-primary shadow btn-xs sharp me-1"><i class="fa fa-pencil"></i></a>
                                                                <form action="{{ route('admin.transactions.cards.destroy', $card->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this transaction?');">
                                                                    @csrf
                                                                    @method('DELETE')    
                                                                    <button type="submit" class="btn btn-danger shadow btn-xs sharp"><i class="fa fa-trash"></i></button>
                                                                </form>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        @empty
                                                        <tr>
                                                            <td colspan="100%"> No Record Found.</td>
                                                        </tr>
                                                        @endforelse
                                                    </tbody>
                                                </table>
                                                <!-- Pagination Links -->
                                                <div class="pagination-style-1" style="padding: 10px; float:left;">
                                                    {{$cards->links()}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- /tab-content -->	
                            </div>
                    </div>
                    <!-- Column ends -->
                </div>
    </x-adm>