<x-adm>

<style>
        .status-activated {
    color: green;
}

.status-deactivated {
    color: red;
}

</style>

<div class="content container-fluid">
    @if(session('message'))
        <div class="alert alert-success">
            {{ session('message') }}
        </div>
    @endif
        <!-- row -->
        <div class="row">
            <!-- Column  -->
            <div class="col-xl-12">
                <div class="card dz-card">
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="DefaultTab" role="tabpanel" aria-labelledby="home-tab">
                            <div class="card-body pt-0">
                                <!-- Nav tabs -->
                                <div class="default-tab">
                                    <ul class="nav nav-tabs" role="tablist">
                                        <li class="nav-item">
                                            <a class="nav-link {{ request()->get('tab') == 'home' || !request()->has('tab') ? 'active' : '' }}" 
                                               data-bs-toggle="tab" href="?tab=home#home">
                                               <i class="la la-home me-2"></i> Website Setting
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link {{ request()->get('tab') == 'profile' ? 'active' : '' }}" 
                                               data-bs-toggle="tab" href="?tab=profile#profile">
                                               <i class="la la-user me-2"></i> Billing Codes
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link {{ request()->get('tab') == 'contact' ? 'active' : '' }}" 
                                               data-bs-toggle="tab" href="?tab=contact#contact">
                                               <i class="la la-envelope me-2"></i> Email SMTP Config
                                            </a>
                                        </li>
                                    </ul>
                                    <div class="tab-content card-body">
                                        <div class="tab-pane fade {{ request()->get('tab') == 'home' || !request()->has('tab') ? 'show active' : '' }}" id="home">
                                            <div class="row">
                                                <div class="col-xl-12 col-lg-8">
                                                    <div class="card profile-card card-bx mb-4">
                                                        <div class="card-header">
                                                            <h6 class="title">General Settings</h6>
                                                        </div>
                                                        <form action="{{ url('admin/settings') }}" method="post" enctype="multipart/form-data">
                                                            @csrf
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Website Name</label>
                                                                        <input type="text" name="website_name" class="form-control" value="{{$website->website_name}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Website Link</label>
                                                                        <input type="text" name="website_link" class="form-control" value="{{$website->website_link}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">System Address</label>
                                                                        <input type="text" name="website_address" class="form-control" value="{{$website->website_address}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">System Phone</label>
                                                                        <input type="phone" name="website_phone" class="form-control" value="{{$website->website_phone}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">System Email</label>
                                                                        <input type="email" name="website_email" class="form-control" value="{{$website->website_email}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Live Chat Widget Link</label>
                                                                        <input type="text" name="chatwidget" class="form-control" value="{{$website->chatwidget}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Card Request Fee</label>
                                                                        <input type="number" name="card_fee" class="form-control" value="{{$website->card_fee}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Wire Transfer Fee</label>
                                                                        <input type="number" name="wire_fee" class="form-control" value="{{$website->wire_fee}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Wire Limit</label>
                                                                        <input type="number" name="wire_limit" class="form-control" value="{{$website->wire_limit}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Domestic Transfer Fee</label>
                                                                        <input type="number" name="domestic_fee" class="form-control" value="{{$website->domestic_fee}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Domestic Limit</label>
                                                                        <input type="number" name="domestic_limit" class="form-control" value="{{$website->domestic_limit}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Loan Limit</label>
                                                                        <input type="number" name="loan_limit" class="form-control" value="{{$website->loan_limit}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label for="operation">Login Otp:</label>
                                                                        <span class="{{ $website->login_otp == 1 ? 'status-activated' : 'status-deactivated' }}">
                                                                            {{ $website->login_otp == 1 ? 'Activated' : 'Deactivated' }}
                                                                        </span> / <span> 1 = Activated, 0 = Deactivated</span>
                                                                        <select class="default-select form-control" name="login_otp" id="validationCustom05">
                                                                                <option value="{{$website->login_otp}}">{{$website->login_otp}}</option>
                                                                                <option value="1">Activate</option>
                                                                                <option value="0">Deactivate</option>
                                                                        </select>
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <span class="avatar avatar-xl align-items-center justify-content-center p-2 me-2">
                                                                            @if(!empty($website->website_logo))
                                                                                <img src="{{ url('upload/', $website->website_logo) }}" height="30" width="60">
                                                                            @endif
                                                                        </span>
                                                                        <label class="form-label">Website Logo</label>
                                                                        <input type="file" name="website_logo" class="form-control" value="">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <span class="avatar avatar-xl align-items-center justify-content-center p-2 me-2">
                                                                            @if(!empty($website->website_favicon))
                                                                                <img src="{{ url('upload/', $website->website_favicon) }}" height="20" width="20">
                                                                            @endif
                                                                        </span>
                                                                        <label class="form-label">Website Favicon</label>
                                                                        <input type="file" name="website_favicon" class="form-control" value="">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <span class="avatar avatar-xl align-items-center justify-content-center p-2 me-2">
                                                                            @if(!empty($website->login_bg))
                                                                                <img src="{{ url('upload/', $website->login_bg) }}" height="20" width="20">
                                                                            @endif
                                                                        </span>
                                                                        <label class="form-label">Login Bg</label>
                                                                        <input type="file" name="login_bg" class="form-control" value="">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="card-footer">
                                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade {{ request()->get('tab') == 'profile' ? 'show active' : '' }}" id="profile">
                                            <div class="row">
                                                <div class="col-xl-12 col-lg-8">
                                                    <div class="card profile-card card-bx mb-4">
                                                        <div class="card-header">
                                                            <h6 class="title">Billing Codes</h6>
                                                        </div>
                                                        <form action="{{ url('/admin/transfer-codes/update') }}" method="post">
                                                            @csrf
                                                            @foreach($transferCodes as $transferCode)
                                                            <div class="card-body">
                                                                <div class="form-group">
                                                                    <div class="col-sm-12 m-b20">
                                                                        <label class="form-label" for="code_{{ $transferCode->id }}">{{ $transferCode->name }}</label>
                                                                        <span class="{{ $transferCode->is_enabled == 1 ? 'status-activated' : 'status-deactivated' }}">
                                                                            {{ $transferCode->is_enabled == 1 ? 'Activated' : 'Deactivated' }}
                                                                        </span>
                                                                        <input type="text" class="form-control" name="codes[{{ $transferCode->id }}]" value="{{ $transferCode->code }}" required>
                                                                    </div>
                                                                </div>
                                                                <div class="form-check form-switch">
                                                                    <input type="checkbox" class="form-check-input" role="switch" name="enabled[{{ $transferCode->id }}]" {{ $transferCode->is_enabled ? 'checked' : '' }}>
                                                                    <label class="form-check-label">Enable</label>
                                                                </div>
                                                            </div>
                                                            @endforeach
                                                            <div class="card-footer">
                                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade {{ request()->get('tab') == 'contact' ? 'show active' : '' }}" id="contact">
                                            <div class="row">
                                                <div class="col-xl-12 col-lg-8">
                                                    <div class="card profile-card card-bx mb-4">
                                                        <div class="card-header">
                                                            <h6 class="title">SMTP Settings</h6>
                                                        </div>
                                                        <form action="{{ url('admin/smtp_settings') }}" method="post">
                                                            @csrf
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Mail Mailer</label>
                                                                        <input type="text" name="mail_mailer" class="form-control" value="{{$settings->mail_mailer}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">App Name</label>
                                                                        <input type="text" name="mail_from_name" class="form-control" value="{{$settings->mail_from_name}}">
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Mail Host</label>
                                                                        <input type="text" name="mail_host" class="form-control" value="{{$settings->mail_host}}" />
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Mail Port: 465 or 587</label>
                                                                        <input type="number" name="mail_port" class="form-control" value="{{$settings->mail_port}}" />
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Encryption: {{$settings->mail_encryption}} active</label>
                                                                        <select class="form-control" name="mail_encryption">
                                                                            <option value="ssl">SSL</option>
                                                                            <option value="tls">TLS</option>
                                                                        </select>
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Mail Username</label>
                                                                        <input type="email" name="mail_username" class="form-control" value="{{$settings->mail_username}}" />
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Mail Password</label>
                                                                        <input type="password" name="mail_password" class="form-control" value="{{$settings->mail_password}}" />
                                                                    </div>
                                                                    <div class="col-sm-6 mb-4">
                                                                        <label class="form-label">Mail From Address</label>
                                                                        <input type="email" name="mail_from_address" class="form-control" value="{{$settings->mail_from_address}}" />
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="card-footer">
                                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="DefaultTab-html" role="tabpanel" aria-labelledby="home-tab">
                            <div class="card-body p-0 code-area">

                            </div>
                        </div>
                    </div>		
                </div>
            </div>
            <!-- /Column  -->
        </div>
        <!-- /row -->
    </div>


</x-adm>