@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
    @include('layouts.admin.head')
</head>

<style>
    .bg-image {
        background: url('{{ url('upload/'.$getSetting->login_bg) }}') no-repeat right center;
        background-size: contain; /* Adjust this to 'cover' or 'auto' based on needs */
        background-position: right center;
        background-attachment: fixed; /* Keeps the background fixed on scroll */
    }
</style>

<body class="account-page">

    <!-- Main Wrapper -->
    <div class="main-wrapper">

        <div class="account-content">
            <div class="d-flex flex-wrap w-100 vh-100 overflow-hidden bg-image">
                <div class="d-flex align-items-center justify-content-center flex-wrap vh-100 overflow-auto p-4 w-50 bg-backdrop">
                    <form action="{{ route('admin.login.submit') }}" method="POST" class="flex-fill">
                        @csrf
                        <div class="mx-auto mw-450">
                            <div class="text-center mb-4">
                                <img src="{{ url('upload/', $getSetting->website_logo )}}"  width="250px" height="150px" class="img-fluid" alt="Logo">
                            </div>
                            <div class="mb-4">
                                <h4 class="mb-2 fs-20">Sign In</h4>
                                <p>Access the Admin panel using your email and passcode.</p>
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label">Email Address</label>
                                <div class="position-relative">
                                    <span class="input-icon-addon">
                                        <i class="ti ti-mail"></i>
                                    </span>
                                    <input type="email" name="email" id="email" required value="" class="form-control">
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label">Password</label>
                                <div class="pass-group">
                                    <input type="password" name="password" id="password" required class="pass-input form-control">
                                    <span class="ti toggle-password ti-eye-off"></span>
                                </div>
                            </div>
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <div class="form-check form-check-md d-flex align-items-center">
                                    <input class="form-check-input" type="checkbox" value="" id="checkebox-md" checked="">
                                    <label class="form-check-label" for="checkebox-md">
                                        Remember Me
                                    </label>
                                </div>
                            </div>
                            <div class="mb-3">
                                <button type="submit" class="btn btn-primary w-100">Sign In</button>
                            </div>
                            <div class="text-center">
                                <p class="fw-medium text-gray">Copyright &copy; 2024 - {{$getSetting->website_name}}</p>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
    <!-- /Main Wrapper -->

    <!-- jQuery -->
@include('layouts.admin.script')

</html>