<x-adm>

    <div class="content container-fluid">
        <div class="row">
            <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="heading mb-0">Loan Management</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row g-3">

                                            <div class="table-responsive">
                                            <table class="table table-responsive-md">
                                                <thead>
                                                    <tr>
                                                        <th><strong>User</strong></th>
                                                        <th><strong>Amount</strong></th>
                                                        <th><strong>Type</strong></th>
                                                        <th><strong>Status</strong></th>
                                                        <th><strong>Action</strong></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse ($loans as $loans)
                                                    <tr>
                                                        <td><strong>{{$loans->user->firstname}} {{$loans->user->lastname}}</strong></td>
                                                        <td>{{$loans->loan_amount}} </td>
                                                        <td><span>{{$loans->loan_type}}</span></td>
                                                        <td>
                                                            <span class="badge 
                                                                @if($loans->status == 'Approved')
                                                                    bg-success
                                                                @elseif($loans->status == 'Rejected')
                                                                    bg-danger
                                                                @elseif($loans->status == 'Pending')
                                                                    bg-warning
                                                                @elseif($loans->status == 'Defaulted')
                                                                    bg-secondary
                                                                @else
                                                                    bg-primary
                                                                @endif
                                                                ">
                                                                {{$loans->status}}
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <div class="dropdown">
                                                                <form action="{{ route('admin.loans.update', $loans->id) }}" method="POST">
                                                                    @csrf
                                                                    <select name="status" class="form-select-sm">
                                                                        <option value="Approved">Approve</option>
                                                                        <option value="Rejected">Reject</option>
                                                                        <option value="Paid">Paid</option>
                                                                        <option value="Defaulted">Defaulted</option>
                                                                    </select>
                                                                    <button type="submit" class="btn btn-primary btn-sm">Update</button>
                                                                </form>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="100%"> No Record Found.</td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                        
        </div>
    
    </div>


</x-adm>