<x-adm>
    <style>
        .status-toggle {
            width: 40px;
            height: 20px;
            position: relative;
            appearance: none;
            background: #ccc;
            outline: none;
            border-radius: 20px;
            transition: .3s;
            cursor: pointer;
        }
    
        .status-toggle:checked {
            background: #4caf50;
        }
    
        .status-toggle::before {
            content: '';
            position: absolute;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            top: 1px;
            left: 1px;
            background: #fff;
            transition: .3s;
        }
    
        .status-toggle:checked::before {
            transform: translateX(20px);
        }
    </style>
    
    <!-- container starts -->
    <div class="content container-fluid">
        <div id="message"></div>  <!-- This is where the message will appear -->

                <!-- row -->
                <div class="row">
                    <div class="col-xl-12 col-lg-8">
                        <!-- Column starts -->
                            <div class="card dz-card" id="bootstrap-table2">
                                <div class="card-header flex-wrap d-flex justify-content-between border-0">
                                    <div>
                                        <h4 class="card-title">Country List</h4>
                                    </div>
                                    <div class="col-sm-3">
                                        <h6 class="card-title mb-2">Search Country</h6>
                                        <form method="GET" action="{{ url('admin/country') }}">
                                            <div class="input-group mb-3">
                                                <input type="text" name="search" class="form-control" placeholder="Search country..." value="{{ request('search') }}">
                                                <button class="btn btn-primary" type="submit">Search</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                
                                    <!-- tab-content -->
                                <div class="tab-content" id="myTabContent-1">
                                    <div class="tab-pane fade show active" id="bordered" role="tabpanel" aria-labelledby="home-tab-1">
                                        <div class="card-body">
                                            <div class="table-responsive">
                                                <table class="table table-responsive-md">
                                                    <thead>
                                                        <tr>
                                                            <th style="width:50px;">
                                                                <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                    <input type="checkbox" class="form-check-input" id="checkAll" required="">
                                                                    <label class="form-check-label" for="checkAll"></label>
                                                                </div>
                                                            </th>
                                                            <th><strong>Country</strong></th>
                                                            <th><strong>Region</strong></th>
                                                            <th><strong>Status</strong></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @forelse ($country as $count)
                                                        <tr>
                                                            <td>
                                                                <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                    <input type="checkbox" class="form-check-input" id="customCheckBox2" required="">
                                                                    <label class="form-check-label" for="customCheckBox2"></label>
                                                                </div>
                                                            </td>
                                                            <td><strong>{{$count->name}}</strong></td>
                                                            <td>{{$count->region}}</td>
                                                            <td>
                                                                <input type="checkbox" 
                                                                       class="status-toggle" 
                                                                       data-id="{{ $count->id }}" 
                                                                       {{ $count->status ? 'checked' : '' }}>
                                                            </td>
                                                        </tr>
                                                        @empty
                                                        <tr>
                                                            <td colspan="100%"> No Record Found.</td>
                                                        </tr>
                                                        @endforelse
                                                    </tbody>
                                                </table>
                                                <!-- Pagination Links -->
                                                <div class="pagination-style-1" style="padding: 10px; float:left;">
                                                    {{ $country->links()}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- /tab-content -->	
                            </div>
                    </div>
                    <!-- Column ends -->
                </div>

                <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
                <script>
                    $(document).on('change', '.status-toggle', function () {
                        let countryId = $(this).data('id');
                        let status = $(this).is(':checked') ? 1 : 0;
                
                        $.ajax({
                            url: "{{ route('admin.country.updateStatus') }}",
                            type: "POST",
                            data: {
                                _token: "{{ csrf_token() }}",
                                id: countryId,
                                status: status
                            },
                            success: function(response) {
                                // Display the success message dynamically on the page
                                $('#message').html('<div class="alert alert-success">' + response.message + '</div>');
                
                                // Optionally, hide the message after 5 seconds
                                setTimeout(function() {
                                    $('#message').fadeOut();
                                }, 5000);
                            },
                            error: function(xhr) {
                                console.log(xhr);
                                alert('Failed to update status');
                            }
                        });
                    });
                </script>
                
    </x-adm>