<x-adm>

    <!-- container starts -->
    <div class="content container-fluid">
        @if(session('message'))
            <div class="alert alert-success">
                {{ session('message') }}
            </div>
        @endif
                <!-- row -->
                <div class="row">
                    <div class="col-xl-12 col-lg-8">
                        <!-- Column starts -->
                            <div class="card dz-card" id="bootstrap-table2">
                                <div class="card-header flex-wrap d-flex justify-content-between border-0">
                                    <div>
                                        <h4 class="card-title">Chatbot Response List</h4>
                                    </div>
                                    <div class="col-sm-3 align-items-start">
                                        <h6 class="card-title mb-2">Search Chat Keyword</h6>
                                        <form method="GET" action="{{ url('admin/chatbot/index') }}">
                                            <div class="input-group mb-3">
                                                <input type="text" name="search" class="form-control m-1" placeholder="Search Keyword..." value="{{ request('search') }}">
                                                <button class="btn btn-primary m-1" type="submit">Search</button>
                                                <a href="{{ url('admin/chatbot/index') }}" class="btn btn-primary m-1" type="submit">Reset</a>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="d-flex my-xl-auto right-content align-items-center flex-wrap">
                                        <div class="mb-2">
                                            <button class="btn btn-primary d-flex align-items-center" type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModalScrollable2"><i class="ti ti-square-rounded-plus me-2"></i>Add Response</button>
                                        </div>
                                    </div>
                                </div>
                                
                                    <!-- tab-content -->
                                <div class="tab-content" id="myTabContent-1">
                                    <div class="tab-pane fade show active" id="bordered" role="tabpanel" aria-labelledby="home-tab-1">
                                        <div class="card-body">
                                            <div class="table-responsive">
                                                <table class="table table-responsive-md">
                                                    <thead>
                                                        <tr>
                                                            <th>Keyword</th>
                                                            <th>Response</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach($responses as $response)
                                                        <tr>
                                                            <td>{{$response->keyword}}</td>
                                                            <td>{{ \Illuminate\Support\Str::limit($response->response, 100) }}</td>
                                                            <td>
                                                                <div class="d-flex align-items-center">
                                                                    <a href="{{ url('admin/chatbot/edit/'. $response->id)}}" class="btn btn-outline-light bg-white btn-icon d-flex align-items-center justify-content-center rounded-circle p-0 me-2"><i class="ti ti-edit"></i></a>
                                                                    <form action="{{ url('admin/chatbot/delete/'. $response->id)}}" method="post">
                                                                        @csrf
                                                                        <button onclick="return confirm(' are you sure you want to delete?');" type="submit" class="btn btn-outline-light bg-white btn-icon d-flex align-items-center justify-content-center rounded-circle p-0 me-2"><i class="ti ti-trash"></i></button>
                                                                    </form>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                                <!-- Pagination Links -->
                                                <div class="pagination-style-1" style="padding: 10px; float:left;">
                                                    {{$responses->links()}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- /tab-content -->	
                            </div>
                    </div>
                    <!-- Column ends -->
                </div>  

                <div class="modal fade" id="exampleModalScrollable2" tabindex="-1" aria-labelledby="exampleModalScrollable2" data-bs-keyboard="false" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Add Response</h5>
                                </div>
                                <div class="card-body">
                                    <form action="{{ url('admin/chatbot/store')}}" method="post">
                                        @csrf
                                        <div class="mb-3">
                                            <label class="form-label">Keyword</label>
                                            <input type="text" name="keyword" class="form-control" />
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">response</label>
                                            <textarea type="text" name="response" rows="4" class="form-control"></textarea>
                                        </div>
                                        <div class="text-end">
                                            <button type="submit" class="btn btn-primary">Submit</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            
                        </div>
                    </div>
    </x-adm>