<x-adm>
    <style>
        .bank-status-toggle {
            width: 40px;
            height: 20px;
            position: relative;
            appearance: none;
            background: #ccc;
            outline: none;
            border-radius: 20px;
            transition: .3s;
            cursor: pointer;
        }
    
        .bank-status-toggle:checked {
            background: #4caf50;
        }
    
        .bank-status-toggle::before {
            content: '';
            position: absolute;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            top: 1px;
            left: 1px;
            background: #fff;
            transition: .3s;
        }
    
        .bank-status-toggle:checked::before {
            transform: translateX(20px);
        }
    </style>

        <div class="container-fluid">
            <div id="message"></div>  <!-- This is where the message will appear -->
            
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
                
            <!--element-area -->
            <div class="element-area">
                <div class="demo-view">
                    <div class="container-fluid pt-0 ps-0 pe-lg-4 pe-0">
                        <!-- row -->
                        <div class="row">
                            <!-- Column  -->
                            <div class="col-xl-12">
                                <div class="card dz-card">
                                    <div class="card-header flex-wrap border-0" id="default-tab">
                                        <h4 class="card-title">All Banks</h4>
                                    </div>
                                    <div class="tab-content" id="myTabContent">
                                        <div class="tab-pane fade show active" id="DefaultTab" role="tabpanel" aria-labelledby="home-tab">
                                            <div class="card-body pt-0">
                                                <!-- Nav tabs -->
                                                <div class="default-tab mt-2">
                                                    <ul class="nav nav-tabs" id="bankTabs" role="tablist">
                                                        <li class="nav-item" role="presentation">
                                                            <button class="nav-link {{ request('tab', 'us') === 'us' ? 'active' : '' }}" id="aus-tab" data-bs-toggle="tab" data-bs-target="#us" type="button" role="tab">USA Banks</button>
                                                        </li>
                                                        <li class="nav-item" role="presentation">
                                                            <button class="nav-link {{ request('tab') === 'uk' ? 'active' : '' }}" id="uk-tab" data-bs-toggle="tab" data-bs-target="#uk" type="button" role="tab">UK Banks</button>
                                                        </li>
                                                        <li class="nav-item" role="presentation">
                                                            <button class="nav-link {{ request('tab') === 'can' ? 'active' : '' }}" id="can-tab" data-bs-toggle="tab" data-bs-target="#can" type="button" role="tab">Canada Banks</button>
                                                        </li>
                                                        <li class="nav-item" role="presentation">
                                                            <button class="nav-link {{ request('tab') === 'aus' ? 'active' : '' }}" id="aus-tab" data-bs-toggle="tab" data-bs-target="#aus" type="button" role="tab">Australia Banks</button>
                                                        </li>
                                                    </ul>
                                                    <div class="tab-content" id="bankTabsContent">
                                                        <div class="tab-pane fade {{ request('tab', 'us') === 'us' ? 'show active' : '' }}" id="us" role="tabpanel">
                                                            <div class="card-body">
                                                                <div class="row mb-3 align-items-end">
                                                                    <div class="col-md-6">
                                                                        <h6 class="card-title mb-2">Search USA Bank</h6>
                                                                        <form method="GET" action="{{ url('admin/banks') }}">
                                                                            <input type="hidden" name="tab" value="us"> {{-- dynamically set the active tab name here --}}
                                                                            <div class="input-group">
                                                                                <input type="text" name="search" class="form-control" placeholder="Search country..." value="{{ request('search') }}">
                                                                                <button class="btn btn-primary" type="submit">Search</button>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                
                                                                    <div class="col-md-3 text-end ms-auto">
                                                                        <button type="button" class="btn btn-primary mb-2" data-bs-toggle="modal" data-bs-target="#exampleModalCenter1">
                                                                            Add USA Bank
                                                                        </button>
                                                                    </div>
                                                                </div>                                                                
                                                                <div class="table-responsive">
                                                                    <table class="table table-responsive-md">
                                                                        <thead>
                                                                            <tr>
                                                                                <th style="width:50px;">
                                                                                    <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                                        <input type="checkbox" class="form-check-input" id="checkAll" required="">
                                                                                        <label class="form-check-label" for="checkAll"></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th><strong>Bank Name</strong></th>
                                                                                <th><strong>Status</strong></th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            @forelse ($usBanks as $bank)
                                                                            <tr>
                                                                                <td>
                                                                                    <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                                        <input type="checkbox" class="form-check-input" id="customCheckBox2" required="">
                                                                                        <label class="form-check-label" for="customCheckBox2"></label>
                                                                                    </div>
                                                                                </td>
                                                                                <td><strong>{{$bank->name}}</strong></td>
                                                                                <td>
                                                                                    <input type="checkbox"
                                                                                           class="bank-status-toggle"
                                                                                           data-id="{{ $bank->id }}"
                                                                                           data-type="us" {{-- Change to uk / can / us depending on tab --}}
                                                                                           {{ $bank->status ? 'checked' : '' }}>
                                                                                </td>
                                                                                
                                                                            </tr>
                                                                            @empty
                                                                            <tr>
                                                                                <td colspan="100%"> No Record Found.</td>
                                                                            </tr>
                                                                            @endforelse
                                                                        </tbody>
                                                                    </table>
                                                                    <!-- Pagination Links -->
                                                                    <div class="pagination-style-1" style="padding: 10px; float:left;">
                                                                        {{ $usBanks->appends(request()->except('us'))->appends(['tab' => 'us'])->links() }}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tab-pane fade {{ request('tab') === 'uk' ? 'show active' : '' }}" id="uk" role="tabpanel">
                                                            <div class="card-body">
                                                                <div class="row mb-3 align-items-end">
                                                                    <div class="col-md-6">
                                                                        <h6 class="card-title mb-2">Search UK Bank</h6>
                                                                        <form method="GET" action="{{ url('admin/banks') }}">
                                                                            <input type="hidden" name="tab" value="uk"> {{-- dynamically set the active tab name here --}}
                                                                            <div class="input-group">
                                                                                <input type="text" name="search" class="form-control" placeholder="Search country..." value="{{ request('search') }}">
                                                                                <button class="btn btn-primary" type="submit">Search</button>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                
                                                                    <div class="col-md-3 text-end ms-auto">
                                                                        <button type="button" class="btn btn-primary mb-2" data-bs-toggle="modal" data-bs-target="#exampleModalCenter2">
                                                                            Add Uk Bank
                                                                        </button>
                                                                    </div>
                                                                </div>   
                                                                <div class="table-responsive">
                                                                    <table class="table table-responsive-md">
                                                                        <thead>
                                                                            <tr>
                                                                                <th style="width:50px;">
                                                                                    <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                                        <input type="checkbox" class="form-check-input" id="checkAll" required="">
                                                                                        <label class="form-check-label" for="checkAll"></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th><strong>Bank Name</strong></th>
                                                                                <th><strong>Status</strong></th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            @forelse ($ukBanks as $bank)
                                                                            <tr>
                                                                                <td>
                                                                                    <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                                        <input type="checkbox" class="form-check-input" id="customCheckBox2" required="">
                                                                                        <label class="form-check-label" for="customCheckBox2"></label>
                                                                                    </div>
                                                                                </td>
                                                                                <td><strong>{{$bank->name}}</strong></td>
                                                                                <td>
                                                                                    <input type="checkbox"
                                                                                           class="bank-status-toggle"
                                                                                           data-id="{{ $bank->id }}"
                                                                                           data-type="uk" {{-- Change to uk / can / us depending on tab --}}
                                                                                           {{ $bank->status ? 'checked' : '' }}>
                                                                                </td>
                                                                                
                                                                            </tr>
                                                                            @empty
                                                                            <tr>
                                                                                <td colspan="100%"> No Record Found.</td>
                                                                            </tr>
                                                                            @endforelse
                                                                        </tbody>
                                                                    </table>
                                                                    <!-- Pagination Links -->
                                                                    <div class="pagination-style-1" style="padding: 10px; float:left;">
                                                                        {{ $ukBanks->appends(request()->except('uk'))->appends(['tab' => 'uk'])->links() }}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tab-pane fade {{ request('tab') === 'can' ? 'show active' : '' }}" id="can" role="tabpanel">
                                                            <div class="card-body">
                                                                <div class="row mb-3 align-items-end">
                                                                    <div class="col-md-6">
                                                                        <h6 class="card-title mb-2">Search Canada Banks</h6>
                                                                        <form method="GET" action="{{ url('admin/banks') }}">
                                                                            <input type="hidden" name="tab" value="can"> {{-- dynamically set the active tab name here --}}
                                                                            <div class="input-group">
                                                                                <input type="text" name="search" class="form-control" placeholder="Search country..." value="{{ request('search') }}">
                                                                                <button class="btn btn-primary" type="submit">Search</button>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                
                                                                    <div class="col-md-3 text-end ms-auto">
                                                                        <button type="button" class="btn btn-primary mb-2" data-bs-toggle="modal" data-bs-target="#exampleModalCenter3">
                                                                            Add Canada Bank
                                                                        </button>
                                                                    </div>
                                                                </div>   
                                                                <div class="table-responsive">
                                                                    <table class="table table-responsive-md">
                                                                        <thead>
                                                                            <tr>
                                                                                <th style="width:50px;">
                                                                                    <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                                        <input type="checkbox" class="form-check-input" id="checkAll" required="">
                                                                                        <label class="form-check-label" for="checkAll"></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th><strong>Bank Name</strong></th>
                                                                                <th><strong>Status</strong></th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            @forelse ($canBanks as $bank)
                                                                            <tr>
                                                                                <td>
                                                                                    <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                                        <input type="checkbox" class="form-check-input" id="customCheckBox2" required="">
                                                                                        <label class="form-check-label" for="customCheckBox2"></label>
                                                                                    </div>
                                                                                </td>
                                                                                <td><strong>{{$bank->name}}</strong></td>
                                                                                <td>
                                                                                    <input type="checkbox"
                                                                                           class="bank-status-toggle"
                                                                                           data-id="{{ $bank->id }}"
                                                                                           data-type="can" {{-- Change to uk / can / us depending on tab --}}
                                                                                           {{ $bank->status ? 'checked' : '' }}>
                                                                                </td>
                                                                                
                                                                            </tr>
                                                                            @empty
                                                                            <tr>
                                                                                <td colspan="100%"> No Record Found.</td>
                                                                            </tr>
                                                                            @endforelse
                                                                        </tbody>
                                                                    </table>
                                                                    <!-- Pagination Links -->
                                                                    <div class="pagination-style-1" style="padding: 10px; float:left;">
                                                                        {{ $canBanks->appends(request()->except('can'))->appends(['tab' => 'can'])->links() }}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tab-pane fade {{ request('tab') === 'aus' ? 'show active' : '' }}" id="aus" role="tabpanel">
                                                            <div class="card-body">
                                                                <div class="row mb-3 align-items-end">
                                                                    <div class="col-md-6">
                                                                        <h6 class="card-title mb-2">Search Australian Banks</h6>
                                                                        <form method="GET" action="{{ url('admin/banks') }}">
                                                                            <input type="hidden" name="tab" value="aus"> {{-- dynamically set the active tab name here --}}
                                                                            <div class="input-group">
                                                                                <input type="text" name="search" class="form-control" placeholder="Search country..." value="{{ request('search') }}">
                                                                                <button class="btn btn-primary" type="submit">Search</button>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                
                                                                    <div class="col-md-3 text-end ms-auto">
                                                                        <button type="button" class="btn btn-primary mb-2" data-bs-toggle="modal" data-bs-target="#exampleModalCenter4">
                                                                            Add Aus Bank
                                                                        </button>
                                                                    </div>
                                                                </div>   
                                                                <div class="table-responsive">
                                                                    <table class="table table-responsive-md">
                                                                        <thead>
                                                                            <tr>
                                                                                <th style="width:50px;">
                                                                                    <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                                        <input type="checkbox" class="form-check-input" id="checkAll" required="">
                                                                                        <label class="form-check-label" for="checkAll"></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th><strong>Bank Name</strong></th>
                                                                                <th><strong>Status</strong></th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            @forelse ($ausBanks as $bank)
                                                                            <tr>
                                                                                <td>
                                                                                    <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                                                        <input type="checkbox" class="form-check-input" id="customCheckBox2" required="">
                                                                                        <label class="form-check-label" for="customCheckBox2"></label>
                                                                                    </div>
                                                                                </td>
                                                                                <td><strong>{{$bank->name}}</strong></td>
                                                                                <td>
                                                                                    <input type="checkbox"
                                                                                           class="bank-status-toggle"
                                                                                           data-id="{{ $bank->id }}"
                                                                                           data-type="aus" {{-- Change to uk / can / us depending on tab --}}
                                                                                           {{ $bank->status ? 'checked' : '' }}>
                                                                                </td>                                                                                
                                                                            </tr>
                                                                            @empty
                                                                            <tr>
                                                                                <td colspan="100%"> No Record Found.</td>
                                                                            </tr>
                                                                            @endforelse
                                                                        </tbody>
                                                                    </table>
                                                                    <!-- Pagination Links -->
                                                                    <div class="pagination-style-1" style="padding: 10px; float:left;">
                                                                        {{ $ausBanks->appends(request()->except('aus'))->appends(['tab' => 'aus'])->links() }}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>		
                                </div>
                            </div>
                            <!-- /Column  -->
                        </div>
                        <!-- /row -->
                    </div>
                </div>		
            </div>
            <!--/element-area-->	
        </div>

        <div class="modal fade" id="exampleModalCenter1">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Add USA Bank</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal">
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="card-body">
                            <div class="basic-form">
                                <form action="{{ route('admin.bank.adminaddusa')}}" method="post">
                                    @csrf
                                    <div class="row">
                                        <div class="mb-3 col-md-12">
                                            <label class="form-label">Full Bank Name</label>
                                            <input type="text" name="name" class="form-control" placeholder="Full Bank Name">
                                        </div>
                                        <div class="mb-3 mt-3 col-md-12">
                                            <label class="form-check-label mb-3" for="statusSwitch">Active Status</label>
                                            <div class="form-check form-switch mb-3">
                                                <input class="bank-status-toggle" type="checkbox" id="statusSwitch" name="status" value="1">
                                            </div>                                         
                                        </div>                                         
                                    </div>
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--UK MODAL -->
        <div class="modal fade" id="exampleModalCenter2">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Add UK Bank</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal">
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="card-body">
                            <div class="basic-form">
                                <form action="{{ route('admin.bank.adminadduk')}}" method="post">
                                    @csrf
                                    <div class="row">
                                        <div class="mb-3 col-md-12">
                                            <label class="form-label">Full Bank Name</label>
                                            <input type="text" name="name" class="form-control" placeholder="Full Bank Name">
                                        </div>
                                        <div class="mb-3 mt-3 col-md-12">
                                            <label class="form-check-label mb-3" for="statusSwitch">Active Status</label>
                                            <div class="form-check form-switch mb-3">
                                                <input class="bank-status-toggle" type="checkbox" id="statusSwitch" name="status" value="1">
                                            </div>                                         
                                        </div>                                         
                                    </div>
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--Canada MODAL -->
        <div class="modal fade" id="exampleModalCenter3">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Add Canada Bank</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal">
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="card-body">
                            <div class="basic-form">
                                <form action="{{ route('admin.bank.adminaddcan')}}" method="post">
                                    @csrf
                                    <div class="row">
                                        <div class="mb-3 col-md-12">
                                            <label class="form-label">Full Bank Name</label>
                                            <input type="text" name="name" class="form-control" placeholder="Full Bank Name">
                                        </div>
                                        <div class="mb-3 mt-3 col-md-12">
                                            <label class="form-check-label mb-3" for="statusSwitch">Active Status</label>
                                            <div class="form-check form-switch mb-3">
                                                <input class="bank-status-toggle" type="checkbox" id="statusSwitch" name="status" value="1">
                                            </div>                                         
                                        </div>                                         
                                    </div>
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--Australia MODAL -->
        <div class="modal fade" id="exampleModalCenter4">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Add Australia Bank</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal">
                        </button>
                    </div>
                    <div class="modal-body">
                            <div class="card-body">
                                <div class="basic-form">
                                    <form action="{{ route('admin.bank.adminaddaus')}}" method="post">
                                        @csrf
                                        <div class="row">
                                            <div class="mb-3 col-md-12">
                                                <label class="form-label">Full Bank Name</label>
                                                <input type="text" name="name" class="form-control" placeholder="Full Bank Name">
                                            </div>
                                            <div class="mb-3 mt-3 col-md-12">
                                                <label class="form-check-label mb-3" for="statusSwitch">Active Status</label>
                                                <div class="form-check form-switch mb-3">
                                                    <input class="bank-status-toggle" type="checkbox" id="statusSwitch" name="status" value="1">
                                                </div>                                         
                                            </div>                                         
                                        </div>
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </form>
                                </div>
                            </div>
                    </div>
                </div>
            </div>
        </div>

        <script>
            document.querySelectorAll('[data-bs-toggle="tab"]').forEach(tab => {
                tab.addEventListener('shown.bs.tab', function (event) {
                    const tabId = event.target.getAttribute('data-bs-target').replace('#', '');
                    document.querySelectorAll('form').forEach(form => {
                        let input = form.querySelector('input[name="tab"]');
                        if (input) input.value = tabId;
                    });
                });
            });
        </script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).on('change', '.bank-status-toggle', function () {
        let bankId = $(this).data('id');
        let bankType = $(this).data('type'); // 'aus', 'uk', 'can', 'us'
        let status = $(this).is(':checked') ? 1 : 0;

        $.ajax({
            url: "{{ route('admin.bank.updateStatus') }}",
            type: "POST",
            data: {
                _token: "{{ csrf_token() }}",
                id: bankId,
                bank_type: bankType,
                status: status
            },
            success: function(response) {
                $('#message').html('<div class="alert alert-success">' + response.message + '</div>');

                setTimeout(function() {
                    $('#message').fadeOut();
                }, 5000);
            },
        });
    });
</script>

</x-adm>