<x-user :notifications="$notifications">
    <style>
        table {
            border-radius: 10px;
            overflow: hidden;
            border: 1px solid #ddd;
            /* Adding border for a cleaner look */
        }

        th,
        td {
            border-top: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
        }

        th {
            background-color: #f8f9fa;
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        }

        td {
            text-align: center;
        }

        /* Optional: Make the last row corners rounded for visual appeal */
        tr:last-child td:first-child {
            border-bottom-left-radius: 10px;
        }

        tr:last-child td:last-child {
            border-bottom-right-radius: 10px;
        }
    </style>
    <!-- start: page header area -->
    <div class="px-xl-5 px-lg-4 px-3 py-2 page-header flex-wrap">
        <ol class="breadcrumb mb-0 bg-transparent mb-3 mb-sm-0">
            <li class="breadcrumb-item active"><a class="text-muted" href="{{ url('account/dashboard') }}"
                    title="home">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page" title="Balance">Wire Transactions</li>
        </ol>
    </div>
    <!-- start: page body area -->
    <div class="px-xl-5 px-lg-4 px-3 py-3 page-body">
        <div class="row">
            <div class="col-12">
                <div class="border p-4 rounded-2 rounded-4">
                    <table id="transactionTable" class="display table table-bordered" style="width:100%">
                        <thead>
                            <tr class="text-center">
                                <th>#</th>
                                <th>Account Name</th>
                                <th>Amount</th>
                                <th>Description</th>
                                <th>Transaction Type</th>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Receipt</th> <!-- Add Action Column -->
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($transfer as $transactions)
                                <tr class="item_trans" data-id="{{ $transactions->id }}"
                                    data-reference="{{ $transactions->reference }}"
                                    data-bank-name="{{ $transactions->bank_name }}"
                                    data-account-name="{{ $transactions->account_name }}"
                                    data-amount="{{ $transactions->amount }}"
                                    data-description="{{ $transactions->description }}" data-toggle="modal"
                                    data-target="#mdllDetailsTrans">
                                    <td></td>
                                    <td>{{ $transactions->account_name }}</td>
                                    <td>{{ Auth::user()->acct_currency }}{{ number_format($transactions->amount, 2) }}
                                    </td>
                                    <td>{{ $transactions->description }}</td>
                                    <td>{{ $transactions->transaction_type }}</td>
                                    <td>{{ \Carbon\Carbon::parse($transactions->created_at)->format('d F Y') }}</td>
                                    <td>
                                        <span>
                                            @if ($transactions->status === 'Pending')
                                                <span class="badge bg-primary">Pending</span>
                                                <!-- Bootstrap primary color -->
                                            @elseif($transactions->status === 'Processing')
                                                <span class="badge bg-info">Processing</span>
                                            @elseif($transactions->status === 'Completed')
                                                <span class="badge bg-success">Completed</span>
                                            @elseif($transactions->status === 'Failed')
                                                <span class="badge bg-danger">Failed</span>
                                            @endif
                                        </span>
                                    </td>
                                    <td>
                                        <a href="{{ url('account/transfer_success', ['id' => $transactions->reference]) }}"
                                            class="btn btn-secondary btn-sm"><i class="bi bi-receipt"></i></a>
                                        <!-- Action Button -->
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="100%"> No Record Found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-user>
