@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wire Transfer Confirmation and Receipt</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f8f8;
        }
        .receipt-container {
            width: 650px;
            height: auto;
            min-height: 900px;
            margin: auto;
            background: #fff;
            padding: 20px;
            border: 1px solid #000;
            box-shadow: 3px 3px 10px rgba(0, 0, 0, 0.2);
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 2px solid #000;
            padding-bottom: 15px;
            margin-bottom: 30px;
        }
        .header img {
            width: 200px;
        }
        .status {
            font-size: 16px;
            font-weight: bold;
            text-align:right;
        }
        .highlight-box {
            border: 2px solid #5cb85c;
            background: #e9ffe9;
            padding: 12px;
            font-size: 14px;
            margin: 20px 0;
        }
        .wire-details {
            font-size: 13px;
            margin-top: 30px;
        }
        .wire-details table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .wire-details th {
            text-align: left;
            width: 40%;
            padding: 12px;
            background: #f1f1f1;
        }
        .wire-details td {
            padding: 12px;
            text-align: left;
        }
        .note {
            font-size: 12px;
            color: red;
            font-weight: bold;
            margin-top: 5px;
        }
        .footer {
            margin-top: 40px;
            font-size: 12px;
            text-align: center;
            color: #555;
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <div class="header">
            <img src="{{ public_path('upload/'. $getSetting->website_logo) }}" alt="Bank of America">
            <div class="status">Transaction Status: <span class="@if($transfer->status == 'Pending') text-yellow-500
                @elseif($transfer->status == 'Processing') text-blue-500
                @elseif($transfer->status == 'Completed') text-green-500
                @elseif($transfer->status == 'Failed') text-red-500
                @endif">
      {{ $transfer->status }}
  </span>
  </div>
        </div>

        <h2 style="text-align: center;">Wire Transfer Confirmation and Receipt</h2>

        <div class="highlight-box">
            <strong>You have successfully submitted your transaction on {{$transfer->created_at}} USA Time.</strong>
        </div>

        <p>You can <a href="#">cancel your wire transfer</a> within 30 minutes of confirming the transaction, 
           <a href="#">view your pending wire transfers</a>, or <a href="#">send another wire transfer</a>.
        </p>

        <div class="wire-details">
            <h3>Wire Details</h3>
            <table>
                <tr>
                    <th>Account Name:</th>
                    <td>{{$transfer->beneficiary_name}}</td>
                </tr>
                <tr>
                    <th>Account Number:</th>
                    <td>{{$transfer->beneficiary_account_number}}</td>
                </tr>
                <tr>
                    <th>Confirmation Number:</th>
                    <td>{{$transfer->transaction_reference}}</td>
                </tr>
                <tr>
                    <th>Send to:</th>
                    <td>{{$transfer->beneficiary_bank_name}}</td>
                </tr>
                <tr>
                    <th>From Account (Debit):</th>
                    <td>{{Auth::user()->account_type}} {{Auth::user()->account_no}}</td>
                </tr>
                <tr>
                    <th>Available Balance:</th>
                    <td>{{Auth::user()->acct_currency}}{{ number_format(Auth::user()->account_balance, 2)}}</td>
                </tr>
                <tr>
                    <th>Amount:</th>
                    <td>{{$transfer->currency}}{{ number_format($transfer->amount, 2)}}</td>
                </tr>
                <tr>
                    <th>Frequency:</th>
                    <td>One-time – send now</td>
                </tr>
                <tr>
                    <th>Wire Currency:</th>
                    <td>US Dollar (USD) Note: The Transfer is being sent in USD <p class="note">
            <strong>NOTE:</strong> In order for this international transfer to be completed, a charge fee of 
            3% of the transferred amount ({{$transfer->currency}}{{$transfer->amount}}) would be paid.
        </p></td>
                </tr>
                <tr>
                    <th>Send on:</th>
                    <td>{{$transfer->created_at}}</td>
                </tr>
                <tr>
                    <th>Deliver by:</th>
                    <td>{{$transfer->completed_at}}</td>
                </tr>
                <tr>
                    <th>Description:</th>
                    <td>ACCOUNT NAME: {{Auth::user()->firstname}} {{Auth::user()->lastname}} <br> ACCOUNT NUMBER: {{Auth::user()->account_no}}</td>
                </tr>
            </table>
        </div>

        <div class="footer">
            &copy; 2025 {{$getSetting->website_name}}. All rights reserved.
        </div>
    </div>
</body>
</html>
