@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<x-user :notifications="$notifications" >

    <div id="wrapper">
        <div id="content">
            <header class="main_haeder header-sticky multi_item">
                <div class="em_side_right">
                    <a class="rounded-circle d-flex align-items-center text-decoration-none" href="{{ url('account/cards')}}">
                        <i class="tio-chevron_left size-24 color-text"></i>
                        <span class="color-text size-14">Back</span>
                    </a>
                </div>
                <div class="title_page">
                    <span class="page_name">
                        KYC Verification
                    </span>
                </div>
            </header>

            <section class="emSection__payment pageCredit__Card">

                <div class="emTitle_co padding-20 text-center">
                    <h2 class="size-16 weight-500 color-secondary mb-1">Kyc Status</h2>
                    <p class="text-secondary small mb-3">{{Auth::user()->kyc_status}}</p>
                </div>

                <form action="{{ url('account/verification') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                <div class="card-body">

                    <div class="input_group">
                        <div class="form-group input-lined">
                            <input class="form-control" name="firstname" type="text" value="{{Auth::user()->firstname}}" readonly />
                            <label class="form-label">First Name</label> 
                        </div>
                    </div>

                    <div class="input_group">
                        <div class="form-group input-lined">
                            <input class="form-control" name="lastname" type="text" value="{{Auth::user()->lastname}}" readonly />
                            <label class="form-label">Last name</label> 
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Document Type</label> 
                        <select name="identity_document_type" id="identity_document_type" class="form-control custom-select" required>
                            <option value="">Select Document Type</option>
                            <option value="Passport">Passport</option>
                            <option value="Drivers License">Drivers License</option>
                            <option value="National ID Card">National ID Card</option>
                            <option value="Voter ID Card">Voter ID Card</option>
                            <option value="PAN Card">PAN Card</option>
                            <option value="Employee ID Card">Employee ID Card</option>
                        </select>
                    </div>

                    <div class="input_group">
                        <div class="form-group input-lined">
                            <input class="form-control" name="identity_document_number" type="text" value="" />
                            <label class="form-label">Id Card Number</label> 
                        </div>
                    </div>

                    <div class="form-group margin-b-30">
                        <div class="embox__avatar">
                            <div class="emitem_avt">
                                <img class="img__avatar min-w-80 h-60 rounded-8" src="/user/assets/img/persons/card.png" alt="">
                            </div>
                            <div class="txt__upload">
                                <div class="btnUpload__item">
                                    <input type="file" id="file" name="frontphoto" accept="image/*">
                                    <button type="button" class="btn btn_uploadImage">Upload front Id Card</button>
                                </div>
                                <p>Recommended Size: 150 X 150 Px</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group margin-b-30">
                        <div class="embox__avatar">
                            <div class="emitem_avt">
                                <img class="img__avatar min-w-80 h-60 rounded-8" src="/user/assets/img/persons/card.png" alt="">
                            </div>
                            <div class="txt__upload">
                                <div class="btnUpload__item">
                                    <input type="file" id="file" name="backphoto" accept="image/*">
                                    <button type="button" class="btn btn_uploadImage">Upload back Id Card</button>
                                </div>
                                <p>Recommended Size: 150 X 150 Px</p>
                            </div>
                        </div>
                    </div>

                    <div class="input_group margin-t-30">
                        <div class="form-group input-lined">
                            <input class="form-control" name="employment_status" type="text" value="" />
                            <label class="form-label">Employment Status</label> 
                        </div>
                    </div>

                    <div class="margin-t-40">
                        <button type="submit" class="btn btn-primary w-100">Apply</button>
                    </div>
                </div>
            </form>
        </section>
        </div>
    </div>

</x-user>