@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaction Receipt</title>

    <style>
        body {
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f5f5;
            color: #333;
            position: relative;
        }

        .receipt-container {
            max-width: 700px;
            margin: 40px auto;
            background: #fff;
            border: 1px solid #e5e5e5;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            position: relative;
            overflow: hidden;
        }

        .watermark {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('{{ public_path('upload/' . $getSetting->website_logo) }}') no-repeat center;
            opacity: 0.09;
            transform: rotate(45deg);
            background-size: 200px;
            pointer-events: none;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header img {
            max-width: 80px;
        }

        .header h1 {
            font-size: 20px;
            margin: 10px 0 0;
            font-weight: 600;
            color: #555;
        }

        .transaction-amount {
            text-align: center;
            font-size: 28px;
            font-weight: bold;
            color: #000;
            margin: 20px 0;
        }

        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        .details-table th,
        .details-table td {
            padding: 10px 15px;
            font-size: 14px;
            vertical-align: top;
            border-bottom: 1px solid #eee;
        }

        .details-table th {
            font-weight: bold;
            color: #666;
            width: 35%;
            text-align: left;
        }

        .details-table td {
            color: #333;
            text-align: right;
        }

        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #999;
        }

        .footer p {
            margin: 5px 0;
        }

        .stamp {
            text-align: center;
            margin-top: 20px;
            font-size: 14px;
            color: #333;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div class="receipt-container">
        <div class="watermark"></div>
        <div class="header">
            @if ($logoBase64)
                <img src="{{ $logoBase64 }}" alt="Logo" height="60">
            @else
                <p><strong>Logo not available</strong></p>
            @endif
            <h1>Transaction Details</h1>
        </div>
        <div class="transaction-amount"
            style="font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif">
            {{ Auth::user()->acct_currency }}{{ number_format($transfer->amount, 2) }}
        </div>
        <table class="details-table">
            <tr>
                <th>Beneficiary Details</th>
                <td>{{ $transfer->account_name }} | {{ $transfer->account_number }}</td>
            </tr>
            <tr>
                <th>Beneficiary Bank</th>
                <td>{{ $transfer->bank_name }}</td>
            </tr>
            <tr>
                <th>Sender Details</th>
                <td>{{ Auth::user()->firstname }} {{ Auth::user()->lasttname }} | {{ Auth::user()->account_no }}</td>
            </tr>
            <tr>
                <th>Paid On</th>
                <td>{{ $transfer->formatted_date }}</td>
            </tr>
            <tr>
                <th>Fee</th>
                <td>{{ Auth::user()->acct_currency }}{{ $transfer->fee }}</td>
            </tr>
            <tr>
                <th>Description</th>
                <td>{{ $transfer->description }}</td>
            </tr>
            <tr>
                <th>Transaction Reference</th>
                <td>{{ $transfer->reference }}</td>
            </tr>
            <tr>
                <th>Payment Status</th>
                <td>{{ $transfer->status }}</td>
            </tr>
            <tr>
                <th>Payment Type</th>
                <td>{{ $transfer->transaction_type }}</td>
            </tr>
        </table>
        <div class="stamp">
            {{ $getSetting->website_name }}
        </div>
        <div class="footer">
            <p>© 2025 {{ $getSetting->website_name }} (FDIC). All rights reserved. (RC754875). All rights reserved.</p>
            <p>All deposits are insured by the Federal Deposit Insurance Corporation (FDIC).</p>
        </div>
    </div>

</body>

</html>
