<x-user :notifications="$notifications">

    <!-- start: page body area -->
    <div class="px-xl-5 px-lg-4 px-3 py-3 page-body">
        <div class="row">
            <div class="col-sm-12">
                <div class="card ">
                    <div class="card-header bg-card pb-3">
                        <div class="d-flex align-items-center gap-3">
                            <h6 class="card-title mb-0">My Profile</h6>
                            <div class="dropdown">
                                <a href="#" class="dropdown-toggle after-none text-muted small"
                                    data-bs-toggle="dropdown" aria-expanded="false" title="More Action">
                                    Manage
                                </a>
                                <div class="dropdown-menu shadow rounded-4 p-2">
                                    <a href="{{ url('account/profile') }}" class="dropdown-item rounded-pill">
                                        <i class="me-2 fa fa-user"></i>Profile
                                    </a>
                                    <a href="{{ url('account/pin') }}" class="dropdown-item rounded-pill">
                                        <i class="me-2 fa fa-key"></i>Pin Management
                                    </a>
                                    <a href="{{ url('account/security') }}" class="dropdown-item rounded-pill">
                                        <i class="me-2 fa fa-lock"></i>Password Management
                                    </a>
                                    <a href="{{ url('account/activity') }}" class="dropdown-item rounded-pill">
                                        <i class="me-2 fa fa-file"></i>Activity Log
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Profile Info -->
                        <div class="d-flex align-items-md-start align-items-center flex-column flex-md-row mt-4 w-100">
                            @if (Auth::user()->photo)
                                <img src="{{ url('upload/', Auth::user()->photo) }}" alt="" class="rounded-4"
                                    style="width: 80px; height: 80px; object-fit: cover;">
                            @endif
                            <div class="media-body ms-md-4 mt-3 mt-md-0 text-md-start text-center">
                                <h4 class="mb-1">{{ Auth::user()->firstname }} {{ Auth::user()->lastname }}</h4>
                                <p class="mb-0">{{ Auth::user()->email }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="card-body border-top">
                        <div class="row g-4">
                            <div class="col-xl-6 col-lg-5">
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0 fw-bold">Account Details</h6>
                                    </div>
                                    <div class="card-body row bg-light g-0">
                                        <div class="table-responsive custom_scroll">
                                            <!-- Table -->
                                            <table class="table table-hover">
                                                <tbody>
                                                    <tr>
                                                        <th>Full Name</th>
                                                        <td colspan="2">{{ Auth::user()->firstname }}
                                                            {{ Auth::user()->lastname }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Email Address</th>
                                                        <td colspan="2">{{ Auth::user()->email }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Phone Number</th>
                                                        <td colspan="2">{{ Auth::user()->phone }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Account Number</th>
                                                        <td colspan="2">{{ Auth::user()->account_no }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Account Level</th>
                                                        <td colspan="2">{{ Auth::user()->acct_level }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Account Status</th>
                                                        <td colspan="2">
                                                            <span
                                                                class="fw-bold 
																	@if (Auth::user()->acct_status === 'Active') text-success 
																	@else text-danger @endif">
                                                                {{ Auth::user()->acct_status }}
                                                            </span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-7">
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0 fw-bold">Next Of Kin</h6>
                                    </div>
                                    <div class="card-body row bg-light g-0">
                                        <div class="table-responsive custom_scroll">
                                            <!-- Table -->
                                            @if ($nextOfKin)
                                                <table class="table table-hover">
                                                    <tbody>
                                                        <tr>
                                                            <th>Full Name</th>
                                                            <td colspan="2">{{ $nextOfKin->first_name }} {{ $nextOfKin->last_name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>Relationship</th>
                                                            <td colspan="2">{{ $nextOfKin->relationship }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>Phone</th>
                                                            <td colspan="2">{{ $nextOfKin->phone }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>Email</th>
                                                            <td colspan="2">{{ $nextOfKin->email ?? 'N/A' }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>Address</th>
                                                            <td colspan="2">{{ $nextOfKin->address ?? 'N/A' }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>Date Of Birth</th>
                                                            <td colspan="2">{{ $nextOfKin->dob ?? 'N/A' }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>SNN</th>
                                                            <td colspan="2">{{ $nextOfKin->ssn ?? 'N/A' }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>Occupation</th>
                                                            <td colspan="2">{{ $nextOfKin->occupation ?? 'N/A' }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>Emergency Contact</th>
                                                            <td colspan="2">{{ $nextOfKin->emergency_contact ?? 'N/A' }}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            @else
                                                <div class="alert alert-info">
                                                    You have not added a Next of Kin yet.
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> <!--[ .row end ]-->
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-user>
