@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<x-user>

    <div id="wrapper">
        <div id="content">
            <!-- Start main_haeder -->
            <header class="main_haeder header-sticky multi_item">
                <div class="em_side_right">
                    <a class="rounded-circle d-flex align-items-center text-decoration-none" href="{{ url('account/dashboard')}}">
                        <i class="tio-chevron_left size-24 color-text"></i>
                        <span class="color-text size-14">Back</span>
                    </a>
                </div>
                <div class="em_side_right">
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                    <a href="{{ route('logout') }}" onclick="event.preventDefault(); this.closest('form').submit();"
                        class="link__forgot d-block size-14 color-primary text-decoration-none hover:color-secondary transition-all">
                        Sign out
                    </a>
                </form>
                </div>
            </header>
            <!-- End.main_haeder -->

            <section class="box__dashboard">
                <div class="item-link hoverNone">
                    <div class="">
                        <div class="text-center">
                            <img class="imgList w-60 h-60 rounded-8"
                                src="{{ url('upload/', Auth::user()->photo) }}" alt="">
                                <p><h6>{{Auth::user()->firstname}} {{Auth::user()->lastname}}</h6></p>
                                <p>{{Auth::user()->account_no}}</p>
                        </div>
                    </div>
                </div>
            </section>
    
    <!-- End. box__dashboard -->

    <section>
        <div class="em__pkLink emBlock__border bg-white border-t-0">
            <ul class="nav__list mb-0">
                <li>
                    <a href="{{url('account/profile_details')}}" class="item-link">
                        <div class="group">
                            <div class="icon bg-primary">
                                <svg id="Iconly_Curved_Profile" data-name="Iconly/Curved/Profile"
                                    xmlns="http://www.w3.org/2000/svg" width="19" height="19"
                                    viewBox="0 0 19 19">
                                    <g id="Profile" transform="translate(3.958 1.9)">
                                        <path id="Stroke_1" data-name="Stroke 1"
                                            d="M5.419,5.779C2.5,5.779,0,5.324,0,3.5S2.48,0,5.419,0c2.923,0,5.419,1.665,5.419,3.487S8.357,5.779,5.419,5.779Z"
                                            transform="translate(0 9.47)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                        <path id="Stroke_3" data-name="Stroke 3"
                                            d="M3.473,6.946a3.461,3.461,0,1,0-.024,0Z"
                                            transform="translate(1.94)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                    </g>
                                </svg>
                            </div>
                            <span class="path__name">Personal Details</span>
                        </div>
                        <div class="group">
                            <span class="short__name"></span>
                            <i class="tio-chevron_right -arrwo"></i>
                        </div>
                    </a>
                </li>
                <li>
                    <a href="{{url('account/security')}}" class="item-link">
                        <div class="group">
                            <div class="icon bg-turquoise">
                                <svg id="Iconly_Curved_Lock" data-name="Iconly/Curved/Lock"
                                    xmlns="http://www.w3.org/2000/svg" width="19" height="19"
                                    viewBox="0 0 19 19">
                                    <g id="Lock" transform="translate(3.365 2.177)">
                                        <path id="Stroke_1" data-name="Stroke 1"
                                            d="M7.221,5.267v-1.7A3.611,3.611,0,0,0,0,3.55V5.267"
                                            transform="translate(2.454 0)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                        <path id="Stroke_3" data-name="Stroke 3" d="M.5,0V1.758"
                                            transform="translate(5.564 9.03)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                        <path id="Stroke_5" data-name="Stroke 5"
                                            d="M6.064,0C1.516,0,0,1.241,0,4.965S1.516,9.93,6.064,9.93s6.065-1.241,6.065-4.965S10.612,0,6.064,0Z"
                                            transform="translate(0 4.809)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                    </g>
                                </svg>
                            </div>
                            <span class="path__name">Security & Password</span>
                        </div>
                        <div class="group">
                            <span class="short__name"></span>
                            <i class="tio-chevron_right -arrwo"></i>
                        </div>
                    </a>
                </li>
                <li>
                    <a href="{{url('account/pin')}}" class="item-link">
                        <div class="group">
                            <div class="icon bg-blue">
                                <svg id="Iconly_Curved_Paper_Plus" data-name="Iconly/Curved/Paper Plus"
                                    xmlns="http://www.w3.org/2000/svg" width="19" height="19"
                                    viewBox="0 0 19 19">
                                    <g id="Paper_Plus" data-name="Paper Plus" transform="translate(2.89 2.177)">
                                        <path id="Stroke_1" data-name="Stroke 1"
                                            d="M13.07,4.394,8.582.119A14.408,14.408,0,0,0,6.642,0C1.663,0,0,1.837,0,7.323s1.663,7.323,6.642,7.323,6.65-1.829,6.65-7.323A16.661,16.661,0,0,0,13.07,4.394Z"
                                            transform="translate(0)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                        <path id="Stroke_3" data-name="Stroke 3"
                                            d="M0,0V2.107A2.662,2.662,0,0,0,2.663,4.769H5"
                                            transform="translate(8.141 0.065)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                        <path id="Stroke_5" data-name="Stroke 5" d="M3.879.5H0"
                                            transform="translate(4.562 7.599)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                        <path id="Stroke_7" data-name="Stroke 7" d="M.5,3.879V0"
                                            transform="translate(6.002 6.16)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                    </g>
                                </svg>
                            </div>
                            <span class="path__name">Login Pin</span>
                        </div>
                        <div class="group">
                            <span class="short__name"></span>
                            <i class="tio-chevron_right -arrwo"></i>
                        </div>
                    </a>
                </li>
                <li>
                    <a href="{{url('account/verification')}}" class="item-link">
                        <div class="group">
                            <div class="icon bg-blue">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="12" height="12" fill="currentColor"><path d="M19 10H20C20.5523 10 21 10.4477 21 11V21C21 21.5523 20.5523 22 20 22H4C3.44772 22 3 21.5523 3 21V11C3 10.4477 3.44772 10 4 10H5V9C5 5.13401 8.13401 2 12 2C15.866 2 19 5.13401 19 9V10ZM5 12V20H19V12H5ZM11 14H13V18H11V14ZM17 10V9C17 6.23858 14.7614 4 12 4C9.23858 4 7 6.23858 7 9V10H17Z"></path></svg>
                            </div>
                            <span class="path__name">Verification</span>
                        </div>
                        <div class="group">
                            <span class="short__name"></span>
                            <i class="tio-chevron_right -arrwo"></i>
                        </div>
                    </a>
                </li>
                <li>
                    <a href="{{ url('account/transactions')}}" class="item-link">
                        <div class="group">
                            <div class="icon bg-purple">
                                <svg id="Iconly_Curved_Paper" data-name="Iconly/Curved/Paper"
                                    xmlns="http://www.w3.org/2000/svg" width="19" height="19"
                                    viewBox="0 0 19 19">
                                    <g id="Paper" transform="translate(2.889 2.177)">
                                        <path id="Stroke_1" data-name="Stroke 1" d="M4.275.5H0"
                                            transform="translate(4.161 9.554)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                        <path id="Stroke_2" data-name="Stroke 2" d="M2.657.5H0"
                                            transform="translate(4.16 6.378)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                        <path id="Stroke_3" data-name="Stroke 3"
                                            d="M13.07,4.394,8.582.119A14.408,14.408,0,0,0,6.642,0C1.663,0,0,1.837,0,7.323s1.663,7.323,6.642,7.323,6.65-1.829,6.65-7.323A16.661,16.661,0,0,0,13.07,4.394Z"
                                            transform="translate(0)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                        <path id="Stroke_5" data-name="Stroke 5"
                                            d="M0,0V2.107A2.662,2.662,0,0,0,2.663,4.769H5"
                                            transform="translate(8.142 0.065)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                    </g>
                                </svg>
                            </div>
                            <span class="path__name">All History</span>
                        </div>
                        <div class="group">
                            <span class="short__name"></span>
                            <i class="tio-chevron_right -arrwo"></i>
                        </div>
                    </a>
                </li>
            </ul>
        </div>

        <div class="padding-20">
            <span class="size-12 text-uppercase color-text d-block">Support</span>
        </div>

        <div class="em__pkLink emBlock__border bg-white margin-b-60 border-t-0">
            <ul class="nav__list mb-0">
                <li>
                    <a href="{{$getSetting->chatwidget}}" class="btn item-link">
                        <div class="group">
                            <div class="icon bg-yellow">
                                <svg id="Iconly_Curved_Message" data-name="Iconly/Curved/Message"
                                    xmlns="http://www.w3.org/2000/svg" width="19" height="19"
                                    viewBox="0 0 19 19">
                                    <g id="Message" transform="translate(1.941 2.258)">
                                        <path id="Stroke_1" data-name="Stroke 1"
                                            d="M8.828,0s-2.541,3.05-4.4,3.05S0,0,0,0"
                                            transform="translate(3.121 4.882)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                        <path id="Stroke_3" data-name="Stroke 3"
                                            d="M0,7.217C0,1.8,1.885,0,7.54,0s7.54,1.8,7.54,7.217-1.885,7.217-7.54,7.217S0,12.63,0,7.217Z"
                                            transform="translate(0 0)" fill="none" stroke="#fff"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            stroke-miterlimit="10" stroke-width="1.5" />
                                    </g>
                                </svg>
                            </div>
                            <span class="path__name">Customer Support</span>
                        </div>
                        <div class="group">
                            <span class="short__name"></span>
                            <i class="tio-chevron_right -arrwo"></i>
                        </div>
                    </a>
                </li>
            </ul>
        </div>

    </section>
</div>
</div>

<!-- Smartsupp Live Chat script -->
<script type="text/javascript">
    var _smartsupp = _smartsupp || {};
    _smartsupp.key = 'dd698874f22842354f8e59925053adcdd2153f4d';
    window.smartsupp||(function(d) {
      var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
      s=d.getElementsByTagName('script')[0];c=d.createElement('script');
      c.type='text/javascript';c.charset='utf-8';c.async=true;
      c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
    })(document);
    </script>
    <noscript> </noscript>

    
    @include('layouts.user.footer')
    @include('layouts.user.sidebar')
</x-user>