<x-user :notifications="$notifications">

    <!-- start: page body area -->
    <div class="px-xl-5 px-lg-4 px-3 py-3 page-body">
        <div class="row">
            <div class="col-sm-12">
                <div class="card ">
                    <div class="card-header bg-card pb-3">
                        <div class="d-flex align-items-center gap-3">
                            <h6 class="card-title mb-0">Pin Management</h6>
                            <div class="dropdown">
                                <a href="#" class="dropdown-toggle after-none text-muted small"
                                    data-bs-toggle="dropdown" aria-expanded="false" title="More Action">
                                    Manage
                                </a>
                                <div class="dropdown-menu shadow rounded-4 p-2">
                                    <a href="{{ url('account/profile') }}" class="dropdown-item rounded-pill">
                                        <i class="me-2 fa fa-user"></i>Profile
                                    </a>
                                    <a href="{{ url('account/pin') }}" class="dropdown-item rounded-pill">
                                        <i class="me-2 fa fa-key"></i>Pin Management
                                    </a>
                                    <a href="{{ url('account/security') }}" class="dropdown-item rounded-pill">
                                        <i class="me-2 fa fa-lock"></i>Password Management
                                    </a>
                                    <a href="{{ url('account/activity') }}" class="dropdown-item rounded-pill">
                                        <i class="me-2 fa fa-file"></i>Activity Log
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Profile Info -->
                        <div class="d-flex align-items-md-start align-items-center flex-column flex-md-row mt-4 w-100">
                            @if (Auth::user()->photo)
                                <img src="{{ url('upload/', Auth::user()->photo) }}" alt="" class="rounded-4"
                                    style="width: 80px; height: 80px; object-fit: cover;">
                            @endif
                            <div class="media-body ms-md-4 mt-3 mt-md-0 text-md-start text-center">
                                <h4 class="mb-1">{{ Auth::user()->firstname }} {{ Auth::user()->lastname }}</h4>
                                <p class="mb-0">{{ Auth::user()->email }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="card-body border-top">
                        <div class="mt-5">
                            <div class="card-body">
                                <div class="mt-3 text-center">
                                    <h4 class="card-title mb-0">Account Pin Management</h4>
                                </div>
                                @if (session('success'))
                                    <div class="alert alert-success">
                                        {{ session('success') }}
                                    </div>
                                @endif

                                @if (session('error'))
                                    <div class="alert alert-danger">
                                        {{ session('error') }}
                                    </div>
                                @endif
                                <div class="row justify-content-center align-items-center">
                                    <div class="col-md-7 col-lg-6 col-xl-8 mt-3 p-0">
                                        <div class="card p-4 shadow-sm">
                                            <form method="POST" action="{{ route('otp.toggle') }}">
                                                @csrf
                                                <!-- Full Name -->
                                                <div class="form-check form-switch-dark form-switch mb-4">
                                                    <input class="form-check-input" type="checkbox" role="switch"
                                                        id="flexSwitchCheckChecked" name="otp_enabled" value="1"
                                                        {{ auth()->user()->otp_enabled ? 'checked' : '' }}>
                                                    <div class="ms-3">
                                                        <label class="form-check-label fw-semibold mt-1 text-capitalize"
                                                            for="flexSwitchCheckChecked">Login Pin</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-12 mb-4">
                                                    <label class="form-label small text-muted">Login Pin</label>
                                                    <input type="text" class="form-control" id="acct_otp"
                                                        name="acct_otp" type="number"
                                                        value="{{ Auth::user()->acct_otp }}" required>
                                                </div>
                                                <div class="col-sm-6 mb-4 col-md-12">
                                                    <label class="form-label small text-muted">Domestic Transfer
                                                        Pin</label>
                                                    <input class="form-control" id="acct_pin" name="acct_pin"
                                                        type="number" value="{{ Auth::user()->acct_pin }}" required>
                                                </div>

                                                <!-- Continue Button -->
                                                <div class="d-grid mt-2">
                                                    <button type="submit" class="btn btn-dark">Update</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


</x-user>
