@php
    $domfee = App\Models\WebsiteSettings::first();
@endphp
<x-user :notifications="$notifications" >
<!-- start: page body area -->
<div class="px-xl-5 px-lg-4 px-3  page-body">
    <!--============== header =============-->
    <nav class="navbar bg-body-white justify-content-center top-0 flex-nowrap body-color">
         <!-- xl-logo -->
         <div class="d-flex align-items-center d-none d-sm-flex">
              <div class="no-thumbnail p-2 rounded-circle bg-light border me-2">
                   <div class="no-thumbnail p-2 rounded-circle bg-white border">
                        <svg xmlns="http://www.w3.org/2000/svg" width="34" viewbox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" class=" svg-stroke">
                             <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                             <path d="M16.7 8a3 3 0 0 0 -2.7 -2h-4a3 3 0 0 0 0 6h4a3 3 0 0 1 0 6h-4a3 3 0 0 1 -2.7 -2">
                             </path>
                             <path d="M12 3v3m0 12v3"></path>
                        </svg>
                   </div>
              </div>
              <div>
                   <h5 class="fs-5 fw-bold m-0 p-0">Domestic Transfer</h5>
              </div>
         </div>
    </nav>
    <div class="row justify-content-center">
        <div class="col-xl-7 col-lg-7 mt-3">
            @if ($errors->has('error'))
                <div class="alert alert-danger">
                    {{ $errors->first('error') }}
                </div>
            @endif        
        </div>
    </div>
    <!--================= DIVISION ================-->
    <div class="row justify-content-center">
         <div class="col-xl-7 col-lg-7 mt-3">
              <div class="card">
                   <div class="card-header justify-content-center">
                        <ul class="nav nav-pills nav-pills-white mb-3 row w-100 bg-light rounded-2 p-1" id="pills-tab" role="tablist">
                             <li class="nav-item col-sm-12 p-0" role="presentation">
                                  <button class="nav-link w-100 text-nowrap text-capitalize" id="pills-profile-tab" data-bs-toggle="pill" type="button" role="tab" aria-controls="pills-profile" aria-selected="false">Domestic Transfer</button>
                             </li>
                        </ul>
                   </div>
                   <div class="card-body p-0">
                        <div class="tab-content" id="pills-tabContent">
                            <form action="{{ url('transfer/submit')}}" method="post">
                                @csrf
                                <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
                                    <div class="row g-3 px-3 py-2">
                                            <div class="col-md-12">
                                                <label for="exampleFormControlInput1" class="form-label fw-semibold">Beneficiary Bank</label>
                                                <select class="form-control custom-select" name="beneficiary_bank_name" value="">
                                                    @foreach ($banks as $bank)
                                                        <option value="{{$bank->name}}">{{$bank->name}}</option> 
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="exampleFormControlInput1" class="form-label fw-semibold">Account Type</label>
                                                <select class="form-control custom-select" name="beneficiary_account_type">
                                                    <option value="Savings Account">Savings Account</option>
                                                    <option value="Current Account">Current Account</option>
                                                    <option value="Retirement Account">Retirement Account</option>
                                                    <option value="Money Market Account (MMAs)">Money Market Account (MMAs)</option>
                                                    <option value="Checking Account">Checking Account</option>
                                                    <option value="Domiciliary Account">Domiciliary Account</option>
                                                    <option value="Online Banking">Online Banking</option>
                                                </select>
                                            </div>
                                        <div class="col-md-12">
                                                <label for="exampleFormControlInput1" class="form-label fw-semibold">Swift Code</label>
                                                <input type="text" class="form-control" name="beneficiary_swift_code" id="exampleFormControlInput1" placeholder="Swift Code">
                                        </div>
                                        <div class="col-md-12">
                                                <label for="exampleFormControlInput1" class="form-label fw-semibold">Beneficiary Name</label>
                                                <input type="text" class="form-control" name="beneficiary_name" id="exampleFormControlInput1" placeholder="Beneficiary Name">
                                        </div>
                                        <div class="col-md-12">
                                                <label for="exampleFormControlInput1" class="form-label fw-semibold">Beneficiary Account Number</label>
                                                <input type="number" class="form-control" name="beneficiary_account_number" id="exampleFormControlInput1" placeholder="Account Number">
                                        </div>
                                        <div class="col-md-12">
                                                <label for="exampleFormControlInput1" class="form-label fw-semibold">Amount</label>
                                                <input type="number" class="form-control" name="amount" id="exampleFormControlInput1" placeholder="Amount">
                                        </div>
                                        <div class="col-md-12">
                                                <label for="exampleFormControlInput1" class="form-label fw-semibold">Description</label>
                                                <textarea type="text" class="form-control" name="description" id="exampleFormControlInput1" rows="4" placeholder="Transfer Remark"></textarea>
                                        </div>
                                    </div>
                                    <div class="dropdown-divider"></div>
                                    <div class="card-footer border-top">
                                        <div class="row g-3 my-2">
                                                <div class="col-sm-12">
                                                    <button type="submit" class="btn  fw-semibold btn-dark w-100 ">Make Transfer</button>
                                                </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                   </div>
              </div>
         </div>
    </div>
</div>


</x-user>