@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<x-user :notifications="$notifications" >
    
    <!-- start: page header area -->
    <div class="px-xl-5 px-lg-4 px-3 py-2 page-header flex-wrap">
        <ol class="breadcrumb mb-0 bg-transparent mb-3 mb-sm-0">
             <li class="breadcrumb-item"><a class="text-muted" href="{{ url('account/dashboard')}}" title="home">Home</a></li>
             <li class="breadcrumb-item active" aria-current="page" title="Balance">Loans</li>
        </ol>
        <ul class="list-unstyled action row g-2 mb-0">
             <li class="col-sm-12 col-12">
                  <a href="{{ url('account/getloan')}}" aria-expanded="false"
                       title="exchange" class="btn btn-dark fw-medium w-100">Apply</a>
             </li>
        </ul>
   </div>
   <!-- start: page body area -->
   <div class="px-xl-5 px-lg-4 px-3 py-3 page-body">
        <div class="row g-3 mb-3 row-deck">
            <div class="col-12 col-md-6 col-xl-4">
                <div class="card">
                     <div class="card-header">
                          <h6 class="card-title mb-0">Loan Balance</h6>
                     </div>
                     <div class="card-body">
                          <div class="card">
                               <div class="card-header">
                                    <h6 class="card-title mb-4 me-auto">Total Loan Balance</h6>
                               </div>
                               <div class="card-body">
                                    <h2>{{Auth::user()->acct_currency}}{{number_format(Auth::user()->loan_balance, 2)}}</h2>
                               </div>
                          </div>
                     </div>
                </div>
           </div>
            @foreach($loans as $loan) 
                <div class="col-12 col-md-6 col-xl-4">
                    <div class="card">
                        <div class="card-header">
                                <h6 class="card-title mb-0">Active Loan</h6>
                                <div class="card-action">
                                    <div>
                                    </div>
                                </div>
                        </div>
                        <div class="card-body">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="me-2">
                                        </div>
                                        <h6 class="card-title mb-0 me-auto">{{$loan->loan_type}} Loan</h6>
                                    </div>
                                    <div class="card-body">
                                        <h2 class="mb-3">{{Auth::user()->acct_currency}}{{number_format($loan->loan_amount, 2)}}</h2>
                                        <h6 class="text-muted mt-2">Repayment Balance: {{Auth::user()->acct_currency}}{{number_format($loan->balance, 2)}}</h6> 
                                        <span class="badge 
                                            @if($loan->status == 'Approved')
                                                bg-success
                                            @elseif($loan->status == 'Rejected')
                                                bg-danger
                                            @elseif($loan->status == 'Pending')
                                                bg-warning
                                            @elseif($loan->status == 'Defaulted')
                                                bg-secondary
                                            @else
                                                bg-primary
                                            @endif
                                        ">
                                            {{$loan->status}}
                                        </span>
                                        <span class="text-muted">{{$loan->loan_term}} Months @ {{$loan->interest_rate}}</span>
                                    </div>
                                </div>
                        </div>
                       <div class="m-3">
                            <a href="{{ url('account/loan_repay/'. $loan->id)}}" class="btn btn-grey-outline w-100">Pay Loan</a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
   </div>

</x-user>