@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<x-user :notifications="$notifications">

    <div class="px-xl-5 px-lg-4 px-3 py-3 pt-0 page-body mb-3">
        <!--================= DIVISION ================-->
        <div class="row justify-content-center mt-5">
             <div class="col-sm-6">
                @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
                  <div class="card">
                       <div class="card-header border-bottom">
                            <ul class="list-group">
                                 <li class="list-group-item border-0">
                                      <div class="d-flex align-items-center">
                                           <div
                                                class="no-thumbnail p-2 rounded-circle bg-light border me-2">
                                                <div
                                                     class="no-thumbnail p-2 rounded-circle bg-white border">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" fill="currentColor" viewBox="0 0 512 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                                                        <path d="M320 96L192 96 144.6 24.9C137.5 14.2 145.1 0 157.9 0L354.1 0c12.8 0 20.4 14.2 13.3 24.9L320 96zM192 128l128 0c3.8 2.5 8.1 5.3 13 8.4C389.7 172.7 512 250.9 512 416c0 53-43 96-96 96L96 512c-53 0-96-43-96-96C0 250.9 122.3 172.7 179 136.4c0 0 0 0 0 0s0 0 0 0c4.8-3.1 9.2-5.9 13-8.4zm84 88c0-11-9-20-20-20s-20 9-20 20l0 14c-7.6 1.7-15.2 4.4-22.2 8.5c-13.9 8.3-25.9 22.8-25.8 43.9c.1 20.3 12 33.1 24.7 40.7c11 6.6 24.7 10.8 35.6 14l1.7 .5c12.6 3.8 21.8 6.8 28 10.7c5.1 3.2 5.8 5.4 5.9 8.2c.1 5-1.8 8-5.9 10.5c-5 3.1-12.9 5-21.4 4.7c-11.1-.4-21.5-3.9-35.1-8.5c-2.3-.8-4.7-1.6-7.2-2.4c-10.5-3.5-21.8 2.2-25.3 12.6s2.2 21.8 12.6 25.3c1.9 .6 4 1.3 6.1 2.1c0 0 0 0 0 0s0 0 0 0c8.3 2.9 17.9 6.2 28.2 8.4l0 14.6c0 11 9 20 20 20s20-9 20-20l0-13.8c8-1.7 16-4.5 23.2-9c14.3-8.9 25.1-24.1 24.8-45c-.3-20.3-11.7-33.4-24.6-41.6c-11.5-7.2-25.9-11.6-37.1-15c0 0 0 0 0 0l-.7-.2c-12.8-3.9-21.9-6.7-28.3-10.5c-5.2-3.1-5.3-4.9-5.3-6.7c0-3.7 1.4-6.5 6.2-9.3c5.4-3.2 13.6-5.1 21.5-5c9.6 .1 20.2 2.2 31.2 5.2c10.7 2.8 21.6-3.5 24.5-14.2s-3.5-21.6-14.2-24.5c-6.5-1.7-13.7-3.4-21.1-4.7l0-13.9z"/>
                                                    </svg>
                                                </div>
                                           </div>
                                           <div>
                                                <h5 class="fs-5 fw-bold m-0 p-0">Loan Application</h5>
                                                <p>Get approved with ease.</p>
                                           </div>
                                      </div>
                                 </li>
                            </ul>
                       </div>
                       <div class="card-body">
                            <form action="{{ route('loans.apply') }}" method="POST">
                                @csrf
                                 <div class="mb-3">
                                    <label for="loan_type" class="form-label">Loan Type</label>
                                    <select id="loan_type" name="loan_type" class="form-select" required>
                                        <option value="">-- Select Loan Type --</option>
                                        @foreach($loan as $loans)
                                            <option value="{{$loans->loan_type}}">{{$loans->loan_type}} ({{$loans->min_loan_term}} to {{$loans->max_loan_term}}) Months</option>
                                        @endforeach
                                    </select>
                                 </div>
                                 <div class="mb-3">
                                    <label for="loan_amount">Loan Amount</label>
                                    <input type="number" id="amount" name="loan_amount" class="form-control" required>
                                 </div>
                                 <div class="mb-3">
                                    <label for="loan_term">Loan Term (in months)</label>
                                    <input type="number" id="loan_term" name="loan_term" class="form-control" required>
                                 </div>
                                 <div class="mb-3">
                                    <label for="interest_rate">Interest Rate (%)</label>
                                    <input type="text" id="interest_rate" name="interest_rate" class="form-control" readonly>
                                 </div>
                                 <div class="mb-3">
                                    <label for="balance">Balance to be Paid</label>
                                    <input type="text" id="balance" name="balance" class="form-control" readonly>
                                </div>
                                 <div class="card-footer border-top py-3">
                                      <button type="submit" class="btn btn-dark w-100">Apply</button>
                                 </div>
                            </form>
                       </div>
                  </div>
             </div>
        </div>
    </div>
        
        <!-- JavaScript for fetching interest rate -->
        <script>
            document.getElementById('loan_type').addEventListener('change', fetchInterestRateAndCalculateBalance);
            document.getElementById('loan_term').addEventListener('input', fetchInterestRateAndCalculateBalance);
            document.getElementById('amount').addEventListener('input', fetchInterestRateAndCalculateBalance);
        
            function fetchInterestRateAndCalculateBalance() {
                var loanType = document.getElementById('loan_type').value;
                var loanTerm = document.getElementById('loan_term').value;
                var loanAmount = document.getElementById('amount').value;
                var interestRate = 0;
        
                // Ensure that the loan amount and loan term are valid numbers
                if (loanType && loanTerm && loanAmount) {
                    loanAmount = parseFloat(loanAmount);  // Convert loan amount to float
                    loanTerm = parseInt(loanTerm, 10);  // Convert loan term to integer
                    
                    // Validate that loanAmount and loanTerm are numbers
                    if (isNaN(loanAmount) || isNaN(loanTerm)) {
                        alert("Please enter valid numbers for loan amount and loan term.");
                        return;
                    }
        
                    // Fetch the interest rate based on the loan type
                    fetch(`/get-interest-rate/${loanType}/${loanTerm}`)
                        .then(response => response.json())
                        .then(data => {
                            if (data && !isNaN(data.interest_rate)) {
                                interestRate = parseFloat(data.interest_rate);
        
                                // Calculate total balance to be paid (loan amount + interest)
                                var totalBalance = loanAmount + (loanAmount * interestRate / 100);
                                totalBalance = totalBalance.toFixed(2); // Round to 2 decimal places
        
                                // Update the interest rate and balance inputs
                                document.getElementById('interest_rate').value = interestRate + '%';
                                document.getElementById('balance').value = totalBalance;
                            } else {
                                alert("Interest rate not found for the selected loan type.");
                            }
                        })
                        .catch(error => {
                            console.error('Error fetching interest rate:', error);
                        });
                } else {
                    // Clear fields if required inputs are missing
                    document.getElementById('interest_rate').value = '';
                    document.getElementById('balance').value = '';
                }
            }
        </script>
        
</x-user>