@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<x-user :notifications="$notifications" >

    <div class="px-xl-5 px-lg-4 px-3 py-3 pt-0 page-body">
        <!--================= DIVISION ================-->
        <div class="row justify-content-center mt-4">
             <div class="col-sm-6">
                  <div class="card">
                       <div class="card-header border-bottom">
                            @if (session('message'))
                                <div class="alert alert-success mt-3">
                                    {{ session('message') }}
                                </div>
                            @endif
                        
                            @if ($errors->any())
                                <div class="alert alert-danger mt-3">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                       </div>
                       <div class="card-header border-bottom">
                            <ul class="list-group">
                                 <li class="list-group-item border-0">
                                      <div class="d-flex align-items-center">
                                           <div
                                                class="no-thumbnail p-2 rounded-circle bg-light border me-2">
                                                <div
                                                    class="no-thumbnail p-2 rounded-circle bg-white border">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-cash" viewBox="0 0 16 16">
                                                        <path d="M8 10a2 2 0 1 0 0-4 2 2 0 0 0 0 4"/>
                                                        <path d="M0 4a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H1a1 1 0 0 1-1-1zm3 0a2 2 0 0 1-2 2v4a2 2 0 0 1 2 2h10a2 2 0 0 1 2-2V6a2 2 0 0 1-2-2z"/>
                                                      </svg>
                                                </div>
                                           </div>
                                           <div>
                                                <h5 class="fs-5 fw-bold m-0 p-0">Cheque Deposit</h5>
                                           </div>
                                      </div>
                                 </li>
                            </ul>
                       </div>
                       <div class="card-body">
                            <form action="{{ url('account/deposits/store') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                 <div class="mb-3">
                                      <label for="country" class="form-label">Bank Name</label>
                                      <select class="form-control custom-select" name="bank_name" value="">
                                            @foreach ($banks as $banks)
                                                <option value="{{$banks->name}}">{{$banks->name}}</option> 
                                            @endforeach
                                    </select>
                                    <x-input-error :messages="$errors->get('bank_name')" class="mt-2" />
                                 </div>
                                 <div class="mb-3">
                                      <label for="address-one" class="form-label">Cheque Number</label>
                                      <input class="form-control" name="check_number" type="number" id="formFile" />
                                      <x-input-error :messages="$errors->get('check_number')" class="mt-2" />
                                 </div>
                                 <div class="mb-3">
                                      <label for="address-one" class="form-label">Amount</label>
                                      <input class="form-control" name="amount" type="number" id="formFile" />
                                      <x-input-error :messages="$errors->get('amount')" class="mt-2" />
                                 </div>
                                 <div class="mb-3">
                                      <label for="address-one" class="form-label">Upload Cheque</label>
                                      <input class="form-control" name="check_image" type="file" id="formFile" />
                                      <x-input-error :messages="$errors->get('check_image')" class="mt-2" />
                                 </div>
                                 <div class="card-footer border-top py-3">
                                      <button type="submit" class="btn btn-dark w-100">Submit</button>
                                 </div>
                            </form>
                       </div>
                  </div>
             </div>
        </div>
    </div>
</x-user>