<x-user :notifications="$notifications">
    <!-- start: page body area -->
    <div class="px-xl-5 px-lg-4 px-3 py-3 page-body">
        <div class="row g-3 mb-3 row-deck">
            <div class="col-md-6 col-lg-6 col-xl-6">
                <div class="card">
                    @if (session('success'))
                        <div class="alert alert-success mb-1 alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    <div class="card-body">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>Account Balance</div>
                                    <div class="row gx-0 d-inline-flex">
                                        <div class="col-auto align-self-center">
                                            @if (!empty(Auth::user()->photo))
                                                <img src="{{ url('upload/', Auth::user()->photo) }}" alt="User-Profile"
                                                    class="rounded-circle object-fit-cover"
                                                    style="width: 40px; height: 40px;">
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="py-4 m-0 text-center h1 fw-bold">
                                    {{ Auth::user()->acct_currency }}{{ number_format(Auth::user()->account_balance, 2) }}
                                </div>

                                <div class="d-flex">
                                    <div>
                                        <span
                                            class="badge bg-secondary text-white">{{ Auth::user()->account_type }}</span>
                                    </div>

                                    <div class="ms-auto">
                                        @if (Auth::user()->acct_status === 'Active')
                                            <span class="badge bg-success text-white">Active Account</span>
                                        @elseif(Auth::user()->acct_status === 'Location')
                                            <span class="badge bg-secondary text-white">Inactive Account</span>
                                        @elseif(Auth::user()->acct_status === 'Suspended')
                                            <span class="badge bg-danger text-white">Suspended Account</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
            <div class="col-md-6 col-lg-12 col-xl-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title mb-0">Account Overview</h6>
                    </div>
                    <div class="card-body row bg-light g-0">
                        <div class="col-6">
                            <div class="d-flex align-items-center border-end">
                                <div class="avatar rounded-circle no-thumbnail"><i
                                        class="fa fa-long-arrow-down fa-lg"></i>
                                </div>
                                <div class="flex-fill ms-3 text-truncate">
                                    <div>Total Credit</div>
                                    <div><span
                                            class="fw-medium">{{ Auth::user()->acct_currency }}{{ number_format($totalCredit, 2) }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex align-items-center ms-3">
                                <div class="avatar rounded-circle no-thumbnail"><i
                                        class="fa fa-long-arrow-up fa-lg"></i>
                                </div>
                                <div class="flex-fill ms-3 text-truncate">
                                    <div>Total Debit</div>
                                    <div><span class="fw-medium">{{ Auth::user()->acct_currency }}{{ number_format($totalDebit, 2) }}</span></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body row bg-light g-0" style="margin-top: 10px">
                        <div class="col-6">
                            <div class="d-flex align-items-center border-end">
                                <div class="avatar rounded-circle no-thumbnail"><i class="fa-solid fa-landmark"></i>
                                </div>
                                <div class="flex-fill ms-3 text-truncate">
                                    <div>Loan Balance</div>
                                    <div><span
                                            class="fw-medium">{{ Auth::user()->acct_currency }}{{ number_format(Auth::user()->loan_balance, 2) }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex align-items-center ms-3">
                                <div class="avatar rounded-circle no-thumbnail"><i class="fa-solid fa-dollar-sign"></i>
                                </div>
                                <div class="flex-fill ms-3 text-truncate">
                                    <div>Pending Balance</div>
                                    <div><span class="fw-medium">{{ Auth::user()->acct_currency }}{{ number_format($pendingamount, 2) }}</span></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row g-3 mb-3 row-deck">

            <div class="col-md-6 col-lg-12 col-xl-12">
                <div class="card">
                    <div class="card-header ">
                        <h6 class="card-title mb-0 fw-bold">Recent Transaction</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="border p-4 rounded-2 rounded-4">
                                    <table id="transactionTable" class="display table table-bordered"
                                        style="width:100%">
                                        <thead>
                                            <tr class="text-center">
                                                <th>#</th>
                                                <th>Account Name</th>
                                                <th>Amount</th>
                                                <th>Description</th>
                                                <th>Transaction Type</th>
                                                <th>Date</th>
                                                <th>Status</th>
                                                <th>Receipt</th> <!-- Add Action Column -->
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse ($transactions as $transactions)
                                                <tr class="item_trans" data-id="{{ $transactions->id }}"
                                                    data-reference="{{ $transactions->reference }}"
                                                    data-bank-name="{{ $transactions->bank_name }}"
                                                    data-account-name="{{ $transactions->account_name }}"
                                                    data-amount="{{ $transactions->amount }}"
                                                    data-description="{{ $transactions->description }}"
                                                    data-toggle="modal" data-target="#mdllDetailsTrans">
                                                    <td></td>
                                                    <td>{{ $transactions->account_name }}</td>
                                                    <td>{{ Auth::user()->acct_currency }}{{ number_format($transactions->amount, 2) }}
                                                    </td>
                                                    <td>{{ $transactions->description }}</td>
                                                    <td>{{ $transactions->transaction_type }}</td>
                                                    <td>{{ \Carbon\Carbon::parse($transactions->created_at)->format('d F Y') }}
                                                    </td>
                                                    <td>
                                                        <span>
                                                            @if ($transactions->status === 'Pending')
                                                                <span class="badge bg-warning">Pending</span>
                                                                <!-- Bootstrap primary color -->
                                                            @elseif($transactions->status === 'Processing')
                                                                <span class="badge bg-info">Processing</span>
                                                            @elseif($transactions->status === 'Completed')
                                                                <span class="badge bg-success">Completed</span>
                                                            @elseif($transactions->status === 'Failed')
                                                                <span class="badge bg-danger">Failed</span>
                                                            @endif
                                                        </span>
                                                    </td>
                                                    <td class="text-center">
                                                        @if (in_array($transactions->transaction_type, ['Credit', 'Debit', 'Domestic Transfer']))
                                                            <a href="{{ url('account/domestic_success', ['id' => $transactions->reference]) }}"
                                                                class="btn btn-secondary btn-sm">
                                                                <i class="bi bi-receipt"></i>
                                                            </a>
                                                        @elseif ($transactions->transaction_type === 'Wire Transfer')
                                                            <a href="{{ url('account/transfer_success', ['id' => $transactions->reference]) }}"
                                                                class="btn btn-secondary btn-sm">
                                                                <i class="bi bi-receipt"></i>
                                                            </a>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="100%"> No Record Found.</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <a href="{{ url('account/transactions') }}"
                            class="mt-3 btn btn-grey-outline w-100 fw-medium">Show
                            All</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

</x-user>
