@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<x-user :notifications="$notifications">
    <!-- start: page body area -->
    <div class="px-xl-5 px-lg-4 px-3 py-3 pt-0 page-body">
        <!--================= DIVISION ================-->
        <div class="row justify-content-center mt-4">
            <div class="row g-2 mt-4 animation-element justify-content-center" style="height: 90vh;">
                <div class="col-12 col-md-8 col-lg-6 col-xl-4 col-xxl-4 d-flex flex-column p-0" style="max-width: 600px;">
                    <div class="card-bs d-flex flex-column h-100">
                        <div class="d-flex p-3 border-bottom">
                            <h5 class="fw-bold">Chat with Adrian</h5>
                            <a class="text-sm text-info d-flex flex-row align-items-center gap-2 ms-auto">
                                <span class="spinner-grow spinner-grow-sm" role="status" aria-hidden="true"></span>
                                Online
                            </a>
                        </div>

                        <div class="flex-grow-1 overflow-auto p-2" id="chatbot-messages" style="height: 0;"></div>

                        <div id="chatbot-keywords" class="p-2"></div>
                        <div class="chatbot-input-container">
                            <input type="text" id="chatbot-input" class="form-control" placeholder="Type your message..." />
                            <button class="btn btn-sm btn-primary" type="button" id="send-message"
                                onclick="sendMessageFromInput()">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                    fill="currentColor" class="bi bi-send-fill" viewBox="0 0 16 16">
                                    <path
                                        d="M15.964.686a.5.5 0 0 0-.65-.65L.767 5.855H.766l-.452.18a.5.5 0 0 0-.082.887l.41.26.001.002 4.995 3.178 3.178 4.995.002.002.26.41a.5.5 0 0 0 .886-.083zm-1.833 1.89L6.637 10.07l-.215-.338a.5.5 0 0 0-.154-.154l-.338-.215 7.494-7.494 1.178-.471z" />
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <style>
                #chatbot-input {
                    background-color: #fff;
                    color: #212529;
                }

                @media (prefers-color-scheme: dark) {
                    #chatbot-input {
                        background-color: #1e1e1e;
                        color: #f1f1f1;
                        border-color: #555;
                    }
                }
            </style>

            <style>
                #chatbot-keywords {
                    display: flex;
                    flex-wrap: wrap;
                    gap: 8px;
                    padding: 10px;
                }

                .keyword-button {
                    background: #40440b;
                    color: rgb(49, 49, 49);
                    border: none;
                    padding: 6px 12px;
                    border-radius: 16px;
                    cursor: pointer;
                    font-size: 14px;
                    transition: background 0.3s;
                }

                .keyword-button:hover {
                    background: #0056b3;
                }

                /* Ensures intro message stands out */
                .intro-message {
                    background-color: #f8f9fa !important;
                    border-left: 4px solid #0d6efd;
                    padding: 12px;
                    margin-bottom: 15px;
                }

                /* Keep scrollbar always at bottom */
                #chatbot-messages {
                    overflow-anchor: auto;
                }
            </style>

            <script>
                document.addEventListener("DOMContentLoaded", function() {
                    let chatbotWidget = document.getElementById('chatbot-widget');
                    let chatbotToggle = document.getElementById('chatbot-toggle');
                    let closeChatbot = document.getElementById('close-chatbot');
                    let chatMessages = document.getElementById('chatbot-messages');
                    let floatingMessage = null;
                    let keywordContainer = document.getElementById('chatbot-keywords');

                    function addIntroMessage() {
                        let existingMessages = chatMessages.querySelectorAll('.message').length;
                        if (existingMessages === 0) {
                            let introMessage = document.createElement('div');
                            introMessage.classList.add('message', 'bot-message');
                            introMessage.innerText =
                                "Hello! {{ Auth::user()->firstname }}.  I'm Adrian, How can I assist you today?";
                            chatMessages.appendChild(introMessage);
                            chatMessages.scrollTop = chatMessages.scrollHeight;
                        }
                    }

                    // Toggle chatbot visibility
                    chatbotToggle.addEventListener('click', function() {
                        chatbotWidget.style.display = chatbotWidget.style.display === 'block' ? 'none' : 'block';

                        if (floatingMessage) {
                            floatingMessage.style.opacity = 0;
                            floatingMessage.remove();
                            floatingMessage = null;
                        }

                        if (chatbotWidget.style.display === 'block') {
                            setTimeout(addIntroMessage, 2000);
                        }
                    });

                    closeChatbot.addEventListener('click', function() {
                        chatbotWidget.style.display = 'none';
                        showFloatingMessage("Chat closed! Click to reopen.");
                    });

                    function showFloatingMessage(text) {
                        if (floatingMessage) return;

                        floatingMessage = document.createElement('div');
                        floatingMessage.innerText = text;
                        floatingMessage.classList.add('chatbot-floating-message');

                        document.body.appendChild(floatingMessage);

                        setTimeout(() => {
                            floatingMessage.classList.add('fade-out');
                            setTimeout(() => {
                                floatingMessage.remove();
                                floatingMessage = null;
                            }, 1000);
                        }, 1000);
                    }

                    // Load keyword buttons
                    function fetchKeywords() {
                        const maxKeywords = 6; // 👈 Set your limit here

                        fetch("/chatbot/keywords")
                            .then(res => res.json())
                            .then(data => {
                                // Shuffle the keywords array randomly
                                const shuffled = data.keywords.sort(() => 0.5 - Math.random());

                                // Pick only the first `maxKeywords` from the shuffled array
                                const limitedKeywords = shuffled.slice(0, maxKeywords);

                                // Render the keyword buttons
                                keywordContainer.innerHTML = limitedKeywords.map(keyword => `
                               <button class="btn btn-outline-primary text-white m-1 keyword-button"
                                   onclick="sendMessage('${keyword}')">
                                   ${keyword}
                               </button>
                           `).join('');
                            })
                            .catch(console.error);
                    }


                    fetchKeywords();

                    // Load previous messages from session
                    fetch("/chatbot/messages")
                        .then(res => res.json())
                        .then(data => {
                            chatMessages.innerHTML = "";
                            data.messages.forEach(msg => {
                                let messageDiv = document.createElement('div');
                                messageDiv.classList.add('message', msg.type === 'user' ? 'user-message' :
                                    'bot-message');
                                messageDiv.innerText = msg.text;
                                chatMessages.appendChild(messageDiv);
                            });
                            chatMessages.scrollTop = chatMessages.scrollHeight;
                        });

                    // Handle click on send button
                    window.sendMessage = function(text) {
                        if (!text) return;

                        let userMessage = document.createElement('div');
                        userMessage.classList.add('message', 'user-message');
                        userMessage.innerText = text;
                        chatMessages.appendChild(userMessage);
                        chatMessages.scrollTop = chatMessages.scrollHeight;

                        let typingDiv = document.createElement('div');
                        typingDiv.classList.add('typing-animation');
                        typingDiv.innerHTML = "<span>Adrian is typing...</span>";
                        chatMessages.appendChild(typingDiv);
                        chatMessages.scrollTop = chatMessages.scrollHeight;

                        fetch("/chatbot", {
                                method: "POST",
                                headers: {
                                    "Content-Type": "application/json",
                                    "X-CSRF-TOKEN": "{{ csrf_token() }}"
                                },
                                body: JSON.stringify({
                                    message: text
                                })
                            })
                            .then(res => res.json())
                            .then(data => {
                                setTimeout(() => {
                                    typingDiv.remove();

                                    let botMessage = document.createElement('div');
                                    botMessage.classList.add('message', 'bot-message');
                                    botMessage.innerText = data.response;
                                    botMessage.style.opacity = 0;

                                    chatMessages.appendChild(botMessage);
                                    chatMessages.scrollTop = chatMessages.scrollHeight;

                                    setTimeout(() => botMessage.style.opacity = 1, 200);

                                    // Render keyword buttons if available
                                    if (data.keywords && data.keywords.length > 0) {
                                        // Don't clear existing keywords
                                        data.keywords.forEach(keyword => {
                                            // Only add new keyword buttons if they don't already exist
                                            if (!Array.from(keywordContainer.children).some(btn =>
                                                    btn.innerText === keyword)) {
                                                let btn = document.createElement('button');
                                                btn.classList.add('btn', 'btn-outline-primary',
                                                    'text-white', 'm-1', 'keyword-button');
                                                btn.innerText = keyword;
                                                btn.onclick = () => sendMessage(keyword);
                                                keywordContainer.appendChild(btn);
                                            }
                                        });
                                    }
                                }, 1000);
                            });
                    };

                    // 👇 Add this below
                    window.sendMessageFromInput = function() {
                        const inputField = document.getElementById("chatbot-input");
                        const message = inputField.value.trim();

                        if (message !== "") {
                            sendMessage(message);
                            inputField.value = ""; // Clear the input field
                        }
                    };

                    const inputField = document.getElementById("chatbot-input");
                    inputField.addEventListener("keydown", function(e) {
                        if (e.key === "Enter") {
                            e.preventDefault(); // prevent form submission if inside a form
                            window.sendMessageFromInput();
                        }
                    });

                });
            </script>

        </div>
    </div>



</x-user>
