@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<x-user :notifications="$notifications" >
<!-- start: page body area -->
<div class="px-xl-5 px-lg-4 px-3 py-3 pt-0 page-body">
    <!--============== header =============-->
    <nav class="navbar body-color sticky-top  top-0  body-color">
         <div class="d-flex align-items-center">
              <div>
                   <h5 class="fs-5 fw-bold m-0 p-0">Card Application</h5>
              </div>
         </div>
    </nav>
    <!--================= DIVISION ================-->
    <div class="row justify-content-center mt-4">
         <div class="col-sm-6">
              <div class="card">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                   <div class="card-header border-bottom">
                        <ul class="list-group">
                             <li class="list-group-item border-0">
                                  <div class="d-flex align-items-center">
                                       <div
                                            class="no-thumbnail p-2 rounded-circle bg-light border me-2">
                                            <div
                                                 class="no-thumbnail p-2 rounded-circle bg-white border">
                                                 <svg xmlns="http://www.w3.org/2000/svg" width="32" fill="currentColor" class="bi bi-credit-card-fill" viewBox="0 0 16 16">
                                                       <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v1H0zm0 3v5a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7zm3 2h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1v-1a1 1 0 0 1 1-1"/>
                                                </svg>
                                            </div>
                                       </div>
                                       <div>
                                            <h5 class="fs-5 fw-bold m-0 p-0">Card Application</h5>
                                            <p>Your card application attracts a fee of {{Auth::user()->acct_currency}}{{$getSetting->card_fee}}.</p>
                                       </div>
                                  </div>
                             </li>
                        </ul>
                   </div>
                   <div class="card-body">
                        <form action="{{ url('cards/store') }}" method="post">
                            @csrf
                             <div class="mb-3">
                                  <label for="country" class="form-label">Select Card Type</label>
                                  <select name="card_type" id="card_type" class="form-select custom-select" required>
                                        <option value="">Select Card Type</option>
                                        <option value="Debit">Debit</option>
                                        <option value="Credit">Credit</option>
                                   </select>
                             </div>
                             <div class="mb-3">
                                <label class="form-label">Select Card Brand</label> 
                                <select name="card_brand" id="card_brand" class="form-select custom-select" required>
                                    <option value="">Select Card Brand</option>
                                    <option value="Visa">Visa</option>
                                    <option value="Mastercard">Mastercard</option>
                                    <option value="Amex">American Express</option>
                                    <option value="Discover">Discover</option>
                                </select>
                             </div>
                             <div class="mb-3">
                                  <label for="address-one" class="form-label">Card Pin</label>
                                  <input class="form-control" name="card_pin" type="password" placeholder="Enter 4-digit PIN" maxlength="4" required />
                             </div>
                             <div class="card-footer border-top py-3">
                                  <button type="submit" class="btn btn-dark w-100">Apply</button>
                             </div>
                        </form>
                   </div>
              </div>
         </div>
    </div>
</div>
</x-user>