<x-user>

  <div class="container-fluid mt-4">
    <div class="row align-items-center">
        <div class="col-12 col-sm">
            @if($pendingtransactions > 0)
                <div class="alert alert-info alert-dismissible fade show" role="alert">
                    <i class="bi bi-cash-coin mb-0 h6"></i>
                    You have <strong>{{ $pendingtransactions }}</strong> pending transactions totaling <strong>{{Auth::user()->acct_currency}}{{ number_format($pendingamount, 2) }}</strong>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
        </div>
        <div class="col-12 col-sm-auto text-end py-3 py-sm-0">
            <!-- EXCHANGERATES.ORG.UK LIVE CURRENCY RATES TICKER START -->
<iframe src="//www.exchangerates.org.uk/widget/ER-LRTICKER.php?w=490&s=1&mc=USD&mbg=F2F0FF&bs=no&bc=000044&f=verdana&fs=10px&fc=000044&lc=000044&lhc=FE9A00&vc=FE9A00&vcu=008000&vcd=FF0000&" width="490" height="30" frameborder="0" scrolling="no" marginwidth="0" marginheight="0"></iframe>
<!-- EXCHANGERATES.ORG.UK LIVE CURRENCY RATES TICKER END -->
        </div>
    </div>
</div>
<div class="container mt-4" id="main-content">
    <div class="row">
        <div class="col-12 col-md-6 col-lg-4 mb-4">
            <div class="card adminuiux-card bg-theme-1">
                <div class="card-body z-index-1">
                    <div class="row gx-2 align-items-center mb-4">
                        <div class="col-auto py-1">
                            <div class="avatar avatar-60 bg-white-opacity rounded"><i class="bi bi-wallet h2"></i></div>
                        </div>
                        <div class="col px-0"></div>
                        <div class="col-auto py-2">
                            <a class="btn btn-lg btn-square btn-outline-light" data-bs-toggle="modal" data-bs-target="#qrcodemodal" title="Scan to pay"><i class="bi bi-qr-code"></i></a>
                        </div>
                    </div>
                    <h1>{{Auth::user()->acct_currency}}{{ number_format(Auth::user()->account_balance, 2)}}</h1>
                    <h5 class="opacity-75 fw-normal mb-1">Available balance</h5>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6 col-lg-4">
            <div class="row gx-3">
                <div class="col-6 col-sm-6 col-md-3">
                    <div class="card adminuiux-card mb-3">
                        <div class="card-body z-index-1">
                            <div class="avatar avatar-50 bg-success-subtle text-success rounded mb-2"><i class="bi bi-graph-down-arrow"></i></div>
                            <h4 class="fw-medium mb-0">{{Auth::user()->acct_currency}}{{number_format(Auth::user()->account_limit, 2)}}</h4>
                            <p class="text-secondary small">
                                Account Limit
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-6 col-sm-6 col-md-3">
                    <div class="card adminuiux-card mb-3">
                        <div class="card-body z-index-1">
                            <div class="avatar avatar-50 bg-danger-subtle text-danger rounded mb-2"><i class="bi bi-graph-up-arrow"></i></div>
                            <h4 class="fw-medium mb-0">{{Auth::user()->acct_currency}}{{ number_format($pendingamount, 2) }}</h4>
                            <p class="text-secondary small">
                                Total Pending
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-12 col-lg-4">
            <div class="row">
                <div class="col-12 col-sm-6 col-lg-12">
                    <div class="card adminuiux-card mb-4">
                        <div class="card-body z-index-1">
                            <div class="row">
                                <div class="col-auto">
                                    <div class="avatar avatar-60 bg-theme-1-subtle text-theme-1 rounded"><i class="bi bi-bank h4"></i></div>
                                </div>
                                <div class="col">
                                    <h4 class="fw-medium">{{Auth::user()->acct_currency}}{{ number_format(Auth::user()->loan_balance, 2)}}</h4>
                                    <p class="text-secondary">
                                       Loan Balance  <span class="text-success fs-14"><i class="bi bi-arrow-up"></i> 25.35%</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-sm-6 col-lg-12">
                    <div class="card adminuiux-card mb-4">
                        <div class="card-body z-index-1">
                            <div class="row">
                                <div class="col-auto">
                                    <div class="avatar avatar-60 bg-theme-1-subtle text-theme-1 rounded"><i class="bi bi-cash-coin h4"></i></div>
                                </div>
                                <div class="col">
                                    <h4 class="fw-medium">$3586.15</h4>
                                    <p class="text-secondary">
                                        Mutual Funds <span class="text-success fs-14"><i class="bi bi-arrow-up"></i> 56.51%</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-12 col-lg-12 mb-4">
                    <div class="card adminuiux-card mb-4">
                        <div class="card-header collapse show">
                            <div class="row align-items-center">
                                <div class="col"><h6>Transaction History</h6></div>
                            </div>
                        </div>
                        <div class="card-body py-0">
                            <table id="dataTable" class="table w-100 nowrap">
                                <thead>
                                    <tr>
                                        <th class="all">Reference ID</th>
                                        <th data-breakpoints="xs sm">Account Name</th>
                                        <th data-breakpoints="xs sm md">Description</th>
                                        <th class="all">Amount</th>
                                        <th class="all">Debit/Credit</th>
                                        <th data-breakpoints="xs sm md">Status</th>
                                        <th data-breakpoints="xs sm md">Transaction Date</th>
                                        <th class="all">Receipt</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($transactions as $transactions)
                                    <tr>
                                        <td>{{$transactions->reference}}</td>
                                        <td>{{$transactions->account_name}}</td>
                                        <td>{{$transactions->description}}</td>
                                        <td><h6>{{Auth::user()->acct_currency}}{{ number_format($transactions->amount, 2)}}</h6></td>
                                        <td class="">{{$transactions->transaction_type}}</td>
                                        <td>
                                            @if($transactions->status === 'Pending')
                                                <span class="badge badge-light rounded-pill text-bg-primary">Pending</span> <!-- Bootstrap primary color -->
                                            @elseif($transactions->status === 'Processing')
                                                <span class="badge badge-light rounded-pill text-bg-theme-accent-1">Processing</span>
                                            @elseif($transactions->status === 'Completed')
                                                <span class="badge badge-light rounded-pill text-bg-success">Completed</span>
                                            @elseif($transactions->status === 'Failed')
                                                <span class="badge badge-light rounded-pill text-bg-danger">Failed</span>
                                            @endif
                                        </td>
                                        <td>{{$transactions->transaction_date}}</div>
                                            
                                        </td>
                                        <td>
                                            <button class="btn btn-square btn-link view-details" data-id="{{ $transactions->id }}"><i class="bi bi-receipt"></i></button>
                                        </td>
                                    </tr>
                                    @empty
                                        <tr>
                                            <td colspan="100%"> No Record Found.</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                
                <div class="modal fade adminuiux-modal" id="transactionModal" tabindex="-1" aria-labelledby="transactionModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header d-block" >
                                <div class="row align-items-center gx-3">
                                    <div class="col-12 col-sm">
                                        <p class="text-secondary small mb-0">Invoice ID</p>
                                        <p class="modal-title h5" id="modal-reference"></p>
                                    </div>
                                    <div class="col col-sm-auto">
                                        @if($transactions->status === 'Pending')
                                            <span class="badge badge-light rounded-pill text-bg-primary" id="modal-status">Pending</span> <!-- Bootstrap primary color -->
                                        @elseif($transactions->status === 'Processing')
                                            <span class="badge badge-light rounded-pill text-bg-theme-accent-1" id="modal-status">Processing</span>
                                        @elseif($transactions->status === 'Completed')
                                            <span class="badge badge-light rounded-pill text-bg-success" id="modal-status">Completed</span>
                                        @elseif($transactions->status === 'Failed')
                                            <span class="badge badge-light rounded-pill text-bg-danger" id="modal-status">Failed</span>
                                        @endif
                                    </div>
                                    <div class="col-auto"><button type="button" class="btn-close mx-0" data-bs-dismiss="modal" aria-label="Close"></button></div>
                                </div>
                            </div>
                            <div class="modal-body">
                                <p class="text-secondary small mb-0">Account Name</p>
                                <p id="modal-account-name"></p>
                                <p class="text-secondary small mb-0">Bank Name</p>
                                <p id="modal-bank-name"></p>
                                <p class="text-secondary small mb-0">Account Number</p>
                                <p id="modal-account-number"></p>
                                <p class="text-secondary small mb-0">Amount</p>
                                <p>{{Auth::user()->acct_currency}}<span id="modal-amount"></span></p>
                                <p class="text-secondary small mb-0">Transaction Type</p>
                                <p id="modal-transaction-type"></p>
                                <p class="text-secondary small mb-0">Description</p>
                                <p id="modal-description"></p>
                                <p class="text-secondary small mb-0">Transaction Date</p>
                                <p id="modal-transaction-date"></p>
                                <p class="text-secondary small mb-0">Transfer Instruction</p>
                                <p>Please note that International transfers may take up to four business days to arrive.</p>
                            </div>
                            <div class="modal-footer">
                                <div class="col-auto pe-2">
                                    <button class="btn btn-outline-accent"><i class="bi bi-send"></i> <span>Contact Support</span></button>
                                </div>
                                <div class="col"></div>
                                <div class="col-auto text-end">
                                    <button class="btn btn-square btn-link"><i class="bi bi-printer fs-5"></i></button> <button class="btn btn-square btn-link"><i class="bi bi-file-earmark-pdf fs-5"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </div>
        <div class="col-12 col-md-6 col-lg-4 mb-4">
            <div class="card adminuiux-card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col"><h6>Goals and Saving</h6></div>
                        <div class="col-auto px-0"><a class="btn btn-sm btn btn-link">See All</a></div>
                        <div class="col-auto">
                            <button class="btn btn-sm btn-outline-theme"><i class="bi bi-plus-lg"></i> Create</button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <p class="small text-secondary">Top-Up your saving</p>
                    <div class="row gx-3 py-1 align-items-center">
                        <div class="col-6">
                            <select class="form-select form-select-sm">
                                <option>Goal: Sweet Home</option>
                                <option>Goal: Car</option>
                                <option>Real Estate Fund</option>
                            </select>
                        </div>
                        <div class="col-auto">$</div>
                        <div class="col ps-0"><input type="number" class="form-control form-control-sm" value="100" /></div>
                        <div class="col-auto"><button class="btn btn-sm btn-outline-theme">Invest</button></div>
                    </div>
                </div>
                <ul class="list-group list-group-flush border-top bg-none">
                    <li class="list-group-item">
                        <div class="row gx-3 align-items-center">
                            <div class="col-auto"><i class="bi bi-house avatar avatar-40 h5 rounded-circle border"></i></div>
                            <div class="col">
                                <p class="mb-1 fw-medium">Goal: Sweet Home</p>
                                <p class="small text-secondary">$ 22500.00</p>
                            </div>
                            <div class="col-auto text-end">
                                <h6>$ 4500.00</h6>
                                <p class="small text-secondary">20% Completed</p>
                            </div>
                        </div>
                    </li>
                    <li class="list-group-item">
                        <div class="row gx-3 align-items-center">
                            <div class="col-auto"><i class="bi bi-car-front avatar avatar-40 h5 rounded-circle border"></i></div>
                            <div class="col">
                                <p class="mb-1 fw-medium">Goal: Car</p>
                                <p class="small text-secondary">$ 10500.00</p>
                            </div>
                            <div class="col-auto text-end">
                                <h6>$ 3150.00</h6>
                                <p class="small text-secondary">30% Completed</p>
                            </div>
                        </div>
                    </li>
                    <li class="list-group-item">
                        <div class="row gx-3 align-items-center">
                            <div class="col-auto"><i class="bi bi-percent avatar avatar-40 h5 rounded-circle border"></i></div>
                            <div class="col">
                                <p class="mb-1 fw-medium">Fixed Deposit</p>
                                <p class="small text-secondary">$ 4000.00</p>
                            </div>
                            <div class="col-auto text-end">
                                <h6>$ 4280.00</h6>
                                <p class="small text-secondary">7.25% Interest</p>
                            </div>
                        </div>
                    </li>
                    <li class="list-group-item">
                        <div class="row gx-3 align-items-center">
                            <div class="col-auto"><i class="bi bi-percent avatar avatar-40 h5 rounded-circle border"></i></div>
                            <div class="col">
                                <p class="mb-1 fw-medium">Fixed Deposit</p>
                                <p class="small text-secondary">$ 4500.00, 24/45 mo.</p>
                            </div>
                            <div class="col-auto text-end">
                                <h6>$ 4280.00</h6>
                                <p class="small text-secondary">8.00% Interest</p>
                            </div>
                        </div>
                    </li>
                    <li class="list-group-item">
                        <div class="row gx-3 align-items-center">
                            <div class="col-auto"><i class="bi bi-calendar-event avatar avatar-40 h5 rounded-circle border"></i></div>
                            <div class="col">
                                <p class="mb-1 fw-medium">Real Estate Fund</p>
                                <p class="small text-secondary">$ 1500.00</p>
                            </div>
                            <div class="col-auto text-end">
                                <h6>$ 1850.00</h6>
                                <p class="small text-secondary">25.15% Profit</p>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<!-- Include jQuery and Bootstrap JS -->

</x-user>