@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
    <title>{{ $getSetting->website_name }}</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="financial dashboard">
    <meta name="keyword" content="financial dashboard, financial reporting, admin panel, finance management">
    <!--[ Favicon]-->
    <link rel="icon" type="image/x-icon" href="/user/assets/images/favicon.ico">
    <link rel="icon" type="image/png" sizes="16x16" href="/user/assets/images/favicon-16x16.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/user/assets/images/favicon-32x32.png">
    <link rel="apple-touch-icon" sizes="180x180" href="/user/assets/images/apple-touch-icon.png">
    <!--[ Template main css file ]-->
    <link rel="stylesheet" href="/user/assets/css/style.min.css">
    <!--============== active class js =============-->
    <script src="/user/assets/js/active-class.js"></script>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
</head>

<body data-theme="theme-FrenchRose" class="svgstroke-a">
    <nav class="navbar navbar-expand-md position-fixed top-0 w-100 z-3 body-color ">
        <div class="container-fluid">
            <a class="navbar-brand" href="{{ url('/') }}">
                <img src="{{ url('upload/' . $getSetting->website_logo) }}" width="144" height="44" alt="">
            </a>
            <div class="d-flex d-sm-none">
                <button class="navbar-toggler ms-3 d-none" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </div>
            <div class="d-none d-sm-block">
                <ul class="list-unstyled d-none">
                    <li class="nav-item dropdown px-md-1">
                        <a class="dropdown-toggle gray-6" href="#" id="bd-theme-one" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            <svg width="20" height="20" fill="currentColor" viewBox="0 0 24 24"
                                class="theme-icon-active">
                                <use href="#sun-fill"></use>
                            </svg>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end p-2 p-xl-3 shadow rounded-4"
                            aria-labelledby="bd-theme-one" style="">
                            <li class="mb-1">
                                <a class="dropdown-item rounded-pill" href="#" data-bs-theme-value="light">
                                    <svg class="avatar xs me-2 opacity-50 theme-icon" fill="currentColor">
                                        <use href="#sun-fill"></use>
                                    </svg>
                                    Light
                                </a>
                            </li>
                            <li class="mb-1">
                                <a class="dropdown-item rounded-pill active" href="#" data-bs-theme-value="dark">
                                    <svg class="avatar xs me-2 opacity-50 theme-icon" fill="currentColor">
                                        <use href="#moon-stars-fill"></use>
                                    </svg>
                                    Dark
                                </a>
                            </li>
                            <li class="mb-1">
                                <a class="dropdown-item rounded-pill" href="#" data-bs-theme-value="auto">
                                    <svg class="avatar xs me-2 opacity-50 theme-icon" fill="currentColor">
                                        <use href="#circle-half"></use>
                                    </svg>
                                    Auto
                                </a>
                            </li>
                        </ul>
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                            viewBox="0 0 16 16" style="display: none;">
                            <symbol id="sun-fill" viewBox="0 0 16 16">
                                <path
                                    d="M12 8a4 4 0 1 1-8 0 4 4 0 0 1 8 0zM8 0a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 0zm0 13a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 13zm8-5a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2a.5.5 0 0 1 .5.5zM3 8a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2A.5.5 0 0 1 3 8zm10.657-5.657a.5.5 0 0 1 0 .707l-1.414 1.415a.5.5 0 1 1-.707-.708l1.414-1.414a.5.5 0 0 1 .707 0zm-9.193 9.193a.5.5 0 0 1 0 .707L3.05 13.657a.5.5 0 0 1-.707-.707l1.414-1.414a.5.5 0 0 1 .707 0zm9.193 2.121a.5.5 0 0 1-.707 0l-1.414-1.414a.5.5 0 0 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .707zM4.464 4.465a.5.5 0 0 1-.707 0L2.343 3.05a.5.5 0 1 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .708z">
                                </path>
                            </symbol>
                            <symbol id="moon-stars-fill" viewBox="0 0 16 16">
                                <path
                                    d="M6 .278a.768.768 0 0 1 .08.858 7.208 7.208 0 0 0-.878 3.46c0 4.021 3.278 7.277 7.318 7.277.527 0 1.04-.055 1.533-.16a.787.787 0 0 1 .81.316.733.733 0 0 1-.031.893A8.349 8.349 0 0 1 8.344 16C3.734 16 0 12.286 0 7.71 0 4.266 2.114 1.312 5.124.06A.752.752 0 0 1 6 .278z">
                                </path>
                                <path
                                    d="M10.794 3.148a.217.217 0 0 1 .412 0l.387 1.162c.173.518.579.924 1.097 1.097l1.162.387a.217.217 0 0 1 0 .412l-1.162.387a1.734 1.734 0 0 0-1.097 1.097l-.387 1.162a.217.217 0 0 1-.412 0l-.387-1.162A1.734 1.734 0 0 0 9.31 6.593l-1.162-.387a.217.217 0 0 1 0-.412l1.162-.387a1.734 1.734 0 0 0 1.097-1.097l.387-1.162zM13.863.099a.145.145 0 0 1 .274 0l.258.774c.115.346.386.617.732.732l.774.258a.145.145 0 0 1 0 .274l-.774.258a1.156 1.156 0 0 0-.732.732l-.258.774a.145.145 0 0 1-.274 0l-.258-.774a1.156 1.156 0 0 0-.732-.732l-.774-.258a.145.145 0 0 1 0-.274l.774-.258c.346-.115.617-.386.732-.732L13.863.1z">
                                </path>
                            </symbol>
                            <symbol id="circle-half" viewBox="0 0 16 16">
                                <path d="M8 15A7 7 0 1 0 8 1v14zm0 1A8 8 0 1 1 8 0a8 8 0 0 1 0 16z"></path>
                            </symbol>
                        </svg>
                    </li>
                    <li class="nav-item dropdown px-md-1">
                        <a class="dropdown-toggle gray-6" href="#offcanvas_setting" data-bs-toggle="offcanvas"
                            aria-expanded="false" title="template setting">
                            <svg class="svg-stroke" xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                viewBox="0 0 24 24" stroke="currentColor" fill="none" stroke-linecap="round"
                                stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path
                                    d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z">
                                </path>
                                <path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0"></path>
                            </svg>
                        </a>
                    </li>
                </ul>
                <p class="text-muted">
                    <a class="text-reverse text-decoration-underline" href="{{ url('register') }}">Open An Account</a>
                </p>
            </div>
        </div>
    </nav>
    <main class="container-fluid px-0">
        <!-- start: page menu link -->
        <div class="content">
            <!-- start: page body area -->
            <div class="px-xl-5 px-lg-4 px-3 py-3 page-body my-2 py-2">
                <div style="height: 90vh;" class="row justify-content-center align-items-center">
                    <div class="col-xl-4 col-lg-5 col-md-7">
                        <div class="card">
                            <div class="card-body">
                                @if (session('success'))
                                    <div class="alert alert-success text-center">
                                        {{ session('success') }}
                                    </div>
                                @endif

                                @if (session('error'))
                                    <div class="alert alert-danger text-center">
                                        {{ session('error') }}
                                    </div>
                                @endif

                                @if (session('warning'))
                                    <div class="alert alert-warning text-center">
                                        {{ session('warning') }}
                                    </div>
                                @endif
                                <div class="d-flex flex-column align-items-center ">
                                    <div class="mt-4 ">
                                        <h4 class="text-capitalize text-center fw-bold">Enter Access Code
                                        </h4>
                                        <span class="text-muted text-capitalize">Enter the Access code Provided to
                                            Register</span>
                                    </div>
                                    <div class="mt-3 w-100">
                                        <form method="POST" action="{{ route('access-code.submit') }}"
                                            class="form-horizontal" id="validateForm">
                                            @csrf
                                            <!--=== email ===-->
                                            <div class="mb-3 mt-4">
                                                <div class="input-group">
                                                    <span class="input-group-text bg-transparent">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                            viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                            stroke-linecap="round" stroke-linejoin="round"
                                                            class=" svg-stroke">
                                                            <path stroke="none" d="M0 0h24v24H0z" fill="none">
                                                            </path>
                                                            <path
                                                                d="M5 13a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v6a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z">
                                                            </path>
                                                            <path d="M8 11v-4a4 4 0 1 1 8 0v4">
                                                            </path>
                                                            <path d="M15 16h.01"></path>
                                                            <path d="M12.01 16h.01"></path>
                                                            <path d="M9.02 16h.01"></path>
                                                        </svg>
                                                    </span>
                                                    <input type="text" class="form-control border-start-0"
                                                        style="color: #ffffff;" name="code"
                                                        placeholder="Enter access code" required autofocus>
                                                </div>
                                                <x-input-error :messages="$errors->get('code')" class="mt-2" />
                                            </div>
                                            <!-- Button -->
                                            <div class="form-group" style="margin-top:50px;">
                                                <button type="submit" class="btn btn-info text-white w-100">GRANT ACCESS</button>
                                            </div>
                                            </fieldset>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <footer class="w-100 bg-body position-fixed bottom-0">
        <div class="container-fluid">
            <div class="d-flex align-items-center">
                <div class="p-0 m-0">
                    <a class="link-offset-2 link-offset-3-hover link-underline link-underline-opacity-0 link-underline-opacity-75-hover text-reverse"
                        href="#">@2024 Fintechweb</a>
                </div>
            </div>
        </div>
    </footer>

    <script>
        @if (Session::has('message'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "iconClass": 'toast-success', // Custom icon for success
                "timeOut": "5000", // Optional timeout
            }
            toastr.success("<i class='fa fa-check-circle'></i> {{ session('message') }}");
        @endif

        @if (Session::has('error'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "iconClass": 'toast-error', // Custom icon for error
                "timeOut": "5000",
            }
            toastr.error("<i class='fa fa-times-circle'></i> {{ session('error') }}");
        @endif

        @if (Session::has('info'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "iconClass": 'toast-info', // Custom icon for info
                "timeOut": "5000",
            }
            toastr.info("<i class='fa fa-info-circle'></i> {{ session('info') }}");
        @endif

        @if (Session::has('warning'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "iconClass": 'toast-warning', // Custom icon for warning
                "timeOut": "9000",
            }
            toastr.warning("<i class='fa fa-exclamation-circle'></i> {{ session('warning') }}");
        @endif
    </script>

    <!--[ FintechWeb template vender js ]-->
    <script src="/user/assets/bundles/libscripts.bundle.js"></script>
    <script src="/user/assets/bundles/dynamicselect.js"></script>
    <!-- Template page js -->
    <script src="/user/assets/js/main.js" defer></script>
</body>

</html>
