<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use DB;
use App\Models\InterestRate;

class InterestRateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('interest_rates')->insert([
            // Personal Loan
            ['loan_type' => 'Personal', 'min_loan_term' => 12, 'max_loan_term' => 12, 'interest_rate' => 5.00],
            ['loan_type' => 'Personal', 'min_loan_term' => 13, 'max_loan_term' => 24, 'interest_rate' => 6.50],
            ['loan_type' => 'Personal', 'min_loan_term' => 25, 'max_loan_term' => 36, 'interest_rate' => 7.50],

            // Mortgage Loan
            ['loan_type' => 'Mortgage', 'min_loan_term' => 60, 'max_loan_term' => 120, 'interest_rate' => 3.00],
            ['loan_type' => 'Mortgage', 'min_loan_term' => 121, 'max_loan_term' => 240, 'interest_rate' => 3.75],
            ['loan_type' => 'Mortgage', 'min_loan_term' => 241, 'max_loan_term' => 360, 'interest_rate' => 4.50],

            // Auto Loan
            ['loan_type' => 'Auto', 'min_loan_term' => 12, 'max_loan_term' => 36, 'interest_rate' => 4.00],
            ['loan_type' => 'Auto', 'min_loan_term' => 37, 'max_loan_term' => 60, 'interest_rate' => 5.00],

            // Education Loan
            ['loan_type' => 'Education', 'min_loan_term' => 12, 'max_loan_term' => 24, 'interest_rate' => 3.50],
            ['loan_type' => 'Education', 'min_loan_term' => 25, 'max_loan_term' => 48, 'interest_rate' => 4.25],
            ['loan_type' => 'Education', 'min_loan_term' => 49, 'max_loan_term' => 72, 'interest_rate' => 5.00],
        ]);

    }
}
