<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up() {
        Schema::create('chatbot_messages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained('users')->onDelete('cascade'); // Track user
            $table->text('message'); // User's message
            $table->text('response'); // Bot's reply
            $table->timestamps();
        });
    }

    public function down() {
        Schema::dropIfExists('chatbot_messages');
    }
};
