<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('wire_transfers', function (Blueprint $table) {
            $table->decimal('fee', 10, 2)->after('amount')->default(0.00);
            $table->string('transaction_type')->after('fee')->default('wire_transfer');
        });
    }

    public function down()
    {
        Schema::table('wire_transfers', function (Blueprint $table) {
            $table->dropColumn(['fee', 'transaction_type']);
        });
    }
};
